//*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcSDIMUX12G_RegAccess.h *#*#*#*#*#*#*# (C) 2019 DekTec
//
// Device driver - SdiMux12G v0 (SDIMUX12G) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block SdiMux12G.
// These functions should solely be used by the block controller for SdiMux12G.
//
// 2019.05.29 8:48 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'Link0' and 'Link1' from register 'InputFifoLoad':
//      UInt32  Reg_InputFifoLoad, Link0, Link1;
//      Reg_InputFifoLoad = SDIMUX12G_InputFifoLoad_READ(pBc);
//      Link0             = SDIMUX12G_InputFifoLoad_GET_Link0(Reg_InputFifoLoad);
//      Link1             = SDIMUX12G_InputFifoLoad_GET_Link1(Reg_InputFifoLoad);
//
// 2. Single-function shorthand for reading field 'LinkSyncStatus' from register 'Status':
//      UInt32  LinkSyncStatus = SDIMUX12G_Status_READ_LinkSyncStatus(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// SDIMUX12G_Control_READ
// SDIMUX12G_Control_SET_BlockEnable
// SDIMUX12G_Control_SET_OperationalMode
// SDIMUX12G_Control_WRITE
// SDIMUX12G_InputFifoLoad_GET_Link0
// SDIMUX12G_InputFifoLoad_GET_Link1
// SDIMUX12G_InputFifoLoad_GET_Link2
// SDIMUX12G_InputFifoLoad_GET_Link3
// SDIMUX12G_InputFifoLoad_READ
// SDIMUX12G_InputFifoLoad_READ_Link0
// SDIMUX12G_InputFifoLoad_READ_Link1
// SDIMUX12G_InputFifoLoad_READ_Link2
// SDIMUX12G_InputFifoLoad_READ_Link3
// SDIMUX12G_Status_GET_LinkSyncStatus
// SDIMUX12G_Status_READ
// SDIMUX12G_Status_READ_LinkSyncStatus

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'BlockEnable'
#define SDIMUX12G_BLKENA_DISABLED           0x0  // Block is entirely disabled
#define SDIMUX12G_BLKENA_ENABLED            0x1  // Block is enabled and processes data

// Value map 'OperationalMode'
#define SDIMUX12G_OPMODE_IDLE               0x0  // Block is inactive
#define SDIMUX12G_OPMODE_STANDBY            0x1  // Block is partially operational
#define SDIMUX12G_OPMODE_RUN                0x2  // Block performs its normal function

// Value map 'LinkSyncStatus'
#define SDIMUX12G_LINKSYNCSTATUS_Idle       0x0  // Link synchronization is disabled
#define SDIMUX12G_LINKSYNCSTATUS_WaitFirst  0x1  // Out of sync - Waiting for first SOF
#define SDIMUX12G_LINKSYNCSTATUS_WaitOther  0x2  // Out of sync - Waiting for SOFs from
                                                 // other links
#define SDIMUX12G_LINKSYNCSTATUS_InSync     0x3  // Links are in sync

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  SDIMUX12G_Control_READ(DtBcSDIMUX12G* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field SET functions
static __inline UInt32  SDIMUX12G_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32  SDIMUX12G_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}

// Register WRITE function
static __inline void  SDIMUX12G_Control_WRITE(DtBcSDIMUX12G* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x4, Control);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  SDIMUX12G_Status_READ(DtBcSDIMUX12G* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field GET function
static __inline UInt32  SDIMUX12G_Status_GET_LinkSyncStatus(UInt32 Status)
{
    return Status & 0x3;
}

// Field READ function
static __inline UInt32  SDIMUX12G_Status_READ_LinkSyncStatus(DtBcSDIMUX12G* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8) & 0x3;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'InputFifoLoad' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  SDIMUX12G_InputFifoLoad_READ(DtBcSDIMUX12G* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC);
}

// Field GET functions
static __inline UInt32  SDIMUX12G_InputFifoLoad_GET_Link0(UInt32 InputFifoLoad)
{
    return InputFifoLoad & 0xFF;
}
static __inline UInt32  SDIMUX12G_InputFifoLoad_GET_Link1(UInt32 InputFifoLoad)
{
    return (InputFifoLoad & 0xFF00) >> 8;
}
static __inline UInt32  SDIMUX12G_InputFifoLoad_GET_Link2(UInt32 InputFifoLoad)
{
    return (InputFifoLoad & 0xFF0000) >> 16;
}
static __inline UInt32  SDIMUX12G_InputFifoLoad_GET_Link3(UInt32 InputFifoLoad)
{
    return (InputFifoLoad & 0xFF000000) >> 24;
}

// Field READ functions
static __inline UInt32  SDIMUX12G_InputFifoLoad_READ_Link0(DtBcSDIMUX12G* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC) & 0xFF;
}
static __inline UInt32  SDIMUX12G_InputFifoLoad_READ_Link1(DtBcSDIMUX12G* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0xFF00) >> 8;
}
static __inline UInt32  SDIMUX12G_InputFifoLoad_READ_Link2(DtBcSDIMUX12G* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0xFF0000) >> 16;
}
static __inline UInt32  SDIMUX12G_InputFifoLoad_READ_Link3(DtBcSDIMUX12G* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0xFF000000) >> 24;
}

