//*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcKA.h *#*#*#*#*#*#*#*#*#*#*#* (C) 2018 DekTec
//
//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Copyright (C) 2017 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

#ifndef __DT_BC_KA_H
#define __DT_BC_KA_H

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Include files -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-
#include "DtBc.h"

// Name and short-name of the KeepAlive block (must match block ID)
#define DT_BC_KA_NAME        "KeepAlive"
#define DT_BC_KA_SHORTNAME   "KA"

// MACRO: to init an block-controller-ID for the KA-BC
#define DT_BC_KA_INIT_ID(ID, ROLE, INSTANCE, UUID)                                       \
do                                                                                       \
{                                                                                        \
    DT_BC_INIT_ID(ID, DT_BC_KA_NAME, DT_BC_KA_SHORTNAME, ROLE, INSTANCE, UUID);          \
}                                                                                        \
while (0)


//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ DtBcKA definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- DtBcKA -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.
typedef  struct _DtBcKA
{
    // NOTE: common block data must be the first members to allow casting to DtBc
    DT_BC_COMMON_DATA;
    Bool  m_AutoKeepAlive;   // If true, keep-alive pulses are generated by the driver
    Bool  m_FailSafeEnabled; // Failsafe enabled, if false keep-alive is not pulsed
    Int  m_WatchDogTimeout;  // Keep-alive watchdog timeout in millisecond
    Int  m_TodPeriod;        // Periodic time interval in milliseconds
    Int  m_AliveCnt;         // Incremented on each timer interupt, reset on Pulse()
    Int  m_AliveTimeoutCnt;  // Calculated counter value when timeout is reached
    DtSpinLock  m_KaLock;    // Keep-alive data spinlock
}  DtBcKA;

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- DtBcKA public functions -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.
void  DtBcKA_Close(DtBc*);
DtBcKA*  DtBcKA_Open(Int  Address, DtCore*, DtPt*  pPt, 
                          const char*  pRole, Int  Instance, Int  Uuid, Bool  CreateStub);
DtStatus  DtBcKA_GetFailSafeInfo(DtBcKA*, Bool* pFailSafeEnable, Int* pTimeout,
                                                                           Bool*  pAlive);
DtStatus  DtBcKA_Pulse(DtBcKA* pBc);
DtStatus  DtBcKA_SetAutoKeepAlive(DtBcKA* pBc, Bool  AutoKeepAlive, Int Timeout);
DtStatus  DtBcKA_SetFailSafeConfig(DtBcKA* pBc, Bool FailSafeEnable, Int Timeout);


//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ DtIoStubBcKA definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- DtIoStubBcKA -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-
//  Io-control stub for an KA Block
typedef struct _DtIoStubBcKA
{
    // NOTE: common stub data must be the first members to allow casting to 
    // DtBcIoCtl
    DT_IOSTUB_BC_COMMON_DATA;
}  DtIoStubBcKA;


//.-.-.-.-.-.-.-.-.-.-.-.-.-.- DtIoStubBcKA public functions -.-.-.-.-.-.-.-.-.-.-.-.-.-.-
void  DtIoStubBcKA_Close(DtIoStub*);
DtIoStubBcKA*  DtIoStubBcKA_Open(DtBc*);


#endif  // #ifndef __DT_BC_KA_H