//*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcIQFIR_RegAccess.h *#*#*#*#*#*#*#*# (C) 2019 DekTec
//
// Device driver - IqFirFilter v-1 (IQFIR) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block IqFirFilter.
// These functions should solely be used by the block controller for IqFirFilter.
//
// 2019.03.26 8:50 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'NumberCoefficients' and 'CoefficientSize' from register
//    'Configuration':
//      UInt32  Reg_Configuration, NumberCoefficients, CoefficientSize;
//      Reg_Configuration  = IQFIR_Configuration_READ(pBc);
//      NumberCoefficients =
// IQFIR_Configuration_GET_NumberCoefficients(Reg_Configuration);
//      CoefficientSize    = IQFIR_Configuration_GET_CoefficientSize(Reg_Configuration);
//
// 2. Single-function shorthand for reading field 'Ready' from register
//    'FilterCoefControl':
//      UInt32  Ready = IQFIR_FilterCoefControl_READ_Ready(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// IQFIR_Configuration_GET_CoefficientSize
// IQFIR_Configuration_GET_NumberCoefficients
// IQFIR_Configuration_READ
// IQFIR_Configuration_READ_CoefficientSize
// IQFIR_Configuration_READ_NumberCoefficients
// IQFIR_FilterCoefControl_GET_Ready
// IQFIR_FilterCoefControl_READ
// IQFIR_FilterCoefControl_READ_Ready
// IQFIR_FilterCoefControl_SET_ClearFifo
// IQFIR_FilterCoefControl_SET_DataDirection
// IQFIR_FilterCoefControl_SET_Start
// IQFIR_FilterCoefControl_WRITE
// IQFIR_FilterCoefData_READ
// IQFIR_FilterCoefData_WRITE

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'Direction'
#define IQFIR_CMD_READ   0x0  // Read coefficients
#define IQFIR_CMD_WRITE  0x1  // Write coefficients

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Configuration' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  IQFIR_Configuration_READ(DtBcIQFIR_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field GET functions
static __inline UInt32  IQFIR_Configuration_GET_NumberCoefficients(UInt32 Configuration)
{
    return Configuration & 0xFFFF;
}
static __inline UInt32  IQFIR_Configuration_GET_CoefficientSize(UInt32 Configuration)
{
    return (Configuration & 0xFFFF0000) >> 16;
}

// Field READ functions
static __inline UInt32  IQFIR_Configuration_READ_NumberCoefficients(DtBcIQFIR_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4) & 0xFFFF;
}
static __inline UInt32  IQFIR_Configuration_READ_CoefficientSize(DtBcIQFIR_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0xFFFF0000) >> 16;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FilterCoefControl' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  IQFIR_FilterCoefControl_READ(DtBcIQFIR_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field GET function
static __inline UInt32  IQFIR_FilterCoefControl_GET_Ready(UInt32 FilterCoefControl)
{
    return FilterCoefControl & 0x1;
}

// Field READ function
static __inline UInt32  IQFIR_FilterCoefControl_READ_Ready(DtBcIQFIR_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8) & 0x1;
}

// Field SET functions
static __inline UInt32  IQFIR_FilterCoefControl_SET_Start(UInt32 FilterCoefControl, UInt32 Start)
{
    DT_ASSERT((Start & ~0x1) == 0);
    return (FilterCoefControl & ~0x2) | (Start << 1);
}
static __inline UInt32  IQFIR_FilterCoefControl_SET_ClearFifo(UInt32 FilterCoefControl, UInt32 ClearFifo)
{
    DT_ASSERT((ClearFifo & ~0x1) == 0);
    return (FilterCoefControl & ~0x4) | (ClearFifo << 2);
}
static __inline UInt32  IQFIR_FilterCoefControl_SET_DataDirection(UInt32 FilterCoefControl, UInt32 DataDirection)
{
    DT_ASSERT((DataDirection & ~0x1) == 0);
    return (FilterCoefControl & ~0x8) | (DataDirection << 3);
}

// Register WRITE function
static __inline void  IQFIR_FilterCoefControl_WRITE(DtBcIQFIR_2132* pBc, UInt32 FilterCoefControl)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x8, FilterCoefControl);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FilterCoefData' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  IQFIR_FilterCoefData_READ(DtBcIQFIR_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC) & 0xFFFF;
}

// Field WRITE function
static __inline void  IQFIR_FilterCoefData_WRITE(DtBcIQFIR_2132* pBc, UInt32 FilterCoefData)
{
    DT_ASSERT((FilterCoefData & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0xC, FilterCoefData);
}

