// #*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcFMBC_RegAccess.h *#*#*#*#*#*#*#*#*#*#*#*#*#*# 2024
//
// Device driver - FpgaMailboxClient v0 (FMBC) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block FpgaMailboxClient.
// These functions should solely be used by the block controller for FpgaMailboxClient.
//
// 2024.08.15 10:28:18 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND.

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2024 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN No EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//
// 1. Getting fields 'CmdFifoDepth' and 'RespFifoDepth' from register 'Config':
//      UInt32 Reg_Config, CmdFifoDepth, RespFifoDepth;
//      Reg_Config    = FMBC_Config_READ(Bc);
//      CmdFifoDepth  = FMBC_Config_GET_CmdFifoDepth(Reg_Config);
//      RespFifoDepth = FMBC_Config_GET_RespFifoDepth(Reg_Config);
//
// 2. Single-function shorthand for reading field 'RdRespEmpty' from register
//    'MailboxClientS10_IntStatus':
//      UInt32  RdRespEmpty = FMBC_MailboxClientS10_IntStatus_READ_RdRespEmpty(Bc);
//
// Updating multiple fields in the same register:
//   UInt32  Reg_MailboxClientS10_CommandHdr = FMBC_MailboxClientS10_CommandHdr_READ(Bc);
//   FMBC_MailboxClientS10_CommandHdr_SET_CmdCode(Reg_MailboxClientS10_CommandHdr, 1);
//   FMBC_MailboxClientS10_CommandHdr_SET_Length(Reg_MailboxClientS10_CommandHdr, 1);
//   FMBC_MailboxClientS10_CommandHdr_WRITE(Bc, Reg_MailboxClientS10_CommandHdr);
//
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

// +=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// FMBC_Config_GET_ClkFreqMHz
// FMBC_Config_GET_CmdFifoDepth
// FMBC_Config_GET_RespFifoDepth
// FMBC_Config_READ
// FMBC_Config_READ_ClkFreqMHz
// FMBC_Config_READ_CmdFifoDepth
// FMBC_Config_READ_RespFifoDepth
// FMBC_MailboxClientS10_CmdSpace_READ_CmdSpace
// FMBC_MailboxClientS10_CmdTimeout_GET_Enable
// FMBC_MailboxClientS10_CmdTimeout_GET_Period
// FMBC_MailboxClientS10_CmdTimeout_READ
// FMBC_MailboxClientS10_CmdTimeout_SET_Enable
// FMBC_MailboxClientS10_CmdTimeout_SET_Period
// FMBC_MailboxClientS10_CmdTimeout_WRITE
// FMBC_MailboxClientS10_CommandData_READ_CommandData
// FMBC_MailboxClientS10_CommandData_WRITE_CommandData
// FMBC_MailboxClientS10_CommandEopData_READ_CommandEopData
// FMBC_MailboxClientS10_CommandEopData_WRITE_CommandEopData
// FMBC_MailboxClientS10_CommandEopHdr_GET_CmdCode
// FMBC_MailboxClientS10_CommandEopHdr_GET_ID
// FMBC_MailboxClientS10_CommandEopHdr_GET_Length
// FMBC_MailboxClientS10_CommandEopHdr_READ
// FMBC_MailboxClientS10_CommandEopHdr_SET_CmdCode
// FMBC_MailboxClientS10_CommandEopHdr_SET_ID
// FMBC_MailboxClientS10_CommandEopHdr_SET_Length
// FMBC_MailboxClientS10_CommandEopHdr_WRITE
// FMBC_MailboxClientS10_CommandHdr_GET_CmdCode
// FMBC_MailboxClientS10_CommandHdr_GET_ID
// FMBC_MailboxClientS10_CommandHdr_GET_Length
// FMBC_MailboxClientS10_CommandHdr_READ
// FMBC_MailboxClientS10_CommandHdr_SET_CmdCode
// FMBC_MailboxClientS10_CommandHdr_SET_ID
// FMBC_MailboxClientS10_CommandHdr_SET_Length
// FMBC_MailboxClientS10_CommandHdr_WRITE
// FMBC_MailboxClientS10_IntEnable_GET_EnBackPressTimeout
// FMBC_MailboxClientS10_IntEnable_GET_EnCmdFifoNotFull
// FMBC_MailboxClientS10_IntEnable_GET_EnCmdInvalid
// FMBC_MailboxClientS10_IntEnable_GET_EnDataValid
// FMBC_MailboxClientS10_IntEnable_GET_EnEopTimeout
// FMBC_MailboxClientS10_IntEnable_GET_EnRdRespEmpty
// FMBC_MailboxClientS10_IntEnable_GET_EnWrCmdFull
// FMBC_MailboxClientS10_IntEnable_READ
// FMBC_MailboxClientS10_IntEnable_SET_EnBackPressTimeout
// FMBC_MailboxClientS10_IntEnable_SET_EnCmdFifoNotFull
// FMBC_MailboxClientS10_IntEnable_SET_EnCmdInvalid
// FMBC_MailboxClientS10_IntEnable_SET_EnDataValid
// FMBC_MailboxClientS10_IntEnable_SET_EnEopTimeout
// FMBC_MailboxClientS10_IntEnable_SET_EnRdRespEmpty
// FMBC_MailboxClientS10_IntEnable_SET_EnWrCmdFull
// FMBC_MailboxClientS10_IntEnable_WRITE
// FMBC_MailboxClientS10_IntStatus_GET_BackPressTimeout
// FMBC_MailboxClientS10_IntStatus_GET_CmdFifoNotFull
// FMBC_MailboxClientS10_IntStatus_GET_CmdInvalid
// FMBC_MailboxClientS10_IntStatus_GET_DataValid
// FMBC_MailboxClientS10_IntStatus_GET_EopTimeout
// FMBC_MailboxClientS10_IntStatus_GET_RdRespEmpty
// FMBC_MailboxClientS10_IntStatus_GET_WrCmdFull
// FMBC_MailboxClientS10_IntStatus_READ
// FMBC_MailboxClientS10_IntStatus_READ_BackPressTimeout
// FMBC_MailboxClientS10_IntStatus_READ_CmdFifoNotFull
// FMBC_MailboxClientS10_IntStatus_READ_CmdInvalid
// FMBC_MailboxClientS10_IntStatus_READ_DataValid
// FMBC_MailboxClientS10_IntStatus_READ_EopTimeout
// FMBC_MailboxClientS10_IntStatus_READ_RdRespEmpty
// FMBC_MailboxClientS10_IntStatus_READ_WrCmdFull
// FMBC_MailboxClientS10_RespFifoStat_GET_EOP
// FMBC_MailboxClientS10_RespFifoStat_GET_RespFillLevel
// FMBC_MailboxClientS10_RespFifoStat_GET_SOP
// FMBC_MailboxClientS10_RespFifoStat_READ
// FMBC_MailboxClientS10_RespFifoStat_READ_EOP
// FMBC_MailboxClientS10_RespFifoStat_READ_RespFillLevel
// FMBC_MailboxClientS10_RespFifoStat_READ_SOP
// FMBC_MailboxClientS10_ResponseData_READ_ResponseData
// FMBC_MailboxClientS10_ResponseHdr_GET_ErrCode
// FMBC_MailboxClientS10_ResponseHdr_GET_ID
// FMBC_MailboxClientS10_ResponseHdr_GET_Length
// FMBC_MailboxClientS10_ResponseHdr_READ
// FMBC_MailboxClientS10_SdmTimeout_GET_Enable
// FMBC_MailboxClientS10_SdmTimeout_GET_Period
// FMBC_MailboxClientS10_SdmTimeout_READ
// FMBC_MailboxClientS10_SdmTimeout_SET_Enable
// FMBC_MailboxClientS10_SdmTimeout_SET_Period
// FMBC_MailboxClientS10_SdmTimeout_WRITE
// FMBC_Status_CLEAR_AccessTimedout
// FMBC_Status_GET_AccessTimedout
// FMBC_Status_READ
// FMBC_Status_READ_AccessTimedout

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'CmdCodes'
#define FMBC_CMD_NOOP                         0x0    // 
#define FMBC_CMD_CONFIG_STATUS                0x4    // 
#define FMBC_CMD_GET_IDCODE                   0x10   // 
#define FMBC_CMD_GET_CHIPID                   0x12   // 
#define FMBC_CMD_GET_USERCODE                 0x13   // 
#define FMBC_CMD_GET_VOLTAGE                  0x18   // 
#define FMBC_CMD_GET_TEMPERATURE              0x19   // 
#define FMBC_CMD_QSPI_OPEN                    0x32   // 
#define FMBC_CMD_QPSI_CLOSE                   0x33   // 
#define FMBC_CMD_QSPI_SET_CS                  0x34   // 
#define FMBC_CMD_QSPI_READ_DEVICE_REG         0x35   // 
#define FMBC_CMD_QPSI_WRITE_DEVICE_REG        0x36   // 
#define FMBC_CMD_QPSI_SEND_DEVICE_OP          0x37   // 
#define FMBC_CMD_QPSI_ERASE                   0x38   // 
#define FMBC_CMD_QSPI_WRITE                   0x39   // 
#define FMBC_CMD_QSPI_READ                    0x3A   // 
#define FMBC_CMD_READ_SEU_ERROR               0x3C   // 
#define FMBC_CMD_RSU_GET_SPT                  0x5A   // 
#define FMBC_CMD_RSU_STATUS                   0x5B   // 
#define FMBC_CMD_RSU_IMAGE_UPDATE             0x5C   // 
#define FMBC_CMD_RSU_NOTIFY                   0x5D   // 
#define FMBC_CMD_GET_CONFIGURATION_TIME       0x65   // 
#define FMBC_CMD_QPSI_READ_SHA                0x6E   // 

// Value map 'RespCodes'
#define FMBC_RESP_OK                          0x0    // 
#define FMBC_RESP_INVALID_COMMAND             0x1    // 
#define FMBC_RESP_UNKNOWN_COMMAND             0x3    // 
#define FMBC_RESP_INVALID_COMMAND_PARAMETERS  0x4    // 
#define FMBC_RESP_COMMAND_INVALID_ON_SOURCE   0x6    // 
#define FMBC_RESP_CLIENT_ID_NO_MATCH          0x8    // 
#define FMBC_RESP_INVALID_ADDRESS             0x9    // 
#define FMBC_RESP_AUTHENTICATION_FAIL         0xA    // 
#define FMBC_RESP_TIMEOUT                     0xB    // 
#define FMBC_RESP_HW_NOT_READY                0xC    // 
#define FMBC_RESP_HW_ERROR                    0xD    // 
#define FMBC_RESP_QSPI_HW_ERROR               0x80   // 
#define FMBC_RESP_QSPI_ALREAY_OPEN            0x81   // 
#define FMBC_RESP_EFUSE_SYSTEM_FAILURE        0x82   // 
#define FMBC_RESP_NOT_CONFIGURED              0x100  // 
#define FMBC_RESP_DEVICE_BUSY                 0x1FF  // 
#define FMBC_RESP_NO_VALID_RESP_AVAILABLE     0x2FF  // 
#define FMBC_RESP_ERROR                       0x3FF  // 

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// +=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 FMBC_Config_READ(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x8);
}

// Field GET functions.
static __inline UInt32 FMBC_Config_GET_CmdFifoDepth(UInt32 Config)
{
    return Config & 0x7FF;
}
static __inline UInt32 FMBC_Config_GET_RespFifoDepth(UInt32 Config)
{
    return (Config & 0x3FF800) >> 11;
}
static __inline UInt32 FMBC_Config_GET_ClkFreqMHz(UInt32 Config)
{
    return (Config & 0xFFC00000) >> 22;
}

// Field READ functions.
static __inline UInt32 FMBC_Config_READ_CmdFifoDepth(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x8) & 0x7FF;
}
static __inline UInt32 FMBC_Config_READ_RespFifoDepth(DtBcFMBC* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x8) & 0x3FF800) >> 11;
}
static __inline UInt32 FMBC_Config_READ_ClkFreqMHz(DtBcFMBC* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x8) & 0xFFC00000) >> 22;
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 FMBC_Status_READ(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10);
}

// Field GET function.
static __inline UInt32 FMBC_Status_GET_AccessTimedout(UInt32 Status)
{
    return Status & 0x1;
}

// Field READ function.
static __inline UInt32 FMBC_Status_READ_AccessTimedout(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10) & 0x1;
}

// Field CLEAR function.
static __inline void FMBC_Status_CLEAR_AccessTimedout(DtBcFMBC* Bc)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10, 0x1);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'MailboxClientS10_CommandHdr' -.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 FMBC_MailboxClientS10_CommandHdr_READ(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x40);
}

// Field GET functions.
static __inline UInt32 FMBC_MailboxClientS10_CommandHdr_GET_CmdCode(UInt32 MailboxClientS10_CommandHdr)
{
    return MailboxClientS10_CommandHdr & 0x7FF;
}
static __inline UInt32 FMBC_MailboxClientS10_CommandHdr_GET_Length(UInt32 MailboxClientS10_CommandHdr)
{
    return (MailboxClientS10_CommandHdr & 0x7FF000) >> 12;
}
static __inline UInt32 FMBC_MailboxClientS10_CommandHdr_GET_ID(UInt32 MailboxClientS10_CommandHdr)
{
    return (MailboxClientS10_CommandHdr & 0xF000000) >> 24;
}

// Field SET functions.
static __inline UInt32 FMBC_MailboxClientS10_CommandHdr_SET_CmdCode(UInt32 MailboxClientS10_CommandHdr, UInt32 CmdCode)
{
    DT_ASSERT((CmdCode & ~0x7FF) == 0);
    return (MailboxClientS10_CommandHdr & ~0x7FF) | CmdCode;
}
static __inline UInt32 FMBC_MailboxClientS10_CommandHdr_SET_Length(UInt32 MailboxClientS10_CommandHdr, UInt32 Length)
{
    DT_ASSERT((Length & ~0x7FF) == 0);
    return (MailboxClientS10_CommandHdr & ~0x7FF000) | (Length << 12);
}
static __inline UInt32 FMBC_MailboxClientS10_CommandHdr_SET_ID(UInt32 MailboxClientS10_CommandHdr, UInt32 ID)
{
    DT_ASSERT((ID & ~0xF) == 0);
    return (MailboxClientS10_CommandHdr & ~0xF000000) | (ID << 24);
}

// Register WRITE function.
static __inline void FMBC_MailboxClientS10_CommandHdr_WRITE(DtBcFMBC* Bc, UInt32 MailboxClientS10_CommandHdr)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x40, MailboxClientS10_CommandHdr);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'MailboxClientS10_CommandData' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 FMBC_MailboxClientS10_CommandData_READ_CommandData(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x44);
}

// Field WRITE function.
static __inline void FMBC_MailboxClientS10_CommandData_WRITE_CommandData(DtBcFMBC* Bc, UInt32 CommandData)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x44, CommandData);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'MailboxClientS10_CommandEopHdr' -.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 FMBC_MailboxClientS10_CommandEopHdr_READ(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x48);
}

// Field GET functions.
static __inline UInt32 FMBC_MailboxClientS10_CommandEopHdr_GET_CmdCode(UInt32 MailboxClientS10_CommandEopHdr)
{
    return MailboxClientS10_CommandEopHdr & 0x7FF;
}
static __inline UInt32 FMBC_MailboxClientS10_CommandEopHdr_GET_Length(UInt32 MailboxClientS10_CommandEopHdr)
{
    return (MailboxClientS10_CommandEopHdr & 0x7FF000) >> 12;
}
static __inline UInt32 FMBC_MailboxClientS10_CommandEopHdr_GET_ID(UInt32 MailboxClientS10_CommandEopHdr)
{
    return (MailboxClientS10_CommandEopHdr & 0xF000000) >> 24;
}

// Field SET functions.
static __inline UInt32 FMBC_MailboxClientS10_CommandEopHdr_SET_CmdCode(UInt32 MailboxClientS10_CommandEopHdr, UInt32 CmdCode)
{
    DT_ASSERT((CmdCode & ~0x7FF) == 0);
    return (MailboxClientS10_CommandEopHdr & ~0x7FF) | CmdCode;
}
static __inline UInt32 FMBC_MailboxClientS10_CommandEopHdr_SET_Length(UInt32 MailboxClientS10_CommandEopHdr, UInt32 Length)
{
    DT_ASSERT((Length & ~0x7FF) == 0);
    return (MailboxClientS10_CommandEopHdr & ~0x7FF000) | (Length << 12);
}
static __inline UInt32 FMBC_MailboxClientS10_CommandEopHdr_SET_ID(UInt32 MailboxClientS10_CommandEopHdr, UInt32 ID)
{
    DT_ASSERT((ID & ~0xF) == 0);
    return (MailboxClientS10_CommandEopHdr & ~0xF000000) | (ID << 24);
}

// Register WRITE function.
static __inline void FMBC_MailboxClientS10_CommandEopHdr_WRITE(DtBcFMBC* Bc, UInt32 MailboxClientS10_CommandEopHdr)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x48, MailboxClientS10_CommandEopHdr);
}

// -.-.-.-.-.-.-.-.-.-.- Register 'MailboxClientS10_CommandEopData' -.-.-.-.-.-.-.-.-.-.-.

// Field READ function.
static __inline UInt32 FMBC_MailboxClientS10_CommandEopData_READ_CommandEopData(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4C);
}

// Field WRITE function.
static __inline void FMBC_MailboxClientS10_CommandEopData_WRITE_CommandEopData(DtBcFMBC* Bc, UInt32 CommandEopData)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x4C, CommandEopData);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'MailboxClientS10_CmdSpace' -.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 FMBC_MailboxClientS10_CmdSpace_READ_CmdSpace(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x50);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'MailboxClientS10_ResponseHdr' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 FMBC_MailboxClientS10_ResponseHdr_READ(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x54);
}

// Field GET functions.
static __inline UInt32 FMBC_MailboxClientS10_ResponseHdr_GET_ErrCode(UInt32 MailboxClientS10_ResponseHdr)
{
    return MailboxClientS10_ResponseHdr & 0x7FF;
}
static __inline UInt32 FMBC_MailboxClientS10_ResponseHdr_GET_Length(UInt32 MailboxClientS10_ResponseHdr)
{
    return (MailboxClientS10_ResponseHdr & 0x7FF000) >> 12;
}
static __inline UInt32 FMBC_MailboxClientS10_ResponseHdr_GET_ID(UInt32 MailboxClientS10_ResponseHdr)
{
    return (MailboxClientS10_ResponseHdr & 0xF000000) >> 24;
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'MailboxClientS10_ResponseData' -.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 FMBC_MailboxClientS10_ResponseData_READ_ResponseData(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x58);
}

// .-.-.-.-.-.-.-.-.-.-.- Register 'MailboxClientS10_RespFifoStat' -.-.-.-.-.-.-.-.-.-.-.-

// Register READ function.
static __inline UInt32 FMBC_MailboxClientS10_RespFifoStat_READ(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x5C);
}

// Field GET functions.
static __inline UInt32 FMBC_MailboxClientS10_RespFifoStat_GET_SOP(UInt32 MailboxClientS10_RespFifoStat)
{
    return MailboxClientS10_RespFifoStat & 0x1;
}
static __inline UInt32 FMBC_MailboxClientS10_RespFifoStat_GET_EOP(UInt32 MailboxClientS10_RespFifoStat)
{
    return (MailboxClientS10_RespFifoStat & 0x2) >> 1;
}
static __inline UInt32 FMBC_MailboxClientS10_RespFifoStat_GET_RespFillLevel(UInt32 MailboxClientS10_RespFifoStat)
{
    return (MailboxClientS10_RespFifoStat & 0xFFFFFFFC) >> 2;
}

// Field READ functions.
static __inline UInt32 FMBC_MailboxClientS10_RespFifoStat_READ_SOP(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x5C) & 0x1;
}
static __inline UInt32 FMBC_MailboxClientS10_RespFifoStat_READ_EOP(DtBcFMBC* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x5C) & 0x2) >> 1;
}
static __inline UInt32 FMBC_MailboxClientS10_RespFifoStat_READ_RespFillLevel(DtBcFMBC* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x5C) & 0xFFFFFFFC) >> 2;
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'MailboxClientS10_IntEnable' -.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 FMBC_MailboxClientS10_IntEnable_READ(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x60);
}

// Field GET functions.
static __inline UInt32 FMBC_MailboxClientS10_IntEnable_GET_EnDataValid(UInt32 MailboxClientS10_IntEnable)
{
    return MailboxClientS10_IntEnable & 0x1;
}
static __inline UInt32 FMBC_MailboxClientS10_IntEnable_GET_EnCmdFifoNotFull(UInt32 MailboxClientS10_IntEnable)
{
    return (MailboxClientS10_IntEnable & 0x2) >> 1;
}
static __inline UInt32 FMBC_MailboxClientS10_IntEnable_GET_EnCmdInvalid(UInt32 MailboxClientS10_IntEnable)
{
    return (MailboxClientS10_IntEnable & 0x8) >> 3;
}
static __inline UInt32 FMBC_MailboxClientS10_IntEnable_GET_EnEopTimeout(UInt32 MailboxClientS10_IntEnable)
{
    return (MailboxClientS10_IntEnable & 0x10) >> 4;
}
static __inline UInt32 FMBC_MailboxClientS10_IntEnable_GET_EnBackPressTimeout(UInt32 MailboxClientS10_IntEnable)
{
    return (MailboxClientS10_IntEnable & 0x20) >> 5;
}
static __inline UInt32 FMBC_MailboxClientS10_IntEnable_GET_EnWrCmdFull(UInt32 MailboxClientS10_IntEnable)
{
    return (MailboxClientS10_IntEnable & 0x100) >> 8;
}
static __inline UInt32 FMBC_MailboxClientS10_IntEnable_GET_EnRdRespEmpty(UInt32 MailboxClientS10_IntEnable)
{
    return (MailboxClientS10_IntEnable & 0x200) >> 9;
}

// Field SET functions.
static __inline UInt32 FMBC_MailboxClientS10_IntEnable_SET_EnDataValid(UInt32 MailboxClientS10_IntEnable, UInt32 EnDataValid)
{
    DT_ASSERT((EnDataValid & ~0x1) == 0);
    return (MailboxClientS10_IntEnable & ~0x1) | EnDataValid;
}
static __inline UInt32 FMBC_MailboxClientS10_IntEnable_SET_EnCmdFifoNotFull(UInt32 MailboxClientS10_IntEnable, UInt32 EnCmdFifoNotFull)
{
    DT_ASSERT((EnCmdFifoNotFull & ~0x1) == 0);
    return (MailboxClientS10_IntEnable & ~0x2) | (EnCmdFifoNotFull << 1);
}
static __inline UInt32 FMBC_MailboxClientS10_IntEnable_SET_EnCmdInvalid(UInt32 MailboxClientS10_IntEnable, UInt32 EnCmdInvalid)
{
    DT_ASSERT((EnCmdInvalid & ~0x1) == 0);
    return (MailboxClientS10_IntEnable & ~0x8) | (EnCmdInvalid << 3);
}
static __inline UInt32 FMBC_MailboxClientS10_IntEnable_SET_EnEopTimeout(UInt32 MailboxClientS10_IntEnable, UInt32 EnEopTimeout)
{
    DT_ASSERT((EnEopTimeout & ~0x1) == 0);
    return (MailboxClientS10_IntEnable & ~0x10) | (EnEopTimeout << 4);
}
static __inline UInt32 FMBC_MailboxClientS10_IntEnable_SET_EnBackPressTimeout(UInt32 MailboxClientS10_IntEnable, UInt32 EnBackPressTimeout)
{
    DT_ASSERT((EnBackPressTimeout & ~0x1) == 0);
    return (MailboxClientS10_IntEnable & ~0x20) | (EnBackPressTimeout << 5);
}
static __inline UInt32 FMBC_MailboxClientS10_IntEnable_SET_EnWrCmdFull(UInt32 MailboxClientS10_IntEnable, UInt32 EnWrCmdFull)
{
    DT_ASSERT((EnWrCmdFull & ~0x1) == 0);
    return (MailboxClientS10_IntEnable & ~0x100) | (EnWrCmdFull << 8);
}
static __inline UInt32 FMBC_MailboxClientS10_IntEnable_SET_EnRdRespEmpty(UInt32 MailboxClientS10_IntEnable, UInt32 EnRdRespEmpty)
{
    DT_ASSERT((EnRdRespEmpty & ~0x1) == 0);
    return (MailboxClientS10_IntEnable & ~0x200) | (EnRdRespEmpty << 9);
}

// Register WRITE function.
static __inline void FMBC_MailboxClientS10_IntEnable_WRITE(DtBcFMBC* Bc, UInt32 MailboxClientS10_IntEnable)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x60, MailboxClientS10_IntEnable);
}

// .-.-.-.-.-.-.-.-.-.-.-.- Register 'MailboxClientS10_IntStatus' -.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 FMBC_MailboxClientS10_IntStatus_READ(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x64);
}

// Field GET functions.
static __inline UInt32 FMBC_MailboxClientS10_IntStatus_GET_DataValid(UInt32 MailboxClientS10_IntStatus)
{
    return MailboxClientS10_IntStatus & 0x1;
}
static __inline UInt32 FMBC_MailboxClientS10_IntStatus_GET_CmdFifoNotFull(UInt32 MailboxClientS10_IntStatus)
{
    return (MailboxClientS10_IntStatus & 0x2) >> 1;
}
static __inline UInt32 FMBC_MailboxClientS10_IntStatus_GET_CmdInvalid(UInt32 MailboxClientS10_IntStatus)
{
    return (MailboxClientS10_IntStatus & 0x8) >> 3;
}
static __inline UInt32 FMBC_MailboxClientS10_IntStatus_GET_EopTimeout(UInt32 MailboxClientS10_IntStatus)
{
    return (MailboxClientS10_IntStatus & 0x10) >> 4;
}
static __inline UInt32 FMBC_MailboxClientS10_IntStatus_GET_BackPressTimeout(UInt32 MailboxClientS10_IntStatus)
{
    return (MailboxClientS10_IntStatus & 0x20) >> 5;
}
static __inline UInt32 FMBC_MailboxClientS10_IntStatus_GET_WrCmdFull(UInt32 MailboxClientS10_IntStatus)
{
    return (MailboxClientS10_IntStatus & 0x100) >> 8;
}
static __inline UInt32 FMBC_MailboxClientS10_IntStatus_GET_RdRespEmpty(UInt32 MailboxClientS10_IntStatus)
{
    return (MailboxClientS10_IntStatus & 0x200) >> 9;
}

// Field READ functions.
static __inline UInt32 FMBC_MailboxClientS10_IntStatus_READ_DataValid(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x64) & 0x1;
}
static __inline UInt32 FMBC_MailboxClientS10_IntStatus_READ_CmdFifoNotFull(DtBcFMBC* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x64) & 0x2) >> 1;
}
static __inline UInt32 FMBC_MailboxClientS10_IntStatus_READ_CmdInvalid(DtBcFMBC* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x64) & 0x8) >> 3;
}
static __inline UInt32 FMBC_MailboxClientS10_IntStatus_READ_EopTimeout(DtBcFMBC* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x64) & 0x10) >> 4;
}
static __inline UInt32 FMBC_MailboxClientS10_IntStatus_READ_BackPressTimeout(DtBcFMBC* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x64) & 0x20) >> 5;
}
static __inline UInt32 FMBC_MailboxClientS10_IntStatus_READ_WrCmdFull(DtBcFMBC* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x64) & 0x100) >> 8;
}
static __inline UInt32 FMBC_MailboxClientS10_IntStatus_READ_RdRespEmpty(DtBcFMBC* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x64) & 0x200) >> 9;
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'MailboxClientS10_CmdTimeout' -.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 FMBC_MailboxClientS10_CmdTimeout_READ(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x68);
}

// Field GET functions.
static __inline UInt32 FMBC_MailboxClientS10_CmdTimeout_GET_Period(UInt32 MailboxClientS10_CmdTimeout)
{
    return MailboxClientS10_CmdTimeout & 0x7FFFFFFF;
}
static __inline UInt32 FMBC_MailboxClientS10_CmdTimeout_GET_Enable(UInt32 MailboxClientS10_CmdTimeout)
{
    return (MailboxClientS10_CmdTimeout & 0x80000000) >> 31;
}

// Field SET functions.
static __inline UInt32 FMBC_MailboxClientS10_CmdTimeout_SET_Period(UInt32 MailboxClientS10_CmdTimeout, UInt32 Period)
{
    DT_ASSERT((Period & ~0x7FFFFFFF) == 0);
    return (MailboxClientS10_CmdTimeout & ~0x7FFFFFFF) | Period;
}
static __inline UInt32 FMBC_MailboxClientS10_CmdTimeout_SET_Enable(UInt32 MailboxClientS10_CmdTimeout, UInt32 Enable)
{
    DT_ASSERT((Enable & ~0x1) == 0);
    return (MailboxClientS10_CmdTimeout & ~0x80000000) | (Enable << 31);
}

// Register WRITE function.
static __inline void FMBC_MailboxClientS10_CmdTimeout_WRITE(DtBcFMBC* Bc, UInt32 MailboxClientS10_CmdTimeout)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x68, MailboxClientS10_CmdTimeout);
}

// -.-.-.-.-.-.-.-.-.-.-.- Register 'MailboxClientS10_SdmTimeout' -.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 FMBC_MailboxClientS10_SdmTimeout_READ(DtBcFMBC* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x6C);
}

// Field GET functions.
static __inline UInt32 FMBC_MailboxClientS10_SdmTimeout_GET_Period(UInt32 MailboxClientS10_SdmTimeout)
{
    return MailboxClientS10_SdmTimeout & 0x7FFFFFFF;
}
static __inline UInt32 FMBC_MailboxClientS10_SdmTimeout_GET_Enable(UInt32 MailboxClientS10_SdmTimeout)
{
    return (MailboxClientS10_SdmTimeout & 0x80000000) >> 31;
}

// Field SET functions.
static __inline UInt32 FMBC_MailboxClientS10_SdmTimeout_SET_Period(UInt32 MailboxClientS10_SdmTimeout, UInt32 Period)
{
    DT_ASSERT((Period & ~0x7FFFFFFF) == 0);
    return (MailboxClientS10_SdmTimeout & ~0x7FFFFFFF) | Period;
}
static __inline UInt32 FMBC_MailboxClientS10_SdmTimeout_SET_Enable(UInt32 MailboxClientS10_SdmTimeout, UInt32 Enable)
{
    DT_ASSERT((Enable & ~0x1) == 0);
    return (MailboxClientS10_SdmTimeout & ~0x80000000) | (Enable << 31);
}

// Register WRITE function.
static __inline void FMBC_MailboxClientS10_SdmTimeout_WRITE(DtBcFMBC* Bc, UInt32 MailboxClientS10_SdmTimeout)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x6C, MailboxClientS10_SdmTimeout);
}

