// *#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcDDRFIFO_RegAccess.h *#*#*#*#*#*#*#* (C) 2023 DekTec
//
// Device driver - DdrFifo v0 (DDRFIFO) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block DdrFifo.
// These functions should solely be used by the block controller for DdrFifo.
//
// 2023.02.17 11:43 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND.

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2022 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN No EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//
// 1. Getting fields 'DataWidth' and 'BurstSize' from register 'Config':
//      UInt32 Reg_Config, DataWidth, BurstSize;
//      Reg_Config = DDRFIFO_Config_READ(Bc);
//      DataWidth  = DDRFIFO_Config_GET_DataWidth(Reg_Config);
//      BurstSize  = DDRFIFO_Config_GET_BurstSize(Reg_Config);
//
// 2. Single-function shorthand for reading field 'MemPllLocked' from register 'Status':
//      UInt32  MemPllLocked = DDRFIFO_Status_READ_MemPllLocked(Bc);
//
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

// +=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// DDRFIFO_Config_GET_BurstSize
// DDRFIFO_Config_GET_DataWidth
// DDRFIFO_Config_GET_FifoSize
// DDRFIFO_Config_READ
// DDRFIFO_Config_READ_BurstSize
// DDRFIFO_Config_READ_DataWidth
// DDRFIFO_Config_READ_FifoSize
// DDRFIFO_Control_READ
// DDRFIFO_Control_SET_BlockEnable
// DDRFIFO_Control_SET_OperationalMode
// DDRFIFO_Control_WRITE
// DDRFIFO_FifoLoad_READ
// DDRFIFO_MemControl_READ
// DDRFIFO_MemControl_SET_DoReset
// DDRFIFO_MemControl_WRITE
// DDRFIFO_Status_GET_MemCalFail
// DDRFIFO_Status_GET_MemCalSuccess
// DDRFIFO_Status_GET_MemPllLocked
// DDRFIFO_Status_GET_OperationalStatus
// DDRFIFO_Status_READ
// DDRFIFO_Status_READ_MemCalFail
// DDRFIFO_Status_READ_MemCalSuccess
// DDRFIFO_Status_READ_MemPllLocked
// DDRFIFO_Status_READ_OperationalStatus

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'BlockEnable'
#define DDRFIFO_BLKENA_DISABLED  0x0  // Block is entirely disabled
#define DDRFIFO_BLKENA_ENABLED   0x1  // Block is enabled and processes data

// Value map 'OperationalMode'
#define DDRFIFO_OPMODE_IDLE      0x0  // Block is inactive
#define DDRFIFO_OPMODE_STANDBY   0x1  // Block is partially operational
#define DDRFIFO_OPMODE_RUN       0x2  // Block performs its normal function

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// +=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 DDRFIFO_Config_READ(DtBcDDRFIFO* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4);
}

// Field GET functions.
static __inline UInt32 DDRFIFO_Config_GET_DataWidth(UInt32 Config)
{
    return Config & 0xF;
}
static __inline UInt32 DDRFIFO_Config_GET_BurstSize(UInt32 Config)
{
    return (Config & 0xF0) >> 4;
}
static __inline UInt32 DDRFIFO_Config_GET_FifoSize(UInt32 Config)
{
    return (Config & 0x3F00) >> 8;
}

// Field READ functions.
static __inline UInt32 DDRFIFO_Config_READ_DataWidth(DtBcDDRFIFO* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4) & 0xF;
}
static __inline UInt32 DDRFIFO_Config_READ_BurstSize(DtBcDDRFIFO* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x4) & 0xF0) >> 4;
}
static __inline UInt32 DDRFIFO_Config_READ_FifoSize(DtBcDDRFIFO* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x4) & 0x3F00) >> 8;
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 DDRFIFO_Control_READ(DtBcDDRFIFO* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x8);
}

// Field SET functions.
static __inline UInt32 DDRFIFO_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32 DDRFIFO_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}

// Register WRITE function.
static __inline void DDRFIFO_Control_WRITE(DtBcDDRFIFO* Bc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x8, Control);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 DDRFIFO_Status_READ(DtBcDDRFIFO* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0xC);
}

// Field GET functions.
static __inline UInt32 DDRFIFO_Status_GET_OperationalStatus(UInt32 Status)
{
    return (Status & 0x6) >> 1;
}
static __inline UInt32 DDRFIFO_Status_GET_MemCalSuccess(UInt32 Status)
{
    return (Status & 0x100) >> 8;
}
static __inline UInt32 DDRFIFO_Status_GET_MemCalFail(UInt32 Status)
{
    return (Status & 0x200) >> 9;
}
static __inline UInt32 DDRFIFO_Status_GET_MemPllLocked(UInt32 Status)
{
    return (Status & 0x400) >> 10;
}

// Field READ functions.
static __inline UInt32 DDRFIFO_Status_READ_OperationalStatus(DtBcDDRFIFO* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0xC) & 0x6) >> 1;
}
static __inline UInt32 DDRFIFO_Status_READ_MemCalSuccess(DtBcDDRFIFO* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0xC) & 0x100) >> 8;
}
static __inline UInt32 DDRFIFO_Status_READ_MemCalFail(DtBcDDRFIFO* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0xC) & 0x200) >> 9;
}
static __inline UInt32 DDRFIFO_Status_READ_MemPllLocked(DtBcDDRFIFO* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0xC) & 0x400) >> 10;
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FifoLoad' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function.
static __inline UInt32 DDRFIFO_FifoLoad_READ(DtBcDDRFIFO* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'MemControl' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 DDRFIFO_MemControl_READ(DtBcDDRFIFO* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x14);
}

// Field SET function.
static __inline UInt32 DDRFIFO_MemControl_SET_DoReset(UInt32 MemControl, UInt32 DoReset)
{
    DT_ASSERT((DoReset & ~0x1) == 0);
    return (MemControl & ~0x1) | DoReset;
}

// Register WRITE function.
static __inline void DDRFIFO_MemControl_WRITE(DtBcDDRFIFO* Bc, UInt32 MemControl)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x14, MemControl);
}

