//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcCONSTSOURCE_RegAccess.h *#*#*#*#*#*#* (C) 2019 DekTec
//
// Device driver - ConstRateSource v0 (CONSTSOURCE) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block ConstRateSource.
// These functions should solely be used by the block controller for ConstRateSource.
//
// 2019.03.06 11:21 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Single-function shorthand for reading field 'DataWidth' from register 'Config2':
//      UInt32  DataWidth = CONSTSOURCE_Config2_READ_DataWidth(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// CONSTSOURCE_Config1_READ_SysClockFreq
// CONSTSOURCE_Config2_GET_DataWidth
// CONSTSOURCE_Config2_READ
// CONSTSOURCE_Config2_READ_DataWidth
// CONSTSOURCE_Control_READ
// CONSTSOURCE_Control_SET_BlockEnable
// CONSTSOURCE_Control_SET_DataPattern
// CONSTSOURCE_Control_SET_OperationalMode
// CONSTSOURCE_Control_SET_StartTestInterval
// CONSTSOURCE_Control_SET_TestInterval
// CONSTSOURCE_Control_WRITE
// CONSTSOURCE_DataRatePhaseIncr_WRITE
// CONSTSOURCE_OverflowCnt_READ

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'BlockEnable'
#define CONSTSOURCE_BLKENA_DISABLED       0x0  // Block is entirely disabled
#define CONSTSOURCE_BLKENA_ENABLED        0x1  // Block is enabled and processes data

// Value map 'DataPattern'
#define CONSTSOURCE_PATTERN_INCREMENTING  0x0  // Incrementing on 32-bit basis
#define CONSTSOURCE_PATTERN_PRBS31        0x1  // Pseudorandom binary sequence, sequence
                                               // size 31

// Value map 'OperationalMode'
#define CONSTSOURCE_OPMODE_IDLE           0x0  // Block is inactive
#define CONSTSOURCE_OPMODE_STANDBY        0x1  // Block is partially operational
#define CONSTSOURCE_OPMODE_RUN            0x2  // Block performs its normal function

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  CONSTSOURCE_Config1_READ_SysClockFreq(DtBcCONSTSOURCE* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  CONSTSOURCE_Config2_READ(DtBcCONSTSOURCE* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC);
}

// Field GET function
static __inline UInt32  CONSTSOURCE_Config2_GET_DataWidth(UInt32 Config2)
{
    return Config2 & 0xFFFF;
}

// Field READ function
static __inline UInt32  CONSTSOURCE_Config2_READ_DataWidth(DtBcCONSTSOURCE* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC) & 0xFFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  CONSTSOURCE_Control_READ(DtBcCONSTSOURCE* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10);
}

// Field SET functions
static __inline UInt32  CONSTSOURCE_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32  CONSTSOURCE_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32  CONSTSOURCE_Control_SET_DataPattern(UInt32 Control, UInt32 DataPattern)
{
    DT_ASSERT((DataPattern & ~0x1) == 0);
    return (Control & ~0x8) | (DataPattern << 3);
}
static __inline UInt32  CONSTSOURCE_Control_SET_TestInterval(UInt32 Control, UInt32 TestInterval)
{
    DT_ASSERT((TestInterval & ~0xFFFFF) == 0);
    return (Control & ~0xFFFFF0) | (TestInterval << 4);
}
static __inline UInt32  CONSTSOURCE_Control_SET_StartTestInterval(UInt32 Control, UInt32 StartTestInterval)
{
    DT_ASSERT((StartTestInterval & ~0x1) == 0);
    return (Control & ~0x1000000) | (StartTestInterval << 24);
}

// Register WRITE function
static __inline void  CONSTSOURCE_Control_WRITE(DtBcCONSTSOURCE* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10, Control);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'DataRatePhaseIncr' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void  CONSTSOURCE_DataRatePhaseIncr_WRITE(DtBcCONSTSOURCE* pBc, UInt32 DataRatePhaseIncr)
{
    DT_ASSERT((DataRatePhaseIncr & ~0xFFFFFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x14, DataRatePhaseIncr);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'OverflowCnt' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  CONSTSOURCE_OverflowCnt_READ(DtBcCONSTSOURCE* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x18);
}

