//*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcBURSTFIFO_RegAccess.h *#*#*#*#*#*#*# (C) 2019 DekTec
//
// Device driver - BurstFifo v0 (BURSTFIFO) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block BurstFifo.
// These functions should solely be used by the block controller for BurstFifo.
//
// 2019.03.06 11:21 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'RxTxCapability' and 'DataWidth' from register 'Config':
//      UInt32  Reg_Config, RxTxCapability, DataWidth;
//      Reg_Config     = BURSTFIFO_Config_READ(pBc);
//      RxTxCapability = BURSTFIFO_Config_GET_RxTxCapability(Reg_Config);
//      DataWidth      = BURSTFIFO_Config_GET_DataWidth(Reg_Config);
//
// 2. Single-function shorthand for reading field 'Maximum' from register 'FreeSpaceMax':
//      UInt32  Maximum = BURSTFIFO_FreeSpaceMax_READ_Maximum(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// BURSTFIFO_Config_GET_DataWidth
// BURSTFIFO_Config_GET_FifoSize
// BURSTFIFO_Config_GET_RxTxCapability
// BURSTFIFO_Config_READ
// BURSTFIFO_Config_READ_DataWidth
// BURSTFIFO_Config_READ_FifoSize
// BURSTFIFO_Config_READ_RxTxCapability
// BURSTFIFO_Control_READ
// BURSTFIFO_Control_SET_BlockEnable
// BURSTFIFO_Control_SET_OperationalMode
// BURSTFIFO_Control_SET_RxInputFlowControl
// BURSTFIFO_Control_SET_RxOrTx
// BURSTFIFO_Control_WRITE
// BURSTFIFO_FreeSpaceMax_GET_Maximum
// BURSTFIFO_FreeSpaceMax_READ
// BURSTFIFO_FreeSpaceMax_READ_Maximum
// BURSTFIFO_FreeSpaceMax_SET_Clear
// BURSTFIFO_FreeSpaceMax_WRITE
// BURSTFIFO_FreeSpace_READ
// BURSTFIFO_LoadMax_GET_Maximum
// BURSTFIFO_LoadMax_READ
// BURSTFIFO_LoadMax_READ_Maximum
// BURSTFIFO_LoadMax_SET_Clear
// BURSTFIFO_LoadMax_WRITE
// BURSTFIFO_Load_READ
// BURSTFIFO_OverUnderflowCnt_READ

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'TransferDirection'
#define BURSTFIFO_DIR_RX             0x0  // 
#define BURSTFIFO_DIR_TX             0x1  // 

// Value map 'InputFlowControl'
#define BURSTFIFO_FC_PUSHPULL        0x0  // Standard Push-Pull
#define BURSTFIFO_FC_VIRTUAL_PUSH    0x1  // Virtual push

// Value map 'OperationalMode'
#define BURSTFIFO_OPMODE_IDLE        0x0  // Block is inactive
#define BURSTFIFO_OPMODE_STANDBY     0x1  // Block is partially operational
#define BURSTFIFO_OPMODE_RUN         0x2  // Block performs its normal function

// Value map 'RxTxCapability'
#define BURSTFIFO_RXTXCAP_RX_ONLY    0x0  // Receive only (unidirectional)
#define BURSTFIFO_RXTXCAP_TX_ONLY    0x1  // Transmit only (unidirectional)
#define BURSTFIFO_RXTXCAP_RX_OR_TX   0x2  // Receive and transmit are both supported at
                                          // half-duplex
#define BURSTFIFO_RXTXCAP_RX_AND_TX  0x3  // Receive and transmit are both supported at
                                          // full-duplex

// Value map 'BlockEnable'
#define BURSTFIFO_BLKENA_DISABLED    0x0  // Block is entirely disabled
#define BURSTFIFO_BLKENA_ENABLED     0x1  // Block is enabled and processes data

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  BURSTFIFO_Config_READ(DtBcBURSTFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field GET functions
static __inline UInt32  BURSTFIFO_Config_GET_RxTxCapability(UInt32 Config)
{
    return Config & 0x3;
}
static __inline UInt32  BURSTFIFO_Config_GET_DataWidth(UInt32 Config)
{
    return (Config & 0xFFC) >> 2;
}
static __inline UInt32  BURSTFIFO_Config_GET_FifoSize(UInt32 Config)
{
    return (Config & 0xFFFFF000) >> 12;
}

// Field READ functions
static __inline UInt32  BURSTFIFO_Config_READ_RxTxCapability(DtBcBURSTFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4) & 0x3;
}
static __inline UInt32  BURSTFIFO_Config_READ_DataWidth(DtBcBURSTFIFO* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0xFFC) >> 2;
}
static __inline UInt32  BURSTFIFO_Config_READ_FifoSize(DtBcBURSTFIFO* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0xFFFFF000) >> 12;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  BURSTFIFO_Control_READ(DtBcBURSTFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field SET functions
static __inline UInt32  BURSTFIFO_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32  BURSTFIFO_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32  BURSTFIFO_Control_SET_RxOrTx(UInt32 Control, UInt32 RxOrTx)
{
    DT_ASSERT((RxOrTx & ~0x1) == 0);
    return (Control & ~0x8) | (RxOrTx << 3);
}
static __inline UInt32  BURSTFIFO_Control_SET_RxInputFlowControl(UInt32 Control, UInt32 RxInputFlowControl)
{
    DT_ASSERT((RxInputFlowControl & ~0x1) == 0);
    return (Control & ~0x10) | (RxInputFlowControl << 4);
}

// Register WRITE function
static __inline void  BURSTFIFO_Control_WRITE(DtBcBURSTFIFO* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x8, Control);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Load' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  BURSTFIFO_Load_READ(DtBcBURSTFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC) & 0xFFFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LoadMax' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  BURSTFIFO_LoadMax_READ(DtBcBURSTFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10);
}

// Field GET function
static __inline UInt32  BURSTFIFO_LoadMax_GET_Maximum(UInt32 LoadMax)
{
    return LoadMax & 0xFFFFF;
}

// Field READ function
static __inline UInt32  BURSTFIFO_LoadMax_READ_Maximum(DtBcBURSTFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10) & 0xFFFFF;
}

// Field SET function
static __inline UInt32  BURSTFIFO_LoadMax_SET_Clear(UInt32 LoadMax, UInt32 Clear)
{
    DT_ASSERT((Clear & ~0x1) == 0);
    return (LoadMax & ~0x80000000) | (Clear << 31);
}

// Register WRITE function
static __inline void  BURSTFIFO_LoadMax_WRITE(DtBcBURSTFIFO* pBc, UInt32 LoadMax)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10, LoadMax);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FreeSpace' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  BURSTFIFO_FreeSpace_READ(DtBcBURSTFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x14) & 0xFFFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FreeSpaceMax' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  BURSTFIFO_FreeSpaceMax_READ(DtBcBURSTFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x18);
}

// Field GET function
static __inline UInt32  BURSTFIFO_FreeSpaceMax_GET_Maximum(UInt32 FreeSpaceMax)
{
    return FreeSpaceMax & 0xFFFFF;
}

// Field READ function
static __inline UInt32  BURSTFIFO_FreeSpaceMax_READ_Maximum(DtBcBURSTFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x18) & 0xFFFFF;
}

// Field SET function
static __inline UInt32  BURSTFIFO_FreeSpaceMax_SET_Clear(UInt32 FreeSpaceMax, UInt32 Clear)
{
    DT_ASSERT((Clear & ~0x1) == 0);
    return (FreeSpaceMax & ~0x80000000) | (Clear << 31);
}

// Register WRITE function
static __inline void  BURSTFIFO_FreeSpaceMax_WRITE(DtBcBURSTFIFO* pBc, UInt32 FreeSpaceMax)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x18, FreeSpaceMax);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'OverUnderflowCnt' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  BURSTFIFO_OverUnderflowCnt_READ(DtBcBURSTFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1C);
}

