//*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcACCUFIFO_RegAccess.h *#*#*#*#*#*#*#* (C) 2019 DekTec
//
// Device driver - AccuFifo v0 (ACCUFIFO) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block AccuFifo.
// These functions should solely be used by the block controller for AccuFifo.
//
// 2019.03.06 11:21 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'FifoWidth' and 'FifoDepth' from register 'Config1':
//      UInt32  Reg_Config1, FifoWidth, FifoDepth;
//      Reg_Config1 = ACCUFIFO_Config1_READ(pBc);
//      FifoWidth   = ACCUFIFO_Config1_GET_FifoWidth(Reg_Config1);
//      FifoDepth   = ACCUFIFO_Config1_GET_FifoDepth(Reg_Config1);
//
// 2. Single-function shorthand for reading field 'FifoLoad' from register 'Status':
//      UInt32  FifoLoad = ACCUFIFO_Status_READ_FifoLoad(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// ACCUFIFO_Config1_GET_FifoDepth
// ACCUFIFO_Config1_GET_FifoWidth
// ACCUFIFO_Config1_READ
// ACCUFIFO_Config1_READ_FifoDepth
// ACCUFIFO_Config1_READ_FifoWidth
// ACCUFIFO_Config2_READ_ClkFreq
// ACCUFIFO_Control1_READ
// ACCUFIFO_Control1_SET_AccumulationPeriod
// ACCUFIFO_Control1_SET_Start
// ACCUFIFO_Control1_WRITE
// ACCUFIFO_Control2_READ
// ACCUFIFO_Control2_SET_NumMeasurements
// ACCUFIFO_Control2_WRITE
// ACCUFIFO_Measurement_READ
// ACCUFIFO_Status_GET_FifoLoad
// ACCUFIFO_Status_GET_MeasurementDone
// ACCUFIFO_Status_READ
// ACCUFIFO_Status_READ_FifoLoad
// ACCUFIFO_Status_READ_MeasurementDone

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  ACCUFIFO_Config1_READ(DtBcACCUFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field GET functions
static __inline UInt32  ACCUFIFO_Config1_GET_FifoWidth(UInt32 Config1)
{
    return Config1 & 0x3F;
}
static __inline UInt32  ACCUFIFO_Config1_GET_FifoDepth(UInt32 Config1)
{
    return (Config1 & 0xFFFFF00) >> 8;
}

// Field READ functions
static __inline UInt32  ACCUFIFO_Config1_READ_FifoWidth(DtBcACCUFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4) & 0x3F;
}
static __inline UInt32  ACCUFIFO_Config1_READ_FifoDepth(DtBcACCUFIFO* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x4) & 0xFFFFF00) >> 8;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  ACCUFIFO_Config2_READ_ClkFreq(DtBcACCUFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  ACCUFIFO_Control1_READ(DtBcACCUFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC);
}

// Field SET functions
static __inline UInt32  ACCUFIFO_Control1_SET_Start(UInt32 Control1, UInt32 Start)
{
    DT_ASSERT((Start & ~0x1) == 0);
    return (Control1 & ~0x1) | Start;
}
static __inline UInt32  ACCUFIFO_Control1_SET_AccumulationPeriod(UInt32 Control1, UInt32 AccumulationPeriod)
{
    DT_ASSERT((AccumulationPeriod & ~0xFFFF) == 0);
    return (Control1 & ~0xFFFF0000) | (AccumulationPeriod << 16);
}

// Register WRITE function
static __inline void  ACCUFIFO_Control1_WRITE(DtBcACCUFIFO* pBc, UInt32 Control1)
{
    DtBc_RegWrite32((DtBc*)pBc, 0xC, Control1);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  ACCUFIFO_Control2_READ(DtBcACCUFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10);
}

// Field SET function
static __inline UInt32  ACCUFIFO_Control2_SET_NumMeasurements(UInt32 Control2, UInt32 NumMeasurements)
{
    DT_ASSERT((NumMeasurements & ~0xFFFFF) == 0);
    return (Control2 & ~0xFFFFF) | NumMeasurements;
}

// Register WRITE function
static __inline void  ACCUFIFO_Control2_WRITE(DtBcACCUFIFO* pBc, UInt32 Control2)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10, Control2);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  ACCUFIFO_Status_READ(DtBcACCUFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x14);
}

// Field GET functions
static __inline UInt32  ACCUFIFO_Status_GET_MeasurementDone(UInt32 Status)
{
    return Status & 0x1;
}
static __inline UInt32  ACCUFIFO_Status_GET_FifoLoad(UInt32 Status)
{
    return (Status & 0xFFFFF00) >> 8;
}

// Field READ functions
static __inline UInt32  ACCUFIFO_Status_READ_MeasurementDone(DtBcACCUFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x14) & 0x1;
}
static __inline UInt32  ACCUFIFO_Status_READ_FifoLoad(DtBcACCUFIFO* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x14) & 0xFFFFF00) >> 8;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Measurement' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  ACCUFIFO_Measurement_READ(DtBcACCUFIFO* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x18);
}

