//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcS2DEMOD_RegAccess.h *#*#*#*#*#*#*#* (C) 2019 DekTec
//
// Device driver - S2Demod v-1 (S2DEMOD) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block S2Demod.
// These functions should solely be used by the block controller for S2Demod.
//
// 2019.03.26 8:50 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'MinorVersion' and 'MajorVersion' from register 'CoreVersionInfo':
//      UInt32  Reg_CoreVersionInfo, MinorVersion, MajorVersion;
//      Reg_CoreVersionInfo = S2DEMOD_CoreVersionInfo_READ(pBc);
//      MinorVersion        =
// S2DEMOD_CoreVersionInfo_GET_MinorVersion(Reg_CoreVersionInfo);
//      MajorVersion        =
// S2DEMOD_CoreVersionInfo_GET_MajorVersion(Reg_CoreVersionInfo);
//
// 2. Single-function shorthand for reading field 'AbsValueSquareBin127' from register
//    'FftSpectrum127':
//      UInt32  AbsValueSquareBin127 =
// S2DEMOD_FftSpectrum127_READ_AbsValueSquareBin127(pBc);
//
// Updating multiple fields in the same register:
//   UInt32  Reg_InterruptStatus = S2DEMOD_InterruptStatus_READ(pBc);
//   S2DEMOD_InterruptStatus_SET_Demodulator(Reg_InterruptStatus, 1);
//   S2DEMOD_InterruptStatus_SET_PlHeaderSync(Reg_InterruptStatus, 1);
//   S2DEMOD_InterruptStatus_WRITE(pBc, Reg_InterruptStatus);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// S2DEMOD_AntiAlisasingFilter_GET_FilterSelect
// S2DEMOD_AntiAlisasingFilter_READ
// S2DEMOD_AntiAlisasingFilter_SET_FilterSelect
// S2DEMOD_AntiAlisasingFilter_WRITE
// S2DEMOD_CoarsePhaseIncrement_READ
// S2DEMOD_CoreVersionInfo_GET_MajorVersion
// S2DEMOD_CoreVersionInfo_GET_MinorVersion
// S2DEMOD_CoreVersionInfo_READ
// S2DEMOD_CoreVersionInfo_READ_MajorVersion
// S2DEMOD_CoreVersionInfo_READ_MinorVersion
// S2DEMOD_DaAgcCorrGainFactor_GET_DaAgcGainFactor
// S2DEMOD_DaAgcCorrGainFactor_READ
// S2DEMOD_DaAgcCorrGainFactor_READ_DaAgcGainFactor
// S2DEMOD_DcOffsetValue_GET_ImaginaryPart
// S2DEMOD_DcOffsetValue_GET_RealPart
// S2DEMOD_DcOffsetValue_READ
// S2DEMOD_DcOffsetValue_READ_ImaginaryPart
// S2DEMOD_DcOffsetValue_READ_RealPart
// S2DEMOD_DcOffsetWeightFactor_GET_WeightFactor
// S2DEMOD_DcOffsetWeightFactor_READ
// S2DEMOD_DcOffsetWeightFactor_SET_WeightFactor
// S2DEMOD_DcOffsetWeightFactor_WRITE
// S2DEMOD_DecimationRate_READ
// S2DEMOD_DecimationRate_WRITE
// S2DEMOD_DemodRst_PULSE_DemodRst
// S2DEMOD_DetPlsValue_GET_PlsValue
// S2DEMOD_DetPlsValue_READ
// S2DEMOD_DetPlsValue_READ_PlsValue
// S2DEMOD_DetSpectrumInversion_GET_SpectrumInversion
// S2DEMOD_DetSpectrumInversion_READ
// S2DEMOD_DetSpectrumInversion_READ_SpectrumInversion
// S2DEMOD_EqualizerTap0_GET_ImaginaryPart
// S2DEMOD_EqualizerTap0_GET_RealPart
// S2DEMOD_EqualizerTap0_READ
// S2DEMOD_EqualizerTap0_READ_ImaginaryPart
// S2DEMOD_EqualizerTap0_READ_RealPart
// S2DEMOD_EqualizerTap1_GET_ImaginaryPart
// S2DEMOD_EqualizerTap1_GET_RealPart
// S2DEMOD_EqualizerTap1_READ
// S2DEMOD_EqualizerTap1_READ_ImaginaryPart
// S2DEMOD_EqualizerTap1_READ_RealPart
// S2DEMOD_EqualizerTap2_GET_ImaginaryPart
// S2DEMOD_EqualizerTap2_GET_RealPart
// S2DEMOD_EqualizerTap2_READ
// S2DEMOD_EqualizerTap2_READ_ImaginaryPart
// S2DEMOD_EqualizerTap2_READ_RealPart
// S2DEMOD_EqualizerTap3_GET_ImaginaryPart
// S2DEMOD_EqualizerTap3_GET_RealPart
// S2DEMOD_EqualizerTap3_READ
// S2DEMOD_EqualizerTap3_READ_ImaginaryPart
// S2DEMOD_EqualizerTap3_READ_RealPart
// S2DEMOD_EqualizerTap4_GET_ImaginaryPart
// S2DEMOD_EqualizerTap4_GET_RealPart
// S2DEMOD_EqualizerTap4_READ
// S2DEMOD_EqualizerTap4_READ_ImaginaryPart
// S2DEMOD_EqualizerTap4_READ_RealPart
// S2DEMOD_EqualizerTap5_GET_ImaginaryPart
// S2DEMOD_EqualizerTap5_GET_RealPart
// S2DEMOD_EqualizerTap5_READ
// S2DEMOD_EqualizerTap5_READ_ImaginaryPart
// S2DEMOD_EqualizerTap5_READ_RealPart
// S2DEMOD_EqualizerTap6_GET_ImaginaryPart
// S2DEMOD_EqualizerTap6_GET_RealPart
// S2DEMOD_EqualizerTap6_READ
// S2DEMOD_EqualizerTap6_READ_ImaginaryPart
// S2DEMOD_EqualizerTap6_READ_RealPart
// S2DEMOD_Equalizer_GET_Mode
// S2DEMOD_Equalizer_GET_StepSize
// S2DEMOD_Equalizer_READ
// S2DEMOD_Equalizer_SET_Mode
// S2DEMOD_Equalizer_SET_StepSize
// S2DEMOD_Equalizer_WRITE
// S2DEMOD_FftSpectrum0_GET_AbsValueSquareBin0
// S2DEMOD_FftSpectrum0_READ
// S2DEMOD_FftSpectrum0_READ_AbsValueSquareBin0
// S2DEMOD_FftSpectrum100_GET_AbsValueSquareBin100
// S2DEMOD_FftSpectrum100_READ
// S2DEMOD_FftSpectrum100_READ_AbsValueSquareBin100
// S2DEMOD_FftSpectrum101_GET_AbsValueSquareBin101
// S2DEMOD_FftSpectrum101_READ
// S2DEMOD_FftSpectrum101_READ_AbsValueSquareBin101
// S2DEMOD_FftSpectrum102_GET_AbsValueSquareBin102
// S2DEMOD_FftSpectrum102_READ
// S2DEMOD_FftSpectrum102_READ_AbsValueSquareBin102
// S2DEMOD_FftSpectrum103_GET_AbsValueSquareBin103
// S2DEMOD_FftSpectrum103_READ
// S2DEMOD_FftSpectrum103_READ_AbsValueSquareBin103
// S2DEMOD_FftSpectrum104_GET_AbsValueSquareBin104
// S2DEMOD_FftSpectrum104_READ
// S2DEMOD_FftSpectrum104_READ_AbsValueSquareBin104
// S2DEMOD_FftSpectrum105_GET_AbsValueSquareBin105
// S2DEMOD_FftSpectrum105_READ
// S2DEMOD_FftSpectrum105_READ_AbsValueSquareBin105
// S2DEMOD_FftSpectrum106_GET_AbsValueSquareBin106
// S2DEMOD_FftSpectrum106_READ
// S2DEMOD_FftSpectrum106_READ_AbsValueSquareBin106
// S2DEMOD_FftSpectrum107_GET_AbsValueSquareBin107
// S2DEMOD_FftSpectrum107_READ
// S2DEMOD_FftSpectrum107_READ_AbsValueSquareBin107
// S2DEMOD_FftSpectrum108_GET_AbsValueSquareBin108
// S2DEMOD_FftSpectrum108_READ
// S2DEMOD_FftSpectrum108_READ_AbsValueSquareBin108
// S2DEMOD_FftSpectrum109_GET_AbsValueSquareBin109
// S2DEMOD_FftSpectrum109_READ
// S2DEMOD_FftSpectrum109_READ_AbsValueSquareBin109
// S2DEMOD_FftSpectrum10_GET_AbsValueSquareBin10
// S2DEMOD_FftSpectrum10_READ
// S2DEMOD_FftSpectrum10_READ_AbsValueSquareBin10
// S2DEMOD_FftSpectrum110_GET_AbsValueSquareBin110
// S2DEMOD_FftSpectrum110_READ
// S2DEMOD_FftSpectrum110_READ_AbsValueSquareBin110
// S2DEMOD_FftSpectrum111_GET_AbsValueSquareBin111
// S2DEMOD_FftSpectrum111_READ
// S2DEMOD_FftSpectrum111_READ_AbsValueSquareBin111
// S2DEMOD_FftSpectrum112_GET_AbsValueSquareBin112
// S2DEMOD_FftSpectrum112_READ
// S2DEMOD_FftSpectrum112_READ_AbsValueSquareBin112
// S2DEMOD_FftSpectrum113_GET_AbsValueSquareBin113
// S2DEMOD_FftSpectrum113_READ
// S2DEMOD_FftSpectrum113_READ_AbsValueSquareBin113
// S2DEMOD_FftSpectrum114_GET_AbsValueSquareBin114
// S2DEMOD_FftSpectrum114_READ
// S2DEMOD_FftSpectrum114_READ_AbsValueSquareBin114
// S2DEMOD_FftSpectrum115_GET_AbsValueSquareBin115
// S2DEMOD_FftSpectrum115_READ
// S2DEMOD_FftSpectrum115_READ_AbsValueSquareBin115
// S2DEMOD_FftSpectrum116_GET_AbsValueSquareBin116
// S2DEMOD_FftSpectrum116_READ
// S2DEMOD_FftSpectrum116_READ_AbsValueSquareBin116
// S2DEMOD_FftSpectrum117_GET_AbsValueSquareBin117
// S2DEMOD_FftSpectrum117_READ
// S2DEMOD_FftSpectrum117_READ_AbsValueSquareBin117
// S2DEMOD_FftSpectrum118_GET_AbsValueSquareBin118
// S2DEMOD_FftSpectrum118_READ
// S2DEMOD_FftSpectrum118_READ_AbsValueSquareBin118
// S2DEMOD_FftSpectrum119_GET_AbsValueSquareBin119
// S2DEMOD_FftSpectrum119_READ
// S2DEMOD_FftSpectrum119_READ_AbsValueSquareBin119
// S2DEMOD_FftSpectrum11_GET_AbsValueSquareBin11
// S2DEMOD_FftSpectrum11_READ
// S2DEMOD_FftSpectrum11_READ_AbsValueSquareBin11
// S2DEMOD_FftSpectrum120_GET_AbsValueSquareBin120
// S2DEMOD_FftSpectrum120_READ
// S2DEMOD_FftSpectrum120_READ_AbsValueSquareBin120
// S2DEMOD_FftSpectrum121_GET_AbsValueSquareBin121
// S2DEMOD_FftSpectrum121_READ
// S2DEMOD_FftSpectrum121_READ_AbsValueSquareBin121
// S2DEMOD_FftSpectrum122_GET_AbsValueSquareBin122
// S2DEMOD_FftSpectrum122_READ
// S2DEMOD_FftSpectrum122_READ_AbsValueSquareBin122
// S2DEMOD_FftSpectrum123_GET_AbsValueSquareBin123
// S2DEMOD_FftSpectrum123_READ
// S2DEMOD_FftSpectrum123_READ_AbsValueSquareBin123
// S2DEMOD_FftSpectrum124_GET_AbsValueSquareBin124
// S2DEMOD_FftSpectrum124_READ
// S2DEMOD_FftSpectrum124_READ_AbsValueSquareBin124
// S2DEMOD_FftSpectrum125_GET_AbsValueSquareBin125
// S2DEMOD_FftSpectrum125_READ
// S2DEMOD_FftSpectrum125_READ_AbsValueSquareBin125
// S2DEMOD_FftSpectrum126_GET_AbsValueSquareBin126
// S2DEMOD_FftSpectrum126_READ
// S2DEMOD_FftSpectrum126_READ_AbsValueSquareBin126
// S2DEMOD_FftSpectrum127_GET_AbsValueSquareBin127
// S2DEMOD_FftSpectrum127_READ
// S2DEMOD_FftSpectrum127_READ_AbsValueSquareBin127
// S2DEMOD_FftSpectrum12_GET_AbsValueSquareBin12
// S2DEMOD_FftSpectrum12_READ
// S2DEMOD_FftSpectrum12_READ_AbsValueSquareBin12
// S2DEMOD_FftSpectrum13_GET_AbsValueSquareBin13
// S2DEMOD_FftSpectrum13_READ
// S2DEMOD_FftSpectrum13_READ_AbsValueSquareBin13
// S2DEMOD_FftSpectrum14_GET_AbsValueSquareBin14
// S2DEMOD_FftSpectrum14_READ
// S2DEMOD_FftSpectrum14_READ_AbsValueSquareBin14
// S2DEMOD_FftSpectrum15_GET_AbsValueSquareBin15
// S2DEMOD_FftSpectrum15_READ
// S2DEMOD_FftSpectrum15_READ_AbsValueSquareBin15
// S2DEMOD_FftSpectrum16_GET_AbsValueSquareBin16
// S2DEMOD_FftSpectrum16_READ
// S2DEMOD_FftSpectrum16_READ_AbsValueSquareBin16
// S2DEMOD_FftSpectrum17_GET_AbsValueSquareBin17
// S2DEMOD_FftSpectrum17_READ
// S2DEMOD_FftSpectrum17_READ_AbsValueSquareBin17
// S2DEMOD_FftSpectrum18_GET_AbsValueSquareBin18
// S2DEMOD_FftSpectrum18_READ
// S2DEMOD_FftSpectrum18_READ_AbsValueSquareBin18
// S2DEMOD_FftSpectrum19_GET_AbsValueSquareBin19
// S2DEMOD_FftSpectrum19_READ
// S2DEMOD_FftSpectrum19_READ_AbsValueSquareBin19
// S2DEMOD_FftSpectrum1_GET_AbsValueSquareBin1
// S2DEMOD_FftSpectrum1_READ
// S2DEMOD_FftSpectrum1_READ_AbsValueSquareBin1
// S2DEMOD_FftSpectrum20_GET_AbsValueSquareBin20
// S2DEMOD_FftSpectrum20_READ
// S2DEMOD_FftSpectrum20_READ_AbsValueSquareBin20
// S2DEMOD_FftSpectrum21_GET_AbsValueSquareBin21
// S2DEMOD_FftSpectrum21_READ
// S2DEMOD_FftSpectrum21_READ_AbsValueSquareBin21
// S2DEMOD_FftSpectrum22_GET_AbsValueSquareBin22
// S2DEMOD_FftSpectrum22_READ
// S2DEMOD_FftSpectrum22_READ_AbsValueSquareBin22
// S2DEMOD_FftSpectrum23_GET_AbsValueSquareBin23
// S2DEMOD_FftSpectrum23_READ
// S2DEMOD_FftSpectrum23_READ_AbsValueSquareBin23
// S2DEMOD_FftSpectrum24_GET_AbsValueSquareBin24
// S2DEMOD_FftSpectrum24_READ
// S2DEMOD_FftSpectrum24_READ_AbsValueSquareBin24
// S2DEMOD_FftSpectrum25_GET_AbsValueSquareBin25
// S2DEMOD_FftSpectrum25_READ
// S2DEMOD_FftSpectrum25_READ_AbsValueSquareBin25
// S2DEMOD_FftSpectrum26_GET_AbsValueSquareBin26
// S2DEMOD_FftSpectrum26_READ
// S2DEMOD_FftSpectrum26_READ_AbsValueSquareBin26
// S2DEMOD_FftSpectrum27_GET_AbsValueSquareBin27
// S2DEMOD_FftSpectrum27_READ
// S2DEMOD_FftSpectrum27_READ_AbsValueSquareBin27
// S2DEMOD_FftSpectrum28_GET_AbsValueSquareBin28
// S2DEMOD_FftSpectrum28_READ
// S2DEMOD_FftSpectrum28_READ_AbsValueSquareBin28
// S2DEMOD_FftSpectrum29_GET_AbsValueSquareBin29
// S2DEMOD_FftSpectrum29_READ
// S2DEMOD_FftSpectrum29_READ_AbsValueSquareBin29
// S2DEMOD_FftSpectrum2_GET_AbsValueSquareBin2
// S2DEMOD_FftSpectrum2_READ
// S2DEMOD_FftSpectrum2_READ_AbsValueSquareBin2
// S2DEMOD_FftSpectrum30_GET_AbsValueSquareBin30
// S2DEMOD_FftSpectrum30_READ
// S2DEMOD_FftSpectrum30_READ_AbsValueSquareBin30
// S2DEMOD_FftSpectrum31_GET_AbsValueSquareBin31
// S2DEMOD_FftSpectrum31_READ
// S2DEMOD_FftSpectrum31_READ_AbsValueSquareBin31
// S2DEMOD_FftSpectrum32_GET_AbsValueSquareBin32
// S2DEMOD_FftSpectrum32_READ
// S2DEMOD_FftSpectrum32_READ_AbsValueSquareBin32
// S2DEMOD_FftSpectrum33_GET_AbsValueSquareBin33
// S2DEMOD_FftSpectrum33_READ
// S2DEMOD_FftSpectrum33_READ_AbsValueSquareBin33
// S2DEMOD_FftSpectrum34_GET_AbsValueSquareBin34
// S2DEMOD_FftSpectrum34_READ
// S2DEMOD_FftSpectrum34_READ_AbsValueSquareBin34
// S2DEMOD_FftSpectrum35_GET_AbsValueSquareBin35
// S2DEMOD_FftSpectrum35_READ
// S2DEMOD_FftSpectrum35_READ_AbsValueSquareBin35
// S2DEMOD_FftSpectrum36_GET_AbsValueSquareBin36
// S2DEMOD_FftSpectrum36_READ
// S2DEMOD_FftSpectrum36_READ_AbsValueSquareBin36
// S2DEMOD_FftSpectrum37_GET_AbsValueSquareBin37
// S2DEMOD_FftSpectrum37_READ
// S2DEMOD_FftSpectrum37_READ_AbsValueSquareBin37
// S2DEMOD_FftSpectrum38_GET_AbsValueSquareBin38
// S2DEMOD_FftSpectrum38_READ
// S2DEMOD_FftSpectrum38_READ_AbsValueSquareBin38
// S2DEMOD_FftSpectrum39_GET_AbsValueSquareBin39
// S2DEMOD_FftSpectrum39_READ
// S2DEMOD_FftSpectrum39_READ_AbsValueSquareBin39
// S2DEMOD_FftSpectrum3_GET_AbsValueSquareBin3
// S2DEMOD_FftSpectrum3_READ
// S2DEMOD_FftSpectrum3_READ_AbsValueSquareBin3
// S2DEMOD_FftSpectrum40_GET_AbsValueSquareBin40
// S2DEMOD_FftSpectrum40_READ
// S2DEMOD_FftSpectrum40_READ_AbsValueSquareBin40
// S2DEMOD_FftSpectrum41_GET_AbsValueSquareBin41
// S2DEMOD_FftSpectrum41_READ
// S2DEMOD_FftSpectrum41_READ_AbsValueSquareBin41
// S2DEMOD_FftSpectrum42_GET_AbsValueSquareBin42
// S2DEMOD_FftSpectrum42_READ
// S2DEMOD_FftSpectrum42_READ_AbsValueSquareBin42
// S2DEMOD_FftSpectrum43_GET_AbsValueSquareBin43
// S2DEMOD_FftSpectrum43_READ
// S2DEMOD_FftSpectrum43_READ_AbsValueSquareBin43
// S2DEMOD_FftSpectrum44_GET_AbsValueSquareBin44
// S2DEMOD_FftSpectrum44_READ
// S2DEMOD_FftSpectrum44_READ_AbsValueSquareBin44
// S2DEMOD_FftSpectrum45_GET_AbsValueSquareBin45
// S2DEMOD_FftSpectrum45_READ
// S2DEMOD_FftSpectrum45_READ_AbsValueSquareBin45
// S2DEMOD_FftSpectrum46_GET_AbsValueSquareBin46
// S2DEMOD_FftSpectrum46_READ
// S2DEMOD_FftSpectrum46_READ_AbsValueSquareBin46
// S2DEMOD_FftSpectrum47_GET_AbsValueSquareBin47
// S2DEMOD_FftSpectrum47_READ
// S2DEMOD_FftSpectrum47_READ_AbsValueSquareBin47
// S2DEMOD_FftSpectrum48_GET_AbsValueSquareBin48
// S2DEMOD_FftSpectrum48_READ
// S2DEMOD_FftSpectrum48_READ_AbsValueSquareBin48
// S2DEMOD_FftSpectrum49_GET_AbsValueSquareBin49
// S2DEMOD_FftSpectrum49_READ
// S2DEMOD_FftSpectrum49_READ_AbsValueSquareBin49
// S2DEMOD_FftSpectrum4_GET_AbsValueSquareBin4
// S2DEMOD_FftSpectrum4_READ
// S2DEMOD_FftSpectrum4_READ_AbsValueSquareBin4
// S2DEMOD_FftSpectrum50_GET_AbsValueSquareBin50
// S2DEMOD_FftSpectrum50_READ
// S2DEMOD_FftSpectrum50_READ_AbsValueSquareBin50
// S2DEMOD_FftSpectrum51_GET_AbsValueSquareBin51
// S2DEMOD_FftSpectrum51_READ
// S2DEMOD_FftSpectrum51_READ_AbsValueSquareBin51
// S2DEMOD_FftSpectrum52_GET_AbsValueSquareBin52
// S2DEMOD_FftSpectrum52_READ
// S2DEMOD_FftSpectrum52_READ_AbsValueSquareBin52
// S2DEMOD_FftSpectrum53_GET_AbsValueSquareBin53
// S2DEMOD_FftSpectrum53_READ
// S2DEMOD_FftSpectrum53_READ_AbsValueSquareBin53
// S2DEMOD_FftSpectrum54_GET_AbsValueSquareBin54
// S2DEMOD_FftSpectrum54_READ
// S2DEMOD_FftSpectrum54_READ_AbsValueSquareBin54
// S2DEMOD_FftSpectrum55_GET_AbsValueSquareBin55
// S2DEMOD_FftSpectrum55_READ
// S2DEMOD_FftSpectrum55_READ_AbsValueSquareBin55
// S2DEMOD_FftSpectrum56_GET_AbsValueSquareBin56
// S2DEMOD_FftSpectrum56_READ
// S2DEMOD_FftSpectrum56_READ_AbsValueSquareBin56
// S2DEMOD_FftSpectrum57_GET_AbsValueSquareBin57
// S2DEMOD_FftSpectrum57_READ
// S2DEMOD_FftSpectrum57_READ_AbsValueSquareBin57
// S2DEMOD_FftSpectrum58_GET_AbsValueSquareBin58
// S2DEMOD_FftSpectrum58_READ
// S2DEMOD_FftSpectrum58_READ_AbsValueSquareBin58
// S2DEMOD_FftSpectrum59_GET_AbsValueSquareBin59
// S2DEMOD_FftSpectrum59_READ
// S2DEMOD_FftSpectrum59_READ_AbsValueSquareBin59
// S2DEMOD_FftSpectrum5_GET_AbsValueSquareBin5
// S2DEMOD_FftSpectrum5_READ
// S2DEMOD_FftSpectrum5_READ_AbsValueSquareBin5
// S2DEMOD_FftSpectrum60_GET_AbsValueSquareBin60
// S2DEMOD_FftSpectrum60_READ
// S2DEMOD_FftSpectrum60_READ_AbsValueSquareBin60
// S2DEMOD_FftSpectrum61_GET_AbsValueSquareBin61
// S2DEMOD_FftSpectrum61_READ
// S2DEMOD_FftSpectrum61_READ_AbsValueSquareBin61
// S2DEMOD_FftSpectrum62_GET_AbsValueSquareBin62
// S2DEMOD_FftSpectrum62_READ
// S2DEMOD_FftSpectrum62_READ_AbsValueSquareBin62
// S2DEMOD_FftSpectrum63_GET_AbsValueSquareBin63
// S2DEMOD_FftSpectrum63_READ
// S2DEMOD_FftSpectrum63_READ_AbsValueSquareBin63
// S2DEMOD_FftSpectrum64_GET_AbsValueSquareBin64
// S2DEMOD_FftSpectrum64_READ
// S2DEMOD_FftSpectrum64_READ_AbsValueSquareBin64
// S2DEMOD_FftSpectrum65_GET_AbsValueSquareBin65
// S2DEMOD_FftSpectrum65_READ
// S2DEMOD_FftSpectrum65_READ_AbsValueSquareBin65
// S2DEMOD_FftSpectrum66_GET_AbsValueSquareBin66
// S2DEMOD_FftSpectrum66_READ
// S2DEMOD_FftSpectrum66_READ_AbsValueSquareBin66
// S2DEMOD_FftSpectrum67_GET_AbsValueSquareBin67
// S2DEMOD_FftSpectrum67_READ
// S2DEMOD_FftSpectrum67_READ_AbsValueSquareBin67
// S2DEMOD_FftSpectrum68_GET_AbsValueSquareBin68
// S2DEMOD_FftSpectrum68_READ
// S2DEMOD_FftSpectrum68_READ_AbsValueSquareBin68
// S2DEMOD_FftSpectrum69_GET_AbsValueSquareBin69
// S2DEMOD_FftSpectrum69_READ
// S2DEMOD_FftSpectrum69_READ_AbsValueSquareBin69
// S2DEMOD_FftSpectrum6_GET_AbsValueSquareBin6
// S2DEMOD_FftSpectrum6_READ
// S2DEMOD_FftSpectrum6_READ_AbsValueSquareBin6
// S2DEMOD_FftSpectrum70_GET_AbsValueSquareBin70
// S2DEMOD_FftSpectrum70_READ
// S2DEMOD_FftSpectrum70_READ_AbsValueSquareBin70
// S2DEMOD_FftSpectrum71_GET_AbsValueSquareBin71
// S2DEMOD_FftSpectrum71_READ
// S2DEMOD_FftSpectrum71_READ_AbsValueSquareBin71
// S2DEMOD_FftSpectrum72_GET_AbsValueSquareBin72
// S2DEMOD_FftSpectrum72_READ
// S2DEMOD_FftSpectrum72_READ_AbsValueSquareBin72
// S2DEMOD_FftSpectrum73_GET_AbsValueSquareBin73
// S2DEMOD_FftSpectrum73_READ
// S2DEMOD_FftSpectrum73_READ_AbsValueSquareBin73
// S2DEMOD_FftSpectrum74_GET_AbsValueSquareBin74
// S2DEMOD_FftSpectrum74_READ
// S2DEMOD_FftSpectrum74_READ_AbsValueSquareBin74
// S2DEMOD_FftSpectrum75_GET_AbsValueSquareBin75
// S2DEMOD_FftSpectrum75_READ
// S2DEMOD_FftSpectrum75_READ_AbsValueSquareBin75
// S2DEMOD_FftSpectrum76_GET_AbsValueSquareBin76
// S2DEMOD_FftSpectrum76_READ
// S2DEMOD_FftSpectrum76_READ_AbsValueSquareBin76
// S2DEMOD_FftSpectrum77_GET_AbsValueSquareBin77
// S2DEMOD_FftSpectrum77_READ
// S2DEMOD_FftSpectrum77_READ_AbsValueSquareBin77
// S2DEMOD_FftSpectrum78_GET_AbsValueSquareBin78
// S2DEMOD_FftSpectrum78_READ
// S2DEMOD_FftSpectrum78_READ_AbsValueSquareBin78
// S2DEMOD_FftSpectrum79_GET_AbsValueSquareBin79
// S2DEMOD_FftSpectrum79_READ
// S2DEMOD_FftSpectrum79_READ_AbsValueSquareBin79
// S2DEMOD_FftSpectrum7_GET_AbsValueSquareBin7
// S2DEMOD_FftSpectrum7_READ
// S2DEMOD_FftSpectrum7_READ_AbsValueSquareBin7
// S2DEMOD_FftSpectrum80_GET_AbsValueSquareBin80
// S2DEMOD_FftSpectrum80_READ
// S2DEMOD_FftSpectrum80_READ_AbsValueSquareBin80
// S2DEMOD_FftSpectrum81_GET_AbsValueSquareBin81
// S2DEMOD_FftSpectrum81_READ
// S2DEMOD_FftSpectrum81_READ_AbsValueSquareBin81
// S2DEMOD_FftSpectrum82_GET_AbsValueSquareBin82
// S2DEMOD_FftSpectrum82_READ
// S2DEMOD_FftSpectrum82_READ_AbsValueSquareBin82
// S2DEMOD_FftSpectrum83_GET_AbsValueSquareBin83
// S2DEMOD_FftSpectrum83_READ
// S2DEMOD_FftSpectrum83_READ_AbsValueSquareBin83
// S2DEMOD_FftSpectrum84_GET_AbsValueSquareBin84
// S2DEMOD_FftSpectrum84_READ
// S2DEMOD_FftSpectrum84_READ_AbsValueSquareBin84
// S2DEMOD_FftSpectrum85_GET_AbsValueSquareBin85
// S2DEMOD_FftSpectrum85_READ
// S2DEMOD_FftSpectrum85_READ_AbsValueSquareBin85
// S2DEMOD_FftSpectrum86_GET_AbsValueSquareBin86
// S2DEMOD_FftSpectrum86_READ
// S2DEMOD_FftSpectrum86_READ_AbsValueSquareBin86
// S2DEMOD_FftSpectrum87_GET_AbsValueSquareBin87
// S2DEMOD_FftSpectrum87_READ
// S2DEMOD_FftSpectrum87_READ_AbsValueSquareBin87
// S2DEMOD_FftSpectrum88_GET_AbsValueSquareBin88
// S2DEMOD_FftSpectrum88_READ
// S2DEMOD_FftSpectrum88_READ_AbsValueSquareBin88
// S2DEMOD_FftSpectrum89_GET_AbsValueSquareBin89
// S2DEMOD_FftSpectrum89_READ
// S2DEMOD_FftSpectrum89_READ_AbsValueSquareBin89
// S2DEMOD_FftSpectrum8_GET_AbsValueSquareBin8
// S2DEMOD_FftSpectrum8_READ
// S2DEMOD_FftSpectrum8_READ_AbsValueSquareBin8
// S2DEMOD_FftSpectrum90_GET_AbsValueSquareBin90
// S2DEMOD_FftSpectrum90_READ
// S2DEMOD_FftSpectrum90_READ_AbsValueSquareBin90
// S2DEMOD_FftSpectrum91_GET_AbsValueSquareBin91
// S2DEMOD_FftSpectrum91_READ
// S2DEMOD_FftSpectrum91_READ_AbsValueSquareBin91
// S2DEMOD_FftSpectrum92_GET_AbsValueSquareBin92
// S2DEMOD_FftSpectrum92_READ
// S2DEMOD_FftSpectrum92_READ_AbsValueSquareBin92
// S2DEMOD_FftSpectrum93_GET_AbsValueSquareBin93
// S2DEMOD_FftSpectrum93_READ
// S2DEMOD_FftSpectrum93_READ_AbsValueSquareBin93
// S2DEMOD_FftSpectrum94_GET_AbsValueSquareBin94
// S2DEMOD_FftSpectrum94_READ
// S2DEMOD_FftSpectrum94_READ_AbsValueSquareBin94
// S2DEMOD_FftSpectrum95_GET_AbsValueSquareBin95
// S2DEMOD_FftSpectrum95_READ
// S2DEMOD_FftSpectrum95_READ_AbsValueSquareBin95
// S2DEMOD_FftSpectrum96_GET_AbsValueSquareBin96
// S2DEMOD_FftSpectrum96_READ
// S2DEMOD_FftSpectrum96_READ_AbsValueSquareBin96
// S2DEMOD_FftSpectrum97_GET_AbsValueSquareBin97
// S2DEMOD_FftSpectrum97_READ
// S2DEMOD_FftSpectrum97_READ_AbsValueSquareBin97
// S2DEMOD_FftSpectrum98_GET_AbsValueSquareBin98
// S2DEMOD_FftSpectrum98_READ
// S2DEMOD_FftSpectrum98_READ_AbsValueSquareBin98
// S2DEMOD_FftSpectrum99_GET_AbsValueSquareBin99
// S2DEMOD_FftSpectrum99_READ
// S2DEMOD_FftSpectrum99_READ_AbsValueSquareBin99
// S2DEMOD_FftSpectrum9_GET_AbsValueSquareBin9
// S2DEMOD_FftSpectrum9_READ
// S2DEMOD_FftSpectrum9_READ_AbsValueSquareBin9
// S2DEMOD_FineFreqOffset_GET_FreqOffset
// S2DEMOD_FineFreqOffset_READ
// S2DEMOD_FineFreqOffset_READ_FreqOffset
// S2DEMOD_FineFreqWindowLength_READ
// S2DEMOD_FineFreqWindowLength_WRITE
// S2DEMOD_FinePhaseOffset_READ
// S2DEMOD_FreqLoopFilterCoef0_GET_ACQCoefficientK1
// S2DEMOD_FreqLoopFilterCoef0_READ
// S2DEMOD_FreqLoopFilterCoef0_SET_ACQCoefficientK1
// S2DEMOD_FreqLoopFilterCoef0_WRITE
// S2DEMOD_FreqLoopFilterCoef1_READ_ACQCoefficientK2
// S2DEMOD_FreqLoopFilterCoef1_WRITE_ACQCoefficientK2
// S2DEMOD_FreqLoopFilterCoef2_GET_TRKCoefficientK1
// S2DEMOD_FreqLoopFilterCoef2_READ
// S2DEMOD_FreqLoopFilterCoef2_SET_TRKCoefficientK1
// S2DEMOD_FreqLoopFilterCoef2_WRITE
// S2DEMOD_FreqLoopFilterCoef3_READ_TRKCoefficientK2
// S2DEMOD_FreqLoopFilterCoef3_WRITE_TRKCoefficientK2
// S2DEMOD_FreqOffset_READ
// S2DEMOD_GlobalControl_GET_SoftReset
// S2DEMOD_GlobalControl_READ
// S2DEMOD_GlobalControl_SET_SoftReset
// S2DEMOD_GlobalControl_WRITE
// S2DEMOD_GlobalStatus_GET_Demodulator
// S2DEMOD_GlobalStatus_GET_FineFrequency
// S2DEMOD_GlobalStatus_GET_FrequencyLoop
// S2DEMOD_GlobalStatus_GET_NoSignal
// S2DEMOD_GlobalStatus_GET_PlHeaderSync
// S2DEMOD_GlobalStatus_GET_TimingLoop
// S2DEMOD_GlobalStatus_READ
// S2DEMOD_GlobalStatus_READ_Demodulator
// S2DEMOD_GlobalStatus_READ_FineFrequency
// S2DEMOD_GlobalStatus_READ_FrequencyLoop
// S2DEMOD_GlobalStatus_READ_NoSignal
// S2DEMOD_GlobalStatus_READ_PlHeaderSync
// S2DEMOD_GlobalStatus_READ_TimingLoop
// S2DEMOD_InitSampleRateRatio_READ
// S2DEMOD_InitSampleRateRatio_WRITE
// S2DEMOD_InitSymbRateRatio_GET_InitSymbolRateRatio
// S2DEMOD_InitSymbRateRatio_READ
// S2DEMOD_InitSymbRateRatio_SET_InitSymbolRateRatio
// S2DEMOD_InitSymbRateRatio_WRITE
// S2DEMOD_InterruptEnable_GET_Demodulator
// S2DEMOD_InterruptEnable_GET_FrequencyLoop
// S2DEMOD_InterruptEnable_GET_PlHeaderSync
// S2DEMOD_InterruptEnable_GET_TimingLoop
// S2DEMOD_InterruptEnable_READ
// S2DEMOD_InterruptEnable_SET_Demodulator
// S2DEMOD_InterruptEnable_SET_FrequencyLoop
// S2DEMOD_InterruptEnable_SET_PlHeaderSync
// S2DEMOD_InterruptEnable_SET_TimingLoop
// S2DEMOD_InterruptEnable_WRITE
// S2DEMOD_InterruptStatus_GET_Demodulator
// S2DEMOD_InterruptStatus_GET_FrequencyLoop
// S2DEMOD_InterruptStatus_GET_PlHeaderSync
// S2DEMOD_InterruptStatus_GET_TimingLoop
// S2DEMOD_InterruptStatus_READ
// S2DEMOD_InterruptStatus_SET_Demodulator
// S2DEMOD_InterruptStatus_SET_FrequencyLoop
// S2DEMOD_InterruptStatus_SET_PlHeaderSync
// S2DEMOD_InterruptStatus_SET_TimingLoop
// S2DEMOD_InterruptStatus_WRITE
// S2DEMOD_IqImbalanceValue_GET_MagnitudeImbalance
// S2DEMOD_IqImbalanceValue_GET_PhaseImbalance
// S2DEMOD_IqImbalanceValue_READ
// S2DEMOD_IqImbalanceValue_READ_MagnitudeImbalance
// S2DEMOD_IqImbalanceValue_READ_PhaseImbalance
// S2DEMOD_MeasSymbRateRatio_GET_MeasSymbolRateRatio
// S2DEMOD_MeasSymbRateRatio_READ
// S2DEMOD_MeasSymbRateRatio_SET_MeasSymbolRateRatio
// S2DEMOD_MeasSymbRateRatio_WRITE
// S2DEMOD_NdaAgcGainFactor_GET_AgcGain
// S2DEMOD_NdaAgcGainFactor_READ
// S2DEMOD_NdaAgcGainFactor_READ_AgcGain
// S2DEMOD_NdaAgcWindowLength_GET_WindowLength
// S2DEMOD_NdaAgcWindowLength_READ
// S2DEMOD_NdaAgcWindowLength_SET_WindowLength
// S2DEMOD_NdaAgcWindowLength_WRITE
// S2DEMOD_PlInformation_GET_Mode
// S2DEMOD_PlInformation_GET_PlsValue
// S2DEMOD_PlInformation_READ
// S2DEMOD_PlInformation_SET_Mode
// S2DEMOD_PlInformation_SET_PlsValue
// S2DEMOD_PlInformation_WRITE
// S2DEMOD_RollOff_GET_Direct
// S2DEMOD_RollOff_GET_Factor
// S2DEMOD_RollOff_READ
// S2DEMOD_RollOff_SET_Direct
// S2DEMOD_RollOff_SET_Factor
// S2DEMOD_RollOff_WRITE
// S2DEMOD_ScramblerStartSeq_GET_ScramblerSequence
// S2DEMOD_ScramblerStartSeq_READ
// S2DEMOD_ScramblerStartSeq_SET_ScramblerSequence
// S2DEMOD_ScramblerStartSeq_WRITE
// S2DEMOD_SnrEstimErrorPower_READ_ErrorPower
// S2DEMOD_SnrEstimSignalPower_GET_SignalPower
// S2DEMOD_SnrEstimSignalPower_READ
// S2DEMOD_SnrEstimSignalPower_READ_SignalPower
// S2DEMOD_SnrEstimatorFrames_GET_SnrFrames
// S2DEMOD_SnrEstimatorFrames_READ
// S2DEMOD_SnrEstimatorFrames_SET_SnrFrames
// S2DEMOD_SnrEstimatorFrames_WRITE
// S2DEMOD_SpectrumInversion_GET_AutoDetect
// S2DEMOD_SpectrumInversion_GET_InitialValue
// S2DEMOD_SpectrumInversion_READ
// S2DEMOD_SpectrumInversion_SET_AutoDetect
// S2DEMOD_SpectrumInversion_SET_InitialValue
// S2DEMOD_SpectrumInversion_WRITE
// S2DEMOD_TimingLoopFiltCoef0_GET_ACQCoefficientG0
// S2DEMOD_TimingLoopFiltCoef0_READ
// S2DEMOD_TimingLoopFiltCoef0_SET_ACQCoefficientG0
// S2DEMOD_TimingLoopFiltCoef0_WRITE
// S2DEMOD_TimingLoopFiltCoef1_GET_ACQCoefficientG1
// S2DEMOD_TimingLoopFiltCoef1_READ
// S2DEMOD_TimingLoopFiltCoef1_SET_ACQCoefficientG1
// S2DEMOD_TimingLoopFiltCoef1_WRITE
// S2DEMOD_TimingLoopFiltCoef2_GET_TRKCoefficientG0
// S2DEMOD_TimingLoopFiltCoef2_READ
// S2DEMOD_TimingLoopFiltCoef2_SET_TRKCoefficientG0
// S2DEMOD_TimingLoopFiltCoef2_WRITE
// S2DEMOD_TimingLoopFiltCoef3_GET_TRKCoefficientG1
// S2DEMOD_TimingLoopFiltCoef3_READ
// S2DEMOD_TimingLoopFiltCoef3_SET_TRKCoefficientG1
// S2DEMOD_TimingLoopFiltCoef3_WRITE
// S2DEMOD_Trigger_GET_Equalizer
// S2DEMOD_Trigger_GET_Spectrum
// S2DEMOD_Trigger_READ
// S2DEMOD_Trigger_SET_Equalizer
// S2DEMOD_Trigger_SET_Spectrum
// S2DEMOD_Trigger_WRITE
// S2DEMOD_Undocumented94_READ
// S2DEMOD_Undocumented94_WRITE
// S2DEMOD_UndocumentedD0_READ
// S2DEMOD_UndocumentedD0_WRITE
// S2DEMOD_UndocumentedD4_READ
// S2DEMOD_UndocumentedD4_WRITE
// S2DEMOD_UndocumentedD8_READ
// S2DEMOD_UndocumentedD8_WRITE
// S2DEMOD_UndocumentedDC_READ
// S2DEMOD_UndocumentedDC_WRITE
// S2DEMOD_UndocumentedE0_READ
// S2DEMOD_UndocumentedE0_WRITE
// S2DEMOD_UndocumentedE4_READ
// S2DEMOD_UndocumentedE4_WRITE
// S2DEMOD_UndocumentedE8_READ
// S2DEMOD_UndocumentedE8_WRITE
// S2DEMOD_UndocumentedEC_READ
// S2DEMOD_UndocumentedEC_WRITE
// S2DEMOD_UndocumentedF0_READ
// S2DEMOD_UndocumentedF0_WRITE

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'DemodRst' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field PULSE function
static __inline void  S2DEMOD_DemodRst_PULSE_DemodRst(DtBcS2DEMOD_2132* pBc)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x8, 0x1);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'CoreVersionInfo' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_CoreVersionInfo_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1000);
}

// Field GET functions
static __inline UInt32  S2DEMOD_CoreVersionInfo_GET_MinorVersion(UInt32 CoreVersionInfo)
{
    return CoreVersionInfo & 0xF;
}
static __inline UInt32  S2DEMOD_CoreVersionInfo_GET_MajorVersion(UInt32 CoreVersionInfo)
{
    return (CoreVersionInfo & 0xF0) >> 4;
}

// Field READ functions
static __inline UInt32  S2DEMOD_CoreVersionInfo_READ_MinorVersion(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1000) & 0xF;
}
static __inline UInt32  S2DEMOD_CoreVersionInfo_READ_MajorVersion(DtBcS2DEMOD_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x1000) & 0xF0) >> 4;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'GlobalStatus' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_GlobalStatus_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1004);
}

// Field GET functions
static __inline UInt32  S2DEMOD_GlobalStatus_GET_Demodulator(UInt32 GlobalStatus)
{
    return GlobalStatus & 0x1;
}
static __inline UInt32  S2DEMOD_GlobalStatus_GET_PlHeaderSync(UInt32 GlobalStatus)
{
    return (GlobalStatus & 0x2) >> 1;
}
static __inline UInt32  S2DEMOD_GlobalStatus_GET_TimingLoop(UInt32 GlobalStatus)
{
    return (GlobalStatus & 0x4) >> 2;
}
static __inline UInt32  S2DEMOD_GlobalStatus_GET_FrequencyLoop(UInt32 GlobalStatus)
{
    return (GlobalStatus & 0x8) >> 3;
}
static __inline UInt32  S2DEMOD_GlobalStatus_GET_NoSignal(UInt32 GlobalStatus)
{
    return (GlobalStatus & 0x10) >> 4;
}
static __inline UInt32  S2DEMOD_GlobalStatus_GET_FineFrequency(UInt32 GlobalStatus)
{
    return (GlobalStatus & 0x20) >> 5;
}

// Field READ functions
static __inline UInt32  S2DEMOD_GlobalStatus_READ_Demodulator(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1004) & 0x1;
}
static __inline UInt32  S2DEMOD_GlobalStatus_READ_PlHeaderSync(DtBcS2DEMOD_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x1004) & 0x2) >> 1;
}
static __inline UInt32  S2DEMOD_GlobalStatus_READ_TimingLoop(DtBcS2DEMOD_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x1004) & 0x4) >> 2;
}
static __inline UInt32  S2DEMOD_GlobalStatus_READ_FrequencyLoop(DtBcS2DEMOD_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x1004) & 0x8) >> 3;
}
static __inline UInt32  S2DEMOD_GlobalStatus_READ_NoSignal(DtBcS2DEMOD_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x1004) & 0x10) >> 4;
}
static __inline UInt32  S2DEMOD_GlobalStatus_READ_FineFrequency(DtBcS2DEMOD_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x1004) & 0x20) >> 5;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'GlobalControl' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_GlobalControl_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1008);
}

// Field GET function
static __inline UInt32  S2DEMOD_GlobalControl_GET_SoftReset(UInt32 GlobalControl)
{
    return GlobalControl & 0x1;
}

// Field SET function
static __inline UInt32  S2DEMOD_GlobalControl_SET_SoftReset(UInt32 GlobalControl, UInt32 SoftReset)
{
    DT_ASSERT((SoftReset & ~0x1) == 0);
    return (GlobalControl & ~0x1) | SoftReset;
}

// Register WRITE function
static __inline void  S2DEMOD_GlobalControl_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 GlobalControl)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1008, GlobalControl);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'InterruptStatus' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_InterruptStatus_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x100C);
}

// Field GET functions
static __inline UInt32  S2DEMOD_InterruptStatus_GET_Demodulator(UInt32 InterruptStatus)
{
    return InterruptStatus & 0x1;
}
static __inline UInt32  S2DEMOD_InterruptStatus_GET_PlHeaderSync(UInt32 InterruptStatus)
{
    return (InterruptStatus & 0x2) >> 1;
}
static __inline UInt32  S2DEMOD_InterruptStatus_GET_TimingLoop(UInt32 InterruptStatus)
{
    return (InterruptStatus & 0x4) >> 2;
}
static __inline UInt32  S2DEMOD_InterruptStatus_GET_FrequencyLoop(UInt32 InterruptStatus)
{
    return (InterruptStatus & 0x8) >> 3;
}

// Field SET functions
static __inline UInt32  S2DEMOD_InterruptStatus_SET_Demodulator(UInt32 InterruptStatus, UInt32 Demodulator)
{
    DT_ASSERT((Demodulator & ~0x1) == 0);
    return (InterruptStatus & ~0x1) | Demodulator;
}
static __inline UInt32  S2DEMOD_InterruptStatus_SET_PlHeaderSync(UInt32 InterruptStatus, UInt32 PlHeaderSync)
{
    DT_ASSERT((PlHeaderSync & ~0x1) == 0);
    return (InterruptStatus & ~0x2) | (PlHeaderSync << 1);
}
static __inline UInt32  S2DEMOD_InterruptStatus_SET_TimingLoop(UInt32 InterruptStatus, UInt32 TimingLoop)
{
    DT_ASSERT((TimingLoop & ~0x1) == 0);
    return (InterruptStatus & ~0x4) | (TimingLoop << 2);
}
static __inline UInt32  S2DEMOD_InterruptStatus_SET_FrequencyLoop(UInt32 InterruptStatus, UInt32 FrequencyLoop)
{
    DT_ASSERT((FrequencyLoop & ~0x1) == 0);
    return (InterruptStatus & ~0x8) | (FrequencyLoop << 3);
}

// Register WRITE function
static __inline void  S2DEMOD_InterruptStatus_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 InterruptStatus)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x100C, InterruptStatus);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'InterruptEnable' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_InterruptEnable_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1010);
}

// Field GET functions
static __inline UInt32  S2DEMOD_InterruptEnable_GET_Demodulator(UInt32 InterruptEnable)
{
    return InterruptEnable & 0x1;
}
static __inline UInt32  S2DEMOD_InterruptEnable_GET_PlHeaderSync(UInt32 InterruptEnable)
{
    return (InterruptEnable & 0x2) >> 1;
}
static __inline UInt32  S2DEMOD_InterruptEnable_GET_TimingLoop(UInt32 InterruptEnable)
{
    return (InterruptEnable & 0x4) >> 2;
}
static __inline UInt32  S2DEMOD_InterruptEnable_GET_FrequencyLoop(UInt32 InterruptEnable)
{
    return (InterruptEnable & 0x8) >> 3;
}

// Field SET functions
static __inline UInt32  S2DEMOD_InterruptEnable_SET_Demodulator(UInt32 InterruptEnable, UInt32 Demodulator)
{
    DT_ASSERT((Demodulator & ~0x1) == 0);
    return (InterruptEnable & ~0x1) | Demodulator;
}
static __inline UInt32  S2DEMOD_InterruptEnable_SET_PlHeaderSync(UInt32 InterruptEnable, UInt32 PlHeaderSync)
{
    DT_ASSERT((PlHeaderSync & ~0x1) == 0);
    return (InterruptEnable & ~0x2) | (PlHeaderSync << 1);
}
static __inline UInt32  S2DEMOD_InterruptEnable_SET_TimingLoop(UInt32 InterruptEnable, UInt32 TimingLoop)
{
    DT_ASSERT((TimingLoop & ~0x1) == 0);
    return (InterruptEnable & ~0x4) | (TimingLoop << 2);
}
static __inline UInt32  S2DEMOD_InterruptEnable_SET_FrequencyLoop(UInt32 InterruptEnable, UInt32 FrequencyLoop)
{
    DT_ASSERT((FrequencyLoop & ~0x1) == 0);
    return (InterruptEnable & ~0x8) | (FrequencyLoop << 3);
}

// Register WRITE function
static __inline void  S2DEMOD_InterruptEnable_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 InterruptEnable)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1010, InterruptEnable);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SpectrumInversion' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_SpectrumInversion_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1020);
}

// Field GET functions
static __inline UInt32  S2DEMOD_SpectrumInversion_GET_InitialValue(UInt32 SpectrumInversion)
{
    return SpectrumInversion & 0x1;
}
static __inline UInt32  S2DEMOD_SpectrumInversion_GET_AutoDetect(UInt32 SpectrumInversion)
{
    return (SpectrumInversion & 0x2) >> 1;
}

// Field SET functions
static __inline UInt32  S2DEMOD_SpectrumInversion_SET_InitialValue(UInt32 SpectrumInversion, UInt32 InitialValue)
{
    DT_ASSERT((InitialValue & ~0x1) == 0);
    return (SpectrumInversion & ~0x1) | InitialValue;
}
static __inline UInt32  S2DEMOD_SpectrumInversion_SET_AutoDetect(UInt32 SpectrumInversion, UInt32 AutoDetect)
{
    DT_ASSERT((AutoDetect & ~0x1) == 0);
    return (SpectrumInversion & ~0x2) | (AutoDetect << 1);
}

// Register WRITE function
static __inline void  S2DEMOD_SpectrumInversion_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 SpectrumInversion)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1020, SpectrumInversion);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'DcOffsetWeightFactor' -.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_DcOffsetWeightFactor_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1024);
}

// Field GET function
static __inline UInt32  S2DEMOD_DcOffsetWeightFactor_GET_WeightFactor(UInt32 DcOffsetWeightFactor)
{
    return DcOffsetWeightFactor & 0x1F;
}

// Field SET function
static __inline UInt32  S2DEMOD_DcOffsetWeightFactor_SET_WeightFactor(UInt32 DcOffsetWeightFactor, UInt32 WeightFactor)
{
    DT_ASSERT((WeightFactor & ~0x1F) == 0);
    return (DcOffsetWeightFactor & ~0x1F) | WeightFactor;
}

// Register WRITE function
static __inline void  S2DEMOD_DcOffsetWeightFactor_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 DcOffsetWeightFactor)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1024, DcOffsetWeightFactor);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'DcOffsetValue' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_DcOffsetValue_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1028);
}

// Field GET functions
static __inline UInt32  S2DEMOD_DcOffsetValue_GET_ImaginaryPart(UInt32 DcOffsetValue)
{
    return DcOffsetValue & 0x3FF;
}
static __inline UInt32  S2DEMOD_DcOffsetValue_GET_RealPart(UInt32 DcOffsetValue)
{
    return (DcOffsetValue & 0x3FF0000) >> 16;
}

// Field READ functions
static __inline UInt32  S2DEMOD_DcOffsetValue_READ_ImaginaryPart(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1028) & 0x3FF;
}
static __inline UInt32  S2DEMOD_DcOffsetValue_READ_RealPart(DtBcS2DEMOD_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x1028) & 0x3FF0000) >> 16;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'IqImbalanceValue' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_IqImbalanceValue_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x102C);
}

// Field GET functions
static __inline UInt32  S2DEMOD_IqImbalanceValue_GET_MagnitudeImbalance(UInt32 IqImbalanceValue)
{
    return IqImbalanceValue & 0xFFF;
}
static __inline UInt32  S2DEMOD_IqImbalanceValue_GET_PhaseImbalance(UInt32 IqImbalanceValue)
{
    return (IqImbalanceValue & 0xFFF0000) >> 16;
}

// Field READ functions
static __inline UInt32  S2DEMOD_IqImbalanceValue_READ_MagnitudeImbalance(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x102C) & 0xFFF;
}
static __inline UInt32  S2DEMOD_IqImbalanceValue_READ_PhaseImbalance(DtBcS2DEMOD_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x102C) & 0xFFF0000) >> 16;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'NdaAgcGainFactor' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_NdaAgcGainFactor_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1030);
}

// Field GET function
static __inline UInt32  S2DEMOD_NdaAgcGainFactor_GET_AgcGain(UInt32 NdaAgcGainFactor)
{
    return NdaAgcGainFactor & 0xFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_NdaAgcGainFactor_READ_AgcGain(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1030) & 0xFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'DecimationRate' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_DecimationRate_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1034) & 0x1FF;
}

// Field WRITE function
static __inline void  S2DEMOD_DecimationRate_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 DecimationRate)
{
    DT_ASSERT((DecimationRate & ~0x1FF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x1034, DecimationRate);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'NdaAgcWindowLength' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_NdaAgcWindowLength_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1038);
}

// Field GET function
static __inline UInt32  S2DEMOD_NdaAgcWindowLength_GET_WindowLength(UInt32 NdaAgcWindowLength)
{
    return NdaAgcWindowLength & 0xFFFF;
}

// Field SET function
static __inline UInt32  S2DEMOD_NdaAgcWindowLength_SET_WindowLength(UInt32 NdaAgcWindowLength, UInt32 WindowLength)
{
    DT_ASSERT((WindowLength & ~0xFFFF) == 0);
    return (NdaAgcWindowLength & ~0xFFFF) | WindowLength;
}

// Register WRITE function
static __inline void  S2DEMOD_NdaAgcWindowLength_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 NdaAgcWindowLength)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1038, NdaAgcWindowLength);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'AntiAlisasingFilter' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_AntiAlisasingFilter_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x103C);
}

// Field GET function
static __inline UInt32  S2DEMOD_AntiAlisasingFilter_GET_FilterSelect(UInt32 AntiAlisasingFilter)
{
    return AntiAlisasingFilter & 0x3;
}

// Field SET function
static __inline UInt32  S2DEMOD_AntiAlisasingFilter_SET_FilterSelect(UInt32 AntiAlisasingFilter, UInt32 FilterSelect)
{
    DT_ASSERT((FilterSelect & ~0x3) == 0);
    return (AntiAlisasingFilter & ~0x3) | FilterSelect;
}

// Register WRITE function
static __inline void  S2DEMOD_AntiAlisasingFilter_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 AntiAlisasingFilter)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x103C, AntiAlisasingFilter);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'PlInformation' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_PlInformation_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1040);
}

// Field GET functions
static __inline UInt32  S2DEMOD_PlInformation_GET_PlsValue(UInt32 PlInformation)
{
    return PlInformation & 0xFF;
}
static __inline UInt32  S2DEMOD_PlInformation_GET_Mode(UInt32 PlInformation)
{
    return (PlInformation & 0x30000) >> 16;
}

// Field SET functions
static __inline UInt32  S2DEMOD_PlInformation_SET_PlsValue(UInt32 PlInformation, UInt32 PlsValue)
{
    DT_ASSERT((PlsValue & ~0xFF) == 0);
    return (PlInformation & ~0xFF) | PlsValue;
}
static __inline UInt32  S2DEMOD_PlInformation_SET_Mode(UInt32 PlInformation, UInt32 Mode)
{
    DT_ASSERT((Mode & ~0x3) == 0);
    return (PlInformation & ~0x30000) | (Mode << 16);
}

// Register WRITE function
static __inline void  S2DEMOD_PlInformation_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 PlInformation)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1040, PlInformation);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'ScramblerStartSeq' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_ScramblerStartSeq_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1044);
}

// Field GET function
static __inline UInt32  S2DEMOD_ScramblerStartSeq_GET_ScramblerSequence(UInt32 ScramblerStartSeq)
{
    return ScramblerStartSeq & 0x3FFFF;
}

// Field SET function
static __inline UInt32  S2DEMOD_ScramblerStartSeq_SET_ScramblerSequence(UInt32 ScramblerStartSeq, UInt32 ScramblerSequence)
{
    DT_ASSERT((ScramblerSequence & ~0x3FFFF) == 0);
    return (ScramblerStartSeq & ~0x3FFFF) | ScramblerSequence;
}

// Register WRITE function
static __inline void  S2DEMOD_ScramblerStartSeq_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 ScramblerStartSeq)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1044, ScramblerStartSeq);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'InitSymbRateRatio' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_InitSymbRateRatio_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1048);
}

// Field GET function
static __inline UInt32  S2DEMOD_InitSymbRateRatio_GET_InitSymbolRateRatio(UInt32 InitSymbRateRatio)
{
    return InitSymbRateRatio & 0x7FFFF;
}

// Field SET function
static __inline UInt32  S2DEMOD_InitSymbRateRatio_SET_InitSymbolRateRatio(UInt32 InitSymbRateRatio, UInt32 InitSymbolRateRatio)
{
    DT_ASSERT((InitSymbolRateRatio & ~0x7FFFF) == 0);
    return (InitSymbRateRatio & ~0x7FFFF) | InitSymbolRateRatio;
}

// Register WRITE function
static __inline void  S2DEMOD_InitSymbRateRatio_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 InitSymbRateRatio)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1048, InitSymbRateRatio);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'MeasSymbRateRatio' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_MeasSymbRateRatio_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x104C);
}

// Field GET function
static __inline UInt32  S2DEMOD_MeasSymbRateRatio_GET_MeasSymbolRateRatio(UInt32 MeasSymbRateRatio)
{
    return MeasSymbRateRatio & 0x7FFFF;
}

// Field SET function
static __inline UInt32  S2DEMOD_MeasSymbRateRatio_SET_MeasSymbolRateRatio(UInt32 MeasSymbRateRatio, UInt32 MeasSymbolRateRatio)
{
    DT_ASSERT((MeasSymbolRateRatio & ~0x7FFFF) == 0);
    return (MeasSymbRateRatio & ~0x7FFFF) | MeasSymbolRateRatio;
}

// Register WRITE function
static __inline void  S2DEMOD_MeasSymbRateRatio_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 MeasSymbRateRatio)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x104C, MeasSymbRateRatio);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'InitSampleRateRatio' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_InitSampleRateRatio_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1050) & 0x1FFFF;
}

// Field WRITE function
static __inline void  S2DEMOD_InitSampleRateRatio_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 InitSampleRateRatio)
{
    DT_ASSERT((InitSampleRateRatio & ~0x1FFFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x1050, InitSampleRateRatio);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RollOff' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_RollOff_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1054);
}

// Field GET functions
static __inline UInt32  S2DEMOD_RollOff_GET_Factor(UInt32 RollOff)
{
    return RollOff & 0x7;
}
static __inline UInt32  S2DEMOD_RollOff_GET_Direct(UInt32 RollOff)
{
    return (RollOff & 0x100) >> 8;
}

// Field SET functions
static __inline UInt32  S2DEMOD_RollOff_SET_Factor(UInt32 RollOff, UInt32 Factor)
{
    DT_ASSERT((Factor & ~0x7) == 0);
    return (RollOff & ~0x7) | Factor;
}
static __inline UInt32  S2DEMOD_RollOff_SET_Direct(UInt32 RollOff, UInt32 Direct)
{
    DT_ASSERT((Direct & ~0x1) == 0);
    return (RollOff & ~0x100) | (Direct << 8);
}

// Register WRITE function
static __inline void  S2DEMOD_RollOff_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 RollOff)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1054, RollOff);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TimingLoopFiltCoef0' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_TimingLoopFiltCoef0_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1060);
}

// Field GET function
static __inline UInt32  S2DEMOD_TimingLoopFiltCoef0_GET_ACQCoefficientG0(UInt32 TimingLoopFiltCoef0)
{
    return TimingLoopFiltCoef0 & 0x1FFFFFF;
}

// Field SET function
static __inline UInt32  S2DEMOD_TimingLoopFiltCoef0_SET_ACQCoefficientG0(UInt32 TimingLoopFiltCoef0, UInt32 ACQCoefficientG0)
{
    DT_ASSERT((ACQCoefficientG0 & ~0x1FFFFFF) == 0);
    return (TimingLoopFiltCoef0 & ~0x1FFFFFF) | ACQCoefficientG0;
}

// Register WRITE function
static __inline void  S2DEMOD_TimingLoopFiltCoef0_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 TimingLoopFiltCoef0)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1060, TimingLoopFiltCoef0);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TimingLoopFiltCoef1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_TimingLoopFiltCoef1_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1064);
}

// Field GET function
static __inline UInt32  S2DEMOD_TimingLoopFiltCoef1_GET_ACQCoefficientG1(UInt32 TimingLoopFiltCoef1)
{
    return TimingLoopFiltCoef1 & 0x1FFFFFF;
}

// Field SET function
static __inline UInt32  S2DEMOD_TimingLoopFiltCoef1_SET_ACQCoefficientG1(UInt32 TimingLoopFiltCoef1, UInt32 ACQCoefficientG1)
{
    DT_ASSERT((ACQCoefficientG1 & ~0x1FFFFFF) == 0);
    return (TimingLoopFiltCoef1 & ~0x1FFFFFF) | ACQCoefficientG1;
}

// Register WRITE function
static __inline void  S2DEMOD_TimingLoopFiltCoef1_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 TimingLoopFiltCoef1)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1064, TimingLoopFiltCoef1);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TimingLoopFiltCoef2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_TimingLoopFiltCoef2_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1068);
}

// Field GET function
static __inline UInt32  S2DEMOD_TimingLoopFiltCoef2_GET_TRKCoefficientG0(UInt32 TimingLoopFiltCoef2)
{
    return TimingLoopFiltCoef2 & 0x1FFFFFF;
}

// Field SET function
static __inline UInt32  S2DEMOD_TimingLoopFiltCoef2_SET_TRKCoefficientG0(UInt32 TimingLoopFiltCoef2, UInt32 TRKCoefficientG0)
{
    DT_ASSERT((TRKCoefficientG0 & ~0x1FFFFFF) == 0);
    return (TimingLoopFiltCoef2 & ~0x1FFFFFF) | TRKCoefficientG0;
}

// Register WRITE function
static __inline void  S2DEMOD_TimingLoopFiltCoef2_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 TimingLoopFiltCoef2)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1068, TimingLoopFiltCoef2);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TimingLoopFiltCoef3' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_TimingLoopFiltCoef3_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x106C);
}

// Field GET function
static __inline UInt32  S2DEMOD_TimingLoopFiltCoef3_GET_TRKCoefficientG1(UInt32 TimingLoopFiltCoef3)
{
    return TimingLoopFiltCoef3 & 0x1FFFFFF;
}

// Field SET function
static __inline UInt32  S2DEMOD_TimingLoopFiltCoef3_SET_TRKCoefficientG1(UInt32 TimingLoopFiltCoef3, UInt32 TRKCoefficientG1)
{
    DT_ASSERT((TRKCoefficientG1 & ~0x1FFFFFF) == 0);
    return (TimingLoopFiltCoef3 & ~0x1FFFFFF) | TRKCoefficientG1;
}

// Register WRITE function
static __inline void  S2DEMOD_TimingLoopFiltCoef3_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 TimingLoopFiltCoef3)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x106C, TimingLoopFiltCoef3);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'DetPlsValue' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_DetPlsValue_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1070);
}

// Field GET function
static __inline UInt32  S2DEMOD_DetPlsValue_GET_PlsValue(UInt32 DetPlsValue)
{
    return DetPlsValue & 0xFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_DetPlsValue_READ_PlsValue(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1070) & 0xFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'DetSpectrumInversion' -.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_DetSpectrumInversion_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1074);
}

// Field GET function
static __inline UInt32  S2DEMOD_DetSpectrumInversion_GET_SpectrumInversion(UInt32 DetSpectrumInversion)
{
    return DetSpectrumInversion & 0x1;
}

// Field READ function
static __inline UInt32  S2DEMOD_DetSpectrumInversion_READ_SpectrumInversion(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1074) & 0x1;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FreqOffset' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_FreqOffset_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1080) & 0xFFFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FreqLoopFilterCoef0' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FreqLoopFilterCoef0_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1084);
}

// Field GET function
static __inline UInt32  S2DEMOD_FreqLoopFilterCoef0_GET_ACQCoefficientK1(UInt32 FreqLoopFilterCoef0)
{
    return FreqLoopFilterCoef0 & 0x1FFFFFF;
}

// Field SET function
static __inline UInt32  S2DEMOD_FreqLoopFilterCoef0_SET_ACQCoefficientK1(UInt32 FreqLoopFilterCoef0, UInt32 ACQCoefficientK1)
{
    DT_ASSERT((ACQCoefficientK1 & ~0x1FFFFFF) == 0);
    return (FreqLoopFilterCoef0 & ~0x1FFFFFF) | ACQCoefficientK1;
}

// Register WRITE function
static __inline void  S2DEMOD_FreqLoopFilterCoef0_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 FreqLoopFilterCoef0)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1084, FreqLoopFilterCoef0);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FreqLoopFilterCoef1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_FreqLoopFilterCoef1_READ_ACQCoefficientK2(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1088);
}

// Field WRITE function
static __inline void  S2DEMOD_FreqLoopFilterCoef1_WRITE_ACQCoefficientK2(DtBcS2DEMOD_2132* pBc, UInt32 ACQCoefficientK2)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1088, ACQCoefficientK2);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FreqLoopFilterCoef2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FreqLoopFilterCoef2_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x108C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FreqLoopFilterCoef2_GET_TRKCoefficientK1(UInt32 FreqLoopFilterCoef2)
{
    return FreqLoopFilterCoef2 & 0x1FFFFFF;
}

// Field SET function
static __inline UInt32  S2DEMOD_FreqLoopFilterCoef2_SET_TRKCoefficientK1(UInt32 FreqLoopFilterCoef2, UInt32 TRKCoefficientK1)
{
    DT_ASSERT((TRKCoefficientK1 & ~0x1FFFFFF) == 0);
    return (FreqLoopFilterCoef2 & ~0x1FFFFFF) | TRKCoefficientK1;
}

// Register WRITE function
static __inline void  S2DEMOD_FreqLoopFilterCoef2_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 FreqLoopFilterCoef2)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x108C, FreqLoopFilterCoef2);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FreqLoopFilterCoef3' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_FreqLoopFilterCoef3_READ_TRKCoefficientK2(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1090);
}

// Field WRITE function
static __inline void  S2DEMOD_FreqLoopFilterCoef3_WRITE_TRKCoefficientK2(DtBcS2DEMOD_2132* pBc, UInt32 TRKCoefficientK2)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1090, TRKCoefficientK2);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Undocumented94' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_Undocumented94_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1094);
}

// Field WRITE function
static __inline void  S2DEMOD_Undocumented94_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 Undocumented94)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1094, Undocumented94);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FineFreqOffset' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FineFreqOffset_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10A0);
}

// Field GET function
static __inline UInt32  S2DEMOD_FineFreqOffset_GET_FreqOffset(UInt32 FineFreqOffset)
{
    return FineFreqOffset & 0xFFFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FineFreqOffset_READ_FreqOffset(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10A0) & 0xFFFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FineFreqWindowLength' -.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  S2DEMOD_FineFreqWindowLength_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10A4) & 0x3FFF;
}

// Field WRITE function
static __inline void  S2DEMOD_FineFreqWindowLength_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 FineFreqWindowLength)
{
    DT_ASSERT((FineFreqWindowLength & ~0x3FFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x10A4, FineFreqWindowLength);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'CoarsePhaseIncrement' -.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  S2DEMOD_CoarsePhaseIncrement_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10B0);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FinePhaseOffset' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_FinePhaseOffset_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10B4) & 0xFFFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Equalizer' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_Equalizer_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10B8);
}

// Field GET functions
static __inline UInt32  S2DEMOD_Equalizer_GET_StepSize(UInt32 Equalizer)
{
    return Equalizer & 0x3;
}
static __inline UInt32  S2DEMOD_Equalizer_GET_Mode(UInt32 Equalizer)
{
    return (Equalizer & 0x4) >> 2;
}

// Field SET functions
static __inline UInt32  S2DEMOD_Equalizer_SET_StepSize(UInt32 Equalizer, UInt32 StepSize)
{
    DT_ASSERT((StepSize & ~0x3) == 0);
    return (Equalizer & ~0x3) | StepSize;
}
static __inline UInt32  S2DEMOD_Equalizer_SET_Mode(UInt32 Equalizer, UInt32 Mode)
{
    DT_ASSERT((Mode & ~0x1) == 0);
    return (Equalizer & ~0x4) | (Mode << 2);
}

// Register WRITE function
static __inline void  S2DEMOD_Equalizer_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 Equalizer)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10B8, Equalizer);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SnrEstimatorFrames' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_SnrEstimatorFrames_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10C0);
}

// Field GET function
static __inline UInt32  S2DEMOD_SnrEstimatorFrames_GET_SnrFrames(UInt32 SnrEstimatorFrames)
{
    return SnrEstimatorFrames & 0x3;
}

// Field SET function
static __inline UInt32  S2DEMOD_SnrEstimatorFrames_SET_SnrFrames(UInt32 SnrEstimatorFrames, UInt32 SnrFrames)
{
    DT_ASSERT((SnrFrames & ~0x3) == 0);
    return (SnrEstimatorFrames & ~0x3) | SnrFrames;
}

// Register WRITE function
static __inline void  S2DEMOD_SnrEstimatorFrames_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 SnrEstimatorFrames)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10C0, SnrEstimatorFrames);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'DaAgcCorrGainFactor' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_DaAgcCorrGainFactor_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10C4);
}

// Field GET function
static __inline UInt32  S2DEMOD_DaAgcCorrGainFactor_GET_DaAgcGainFactor(UInt32 DaAgcCorrGainFactor)
{
    return DaAgcCorrGainFactor & 0xFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_DaAgcCorrGainFactor_READ_DaAgcGainFactor(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10C4) & 0xFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SnrEstimSignalPower' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_SnrEstimSignalPower_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10C8);
}

// Field GET function
static __inline UInt32  S2DEMOD_SnrEstimSignalPower_GET_SignalPower(UInt32 SnrEstimSignalPower)
{
    return SnrEstimSignalPower & 0x3FF;
}

// Field READ function
static __inline UInt32  S2DEMOD_SnrEstimSignalPower_READ_SignalPower(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10C8) & 0x3FF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SnrEstimErrorPower' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_SnrEstimErrorPower_READ_ErrorPower(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10CC);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'UndocumentedD0' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_UndocumentedD0_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10D0);
}

// Field WRITE function
static __inline void  S2DEMOD_UndocumentedD0_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 UndocumentedD0)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10D0, UndocumentedD0);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'UndocumentedD4' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_UndocumentedD4_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10D4);
}

// Field WRITE function
static __inline void  S2DEMOD_UndocumentedD4_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 UndocumentedD4)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10D4, UndocumentedD4);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'UndocumentedD8' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_UndocumentedD8_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10D8);
}

// Field WRITE function
static __inline void  S2DEMOD_UndocumentedD8_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 UndocumentedD8)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10D8, UndocumentedD8);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'UndocumentedDC' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_UndocumentedDC_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10DC);
}

// Field WRITE function
static __inline void  S2DEMOD_UndocumentedDC_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 UndocumentedDC)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10DC, UndocumentedDC);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'UndocumentedE0' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_UndocumentedE0_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10E0);
}

// Field WRITE function
static __inline void  S2DEMOD_UndocumentedE0_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 UndocumentedE0)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10E0, UndocumentedE0);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'UndocumentedE4' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_UndocumentedE4_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10E4);
}

// Field WRITE function
static __inline void  S2DEMOD_UndocumentedE4_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 UndocumentedE4)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10E4, UndocumentedE4);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'UndocumentedE8' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_UndocumentedE8_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10E8);
}

// Field WRITE function
static __inline void  S2DEMOD_UndocumentedE8_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 UndocumentedE8)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10E8, UndocumentedE8);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'UndocumentedEC' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_UndocumentedEC_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10EC);
}

// Field WRITE function
static __inline void  S2DEMOD_UndocumentedEC_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 UndocumentedEC)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10EC, UndocumentedEC);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'UndocumentedF0' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEMOD_UndocumentedF0_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10F0);
}

// Field WRITE function
static __inline void  S2DEMOD_UndocumentedF0_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 UndocumentedF0)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10F0, UndocumentedF0);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Trigger' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_Trigger_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10FC);
}

// Field GET functions
static __inline UInt32  S2DEMOD_Trigger_GET_Spectrum(UInt32 Trigger)
{
    return Trigger & 0x1;
}
static __inline UInt32  S2DEMOD_Trigger_GET_Equalizer(UInt32 Trigger)
{
    return (Trigger & 0x2) >> 1;
}

// Field SET functions
static __inline UInt32  S2DEMOD_Trigger_SET_Spectrum(UInt32 Trigger, UInt32 Spectrum)
{
    DT_ASSERT((Spectrum & ~0x1) == 0);
    return (Trigger & ~0x1) | Spectrum;
}
static __inline UInt32  S2DEMOD_Trigger_SET_Equalizer(UInt32 Trigger, UInt32 Equalizer)
{
    DT_ASSERT((Equalizer & ~0x1) == 0);
    return (Trigger & ~0x2) | (Equalizer << 1);
}

// Register WRITE function
static __inline void  S2DEMOD_Trigger_WRITE(DtBcS2DEMOD_2132* pBc, UInt32 Trigger)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10FC, Trigger);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EqualizerTap6' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_EqualizerTap6_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1100);
}

// Field GET functions
static __inline UInt32  S2DEMOD_EqualizerTap6_GET_RealPart(UInt32 EqualizerTap6)
{
    return EqualizerTap6 & 0xFFF;
}
static __inline UInt32  S2DEMOD_EqualizerTap6_GET_ImaginaryPart(UInt32 EqualizerTap6)
{
    return (EqualizerTap6 & 0xFFF000) >> 12;
}

// Field READ functions
static __inline UInt32  S2DEMOD_EqualizerTap6_READ_RealPart(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1100) & 0xFFF;
}
static __inline UInt32  S2DEMOD_EqualizerTap6_READ_ImaginaryPart(DtBcS2DEMOD_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x1100) & 0xFFF000) >> 12;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EqualizerTap5' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_EqualizerTap5_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1104);
}

// Field GET functions
static __inline UInt32  S2DEMOD_EqualizerTap5_GET_RealPart(UInt32 EqualizerTap5)
{
    return EqualizerTap5 & 0xFFF;
}
static __inline UInt32  S2DEMOD_EqualizerTap5_GET_ImaginaryPart(UInt32 EqualizerTap5)
{
    return (EqualizerTap5 & 0xFFF000) >> 12;
}

// Field READ functions
static __inline UInt32  S2DEMOD_EqualizerTap5_READ_RealPart(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1104) & 0xFFF;
}
static __inline UInt32  S2DEMOD_EqualizerTap5_READ_ImaginaryPart(DtBcS2DEMOD_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x1104) & 0xFFF000) >> 12;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EqualizerTap4' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_EqualizerTap4_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1108);
}

// Field GET functions
static __inline UInt32  S2DEMOD_EqualizerTap4_GET_RealPart(UInt32 EqualizerTap4)
{
    return EqualizerTap4 & 0xFFF;
}
static __inline UInt32  S2DEMOD_EqualizerTap4_GET_ImaginaryPart(UInt32 EqualizerTap4)
{
    return (EqualizerTap4 & 0xFFF000) >> 12;
}

// Field READ functions
static __inline UInt32  S2DEMOD_EqualizerTap4_READ_RealPart(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1108) & 0xFFF;
}
static __inline UInt32  S2DEMOD_EqualizerTap4_READ_ImaginaryPart(DtBcS2DEMOD_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x1108) & 0xFFF000) >> 12;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EqualizerTap3' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_EqualizerTap3_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x110C);
}

// Field GET functions
static __inline UInt32  S2DEMOD_EqualizerTap3_GET_RealPart(UInt32 EqualizerTap3)
{
    return EqualizerTap3 & 0xFFF;
}
static __inline UInt32  S2DEMOD_EqualizerTap3_GET_ImaginaryPart(UInt32 EqualizerTap3)
{
    return (EqualizerTap3 & 0xFFF000) >> 12;
}

// Field READ functions
static __inline UInt32  S2DEMOD_EqualizerTap3_READ_RealPart(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x110C) & 0xFFF;
}
static __inline UInt32  S2DEMOD_EqualizerTap3_READ_ImaginaryPart(DtBcS2DEMOD_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x110C) & 0xFFF000) >> 12;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EqualizerTap2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_EqualizerTap2_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1110);
}

// Field GET functions
static __inline UInt32  S2DEMOD_EqualizerTap2_GET_RealPart(UInt32 EqualizerTap2)
{
    return EqualizerTap2 & 0xFFF;
}
static __inline UInt32  S2DEMOD_EqualizerTap2_GET_ImaginaryPart(UInt32 EqualizerTap2)
{
    return (EqualizerTap2 & 0xFFF000) >> 12;
}

// Field READ functions
static __inline UInt32  S2DEMOD_EqualizerTap2_READ_RealPart(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1110) & 0xFFF;
}
static __inline UInt32  S2DEMOD_EqualizerTap2_READ_ImaginaryPart(DtBcS2DEMOD_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x1110) & 0xFFF000) >> 12;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EqualizerTap1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_EqualizerTap1_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1114);
}

// Field GET functions
static __inline UInt32  S2DEMOD_EqualizerTap1_GET_RealPart(UInt32 EqualizerTap1)
{
    return EqualizerTap1 & 0xFFF;
}
static __inline UInt32  S2DEMOD_EqualizerTap1_GET_ImaginaryPart(UInt32 EqualizerTap1)
{
    return (EqualizerTap1 & 0xFFF000) >> 12;
}

// Field READ functions
static __inline UInt32  S2DEMOD_EqualizerTap1_READ_RealPart(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1114) & 0xFFF;
}
static __inline UInt32  S2DEMOD_EqualizerTap1_READ_ImaginaryPart(DtBcS2DEMOD_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x1114) & 0xFFF000) >> 12;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'EqualizerTap0' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_EqualizerTap0_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1118);
}

// Field GET functions
static __inline UInt32  S2DEMOD_EqualizerTap0_GET_RealPart(UInt32 EqualizerTap0)
{
    return EqualizerTap0 & 0xFFF;
}
static __inline UInt32  S2DEMOD_EqualizerTap0_GET_ImaginaryPart(UInt32 EqualizerTap0)
{
    return (EqualizerTap0 & 0xFFF000) >> 12;
}

// Field READ functions
static __inline UInt32  S2DEMOD_EqualizerTap0_READ_RealPart(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1118) & 0xFFF;
}
static __inline UInt32  S2DEMOD_EqualizerTap0_READ_ImaginaryPart(DtBcS2DEMOD_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x1118) & 0xFFF000) >> 12;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum0' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum0_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1200);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum0_GET_AbsValueSquareBin0(UInt32 FftSpectrum0)
{
    return FftSpectrum0 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum0_READ_AbsValueSquareBin0(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1200) & 0x1FFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum1_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1204);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum1_GET_AbsValueSquareBin1(UInt32 FftSpectrum1)
{
    return FftSpectrum1 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum1_READ_AbsValueSquareBin1(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1204) & 0x1FFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum2_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1208);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum2_GET_AbsValueSquareBin2(UInt32 FftSpectrum2)
{
    return FftSpectrum2 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum2_READ_AbsValueSquareBin2(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1208) & 0x1FFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum3' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum3_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x120C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum3_GET_AbsValueSquareBin3(UInt32 FftSpectrum3)
{
    return FftSpectrum3 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum3_READ_AbsValueSquareBin3(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x120C) & 0x1FFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum4' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum4_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1210);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum4_GET_AbsValueSquareBin4(UInt32 FftSpectrum4)
{
    return FftSpectrum4 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum4_READ_AbsValueSquareBin4(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1210) & 0x1FFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum5' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum5_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1214);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum5_GET_AbsValueSquareBin5(UInt32 FftSpectrum5)
{
    return FftSpectrum5 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum5_READ_AbsValueSquareBin5(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1214) & 0x1FFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum6' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum6_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1218);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum6_GET_AbsValueSquareBin6(UInt32 FftSpectrum6)
{
    return FftSpectrum6 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum6_READ_AbsValueSquareBin6(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1218) & 0x1FFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum7' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum7_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x121C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum7_GET_AbsValueSquareBin7(UInt32 FftSpectrum7)
{
    return FftSpectrum7 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum7_READ_AbsValueSquareBin7(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x121C) & 0x1FFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum8' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum8_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1220);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum8_GET_AbsValueSquareBin8(UInt32 FftSpectrum8)
{
    return FftSpectrum8 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum8_READ_AbsValueSquareBin8(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1220) & 0x1FFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum9' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum9_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1224);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum9_GET_AbsValueSquareBin9(UInt32 FftSpectrum9)
{
    return FftSpectrum9 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum9_READ_AbsValueSquareBin9(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1224) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum10' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum10_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1228);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum10_GET_AbsValueSquareBin10(UInt32 FftSpectrum10)
{
    return FftSpectrum10 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum10_READ_AbsValueSquareBin10(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1228) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum11' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum11_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x122C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum11_GET_AbsValueSquareBin11(UInt32 FftSpectrum11)
{
    return FftSpectrum11 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum11_READ_AbsValueSquareBin11(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x122C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum12' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum12_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1230);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum12_GET_AbsValueSquareBin12(UInt32 FftSpectrum12)
{
    return FftSpectrum12 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum12_READ_AbsValueSquareBin12(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1230) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum13' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum13_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1234);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum13_GET_AbsValueSquareBin13(UInt32 FftSpectrum13)
{
    return FftSpectrum13 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum13_READ_AbsValueSquareBin13(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1234) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum14' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum14_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1238);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum14_GET_AbsValueSquareBin14(UInt32 FftSpectrum14)
{
    return FftSpectrum14 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum14_READ_AbsValueSquareBin14(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1238) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum15' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum15_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x123C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum15_GET_AbsValueSquareBin15(UInt32 FftSpectrum15)
{
    return FftSpectrum15 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum15_READ_AbsValueSquareBin15(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x123C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum16' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum16_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1240);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum16_GET_AbsValueSquareBin16(UInt32 FftSpectrum16)
{
    return FftSpectrum16 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum16_READ_AbsValueSquareBin16(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1240) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum17' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum17_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1244);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum17_GET_AbsValueSquareBin17(UInt32 FftSpectrum17)
{
    return FftSpectrum17 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum17_READ_AbsValueSquareBin17(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1244) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum18' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum18_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1248);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum18_GET_AbsValueSquareBin18(UInt32 FftSpectrum18)
{
    return FftSpectrum18 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum18_READ_AbsValueSquareBin18(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1248) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum19' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum19_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x124C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum19_GET_AbsValueSquareBin19(UInt32 FftSpectrum19)
{
    return FftSpectrum19 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum19_READ_AbsValueSquareBin19(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x124C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum20' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum20_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1250);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum20_GET_AbsValueSquareBin20(UInt32 FftSpectrum20)
{
    return FftSpectrum20 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum20_READ_AbsValueSquareBin20(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1250) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum21' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum21_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1254);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum21_GET_AbsValueSquareBin21(UInt32 FftSpectrum21)
{
    return FftSpectrum21 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum21_READ_AbsValueSquareBin21(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1254) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum22' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum22_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1258);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum22_GET_AbsValueSquareBin22(UInt32 FftSpectrum22)
{
    return FftSpectrum22 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum22_READ_AbsValueSquareBin22(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1258) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum23' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum23_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x125C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum23_GET_AbsValueSquareBin23(UInt32 FftSpectrum23)
{
    return FftSpectrum23 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum23_READ_AbsValueSquareBin23(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x125C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum24' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum24_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1260);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum24_GET_AbsValueSquareBin24(UInt32 FftSpectrum24)
{
    return FftSpectrum24 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum24_READ_AbsValueSquareBin24(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1260) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum25' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum25_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1264);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum25_GET_AbsValueSquareBin25(UInt32 FftSpectrum25)
{
    return FftSpectrum25 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum25_READ_AbsValueSquareBin25(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1264) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum26' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum26_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1268);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum26_GET_AbsValueSquareBin26(UInt32 FftSpectrum26)
{
    return FftSpectrum26 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum26_READ_AbsValueSquareBin26(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1268) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum27' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum27_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x126C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum27_GET_AbsValueSquareBin27(UInt32 FftSpectrum27)
{
    return FftSpectrum27 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum27_READ_AbsValueSquareBin27(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x126C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum28' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum28_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1270);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum28_GET_AbsValueSquareBin28(UInt32 FftSpectrum28)
{
    return FftSpectrum28 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum28_READ_AbsValueSquareBin28(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1270) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum29' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum29_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1274);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum29_GET_AbsValueSquareBin29(UInt32 FftSpectrum29)
{
    return FftSpectrum29 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum29_READ_AbsValueSquareBin29(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1274) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum30' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum30_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1278);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum30_GET_AbsValueSquareBin30(UInt32 FftSpectrum30)
{
    return FftSpectrum30 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum30_READ_AbsValueSquareBin30(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1278) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum31' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum31_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x127C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum31_GET_AbsValueSquareBin31(UInt32 FftSpectrum31)
{
    return FftSpectrum31 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum31_READ_AbsValueSquareBin31(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x127C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum32' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum32_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1280);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum32_GET_AbsValueSquareBin32(UInt32 FftSpectrum32)
{
    return FftSpectrum32 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum32_READ_AbsValueSquareBin32(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1280) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum33' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum33_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1284);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum33_GET_AbsValueSquareBin33(UInt32 FftSpectrum33)
{
    return FftSpectrum33 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum33_READ_AbsValueSquareBin33(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1284) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum34' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum34_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1288);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum34_GET_AbsValueSquareBin34(UInt32 FftSpectrum34)
{
    return FftSpectrum34 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum34_READ_AbsValueSquareBin34(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1288) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum35' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum35_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x128C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum35_GET_AbsValueSquareBin35(UInt32 FftSpectrum35)
{
    return FftSpectrum35 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum35_READ_AbsValueSquareBin35(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x128C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum36' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum36_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1290);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum36_GET_AbsValueSquareBin36(UInt32 FftSpectrum36)
{
    return FftSpectrum36 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum36_READ_AbsValueSquareBin36(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1290) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum37' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum37_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1294);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum37_GET_AbsValueSquareBin37(UInt32 FftSpectrum37)
{
    return FftSpectrum37 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum37_READ_AbsValueSquareBin37(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1294) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum38' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum38_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1298);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum38_GET_AbsValueSquareBin38(UInt32 FftSpectrum38)
{
    return FftSpectrum38 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum38_READ_AbsValueSquareBin38(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1298) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum39' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum39_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x129C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum39_GET_AbsValueSquareBin39(UInt32 FftSpectrum39)
{
    return FftSpectrum39 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum39_READ_AbsValueSquareBin39(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x129C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum40' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum40_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12A0);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum40_GET_AbsValueSquareBin40(UInt32 FftSpectrum40)
{
    return FftSpectrum40 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum40_READ_AbsValueSquareBin40(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12A0) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum41' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum41_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12A4);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum41_GET_AbsValueSquareBin41(UInt32 FftSpectrum41)
{
    return FftSpectrum41 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum41_READ_AbsValueSquareBin41(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12A4) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum42' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum42_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12A8);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum42_GET_AbsValueSquareBin42(UInt32 FftSpectrum42)
{
    return FftSpectrum42 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum42_READ_AbsValueSquareBin42(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12A8) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum43' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum43_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12AC);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum43_GET_AbsValueSquareBin43(UInt32 FftSpectrum43)
{
    return FftSpectrum43 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum43_READ_AbsValueSquareBin43(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12AC) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum44' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum44_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12B0);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum44_GET_AbsValueSquareBin44(UInt32 FftSpectrum44)
{
    return FftSpectrum44 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum44_READ_AbsValueSquareBin44(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12B0) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum45' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum45_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12B4);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum45_GET_AbsValueSquareBin45(UInt32 FftSpectrum45)
{
    return FftSpectrum45 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum45_READ_AbsValueSquareBin45(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12B4) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum46' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum46_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12B8);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum46_GET_AbsValueSquareBin46(UInt32 FftSpectrum46)
{
    return FftSpectrum46 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum46_READ_AbsValueSquareBin46(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12B8) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum47' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum47_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12BC);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum47_GET_AbsValueSquareBin47(UInt32 FftSpectrum47)
{
    return FftSpectrum47 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum47_READ_AbsValueSquareBin47(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12BC) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum48' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum48_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12C0);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum48_GET_AbsValueSquareBin48(UInt32 FftSpectrum48)
{
    return FftSpectrum48 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum48_READ_AbsValueSquareBin48(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12C0) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum49' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum49_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12C4);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum49_GET_AbsValueSquareBin49(UInt32 FftSpectrum49)
{
    return FftSpectrum49 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum49_READ_AbsValueSquareBin49(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12C4) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum50' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum50_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12C8);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum50_GET_AbsValueSquareBin50(UInt32 FftSpectrum50)
{
    return FftSpectrum50 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum50_READ_AbsValueSquareBin50(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12C8) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum51' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum51_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12CC);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum51_GET_AbsValueSquareBin51(UInt32 FftSpectrum51)
{
    return FftSpectrum51 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum51_READ_AbsValueSquareBin51(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12CC) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum52' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum52_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12D0);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum52_GET_AbsValueSquareBin52(UInt32 FftSpectrum52)
{
    return FftSpectrum52 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum52_READ_AbsValueSquareBin52(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12D0) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum53' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum53_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12D4);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum53_GET_AbsValueSquareBin53(UInt32 FftSpectrum53)
{
    return FftSpectrum53 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum53_READ_AbsValueSquareBin53(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12D4) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum54' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum54_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12D8);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum54_GET_AbsValueSquareBin54(UInt32 FftSpectrum54)
{
    return FftSpectrum54 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum54_READ_AbsValueSquareBin54(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12D8) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum55' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum55_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12DC);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum55_GET_AbsValueSquareBin55(UInt32 FftSpectrum55)
{
    return FftSpectrum55 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum55_READ_AbsValueSquareBin55(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12DC) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum56' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum56_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12E0);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum56_GET_AbsValueSquareBin56(UInt32 FftSpectrum56)
{
    return FftSpectrum56 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum56_READ_AbsValueSquareBin56(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12E0) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum57' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum57_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12E4);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum57_GET_AbsValueSquareBin57(UInt32 FftSpectrum57)
{
    return FftSpectrum57 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum57_READ_AbsValueSquareBin57(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12E4) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum58' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum58_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12E8);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum58_GET_AbsValueSquareBin58(UInt32 FftSpectrum58)
{
    return FftSpectrum58 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum58_READ_AbsValueSquareBin58(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12E8) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum59' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum59_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12EC);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum59_GET_AbsValueSquareBin59(UInt32 FftSpectrum59)
{
    return FftSpectrum59 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum59_READ_AbsValueSquareBin59(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12EC) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum60' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum60_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12F0);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum60_GET_AbsValueSquareBin60(UInt32 FftSpectrum60)
{
    return FftSpectrum60 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum60_READ_AbsValueSquareBin60(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12F0) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum61' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum61_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12F4);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum61_GET_AbsValueSquareBin61(UInt32 FftSpectrum61)
{
    return FftSpectrum61 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum61_READ_AbsValueSquareBin61(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12F4) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum62' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum62_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12F8);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum62_GET_AbsValueSquareBin62(UInt32 FftSpectrum62)
{
    return FftSpectrum62 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum62_READ_AbsValueSquareBin62(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12F8) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum63' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum63_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12FC);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum63_GET_AbsValueSquareBin63(UInt32 FftSpectrum63)
{
    return FftSpectrum63 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum63_READ_AbsValueSquareBin63(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12FC) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum64' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum64_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1300);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum64_GET_AbsValueSquareBin64(UInt32 FftSpectrum64)
{
    return FftSpectrum64 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum64_READ_AbsValueSquareBin64(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1300) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum65' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum65_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1304);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum65_GET_AbsValueSquareBin65(UInt32 FftSpectrum65)
{
    return FftSpectrum65 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum65_READ_AbsValueSquareBin65(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1304) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum66' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum66_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1308);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum66_GET_AbsValueSquareBin66(UInt32 FftSpectrum66)
{
    return FftSpectrum66 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum66_READ_AbsValueSquareBin66(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1308) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum67' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum67_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x130C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum67_GET_AbsValueSquareBin67(UInt32 FftSpectrum67)
{
    return FftSpectrum67 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum67_READ_AbsValueSquareBin67(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x130C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum68' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum68_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1310);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum68_GET_AbsValueSquareBin68(UInt32 FftSpectrum68)
{
    return FftSpectrum68 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum68_READ_AbsValueSquareBin68(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1310) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum69' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum69_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1314);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum69_GET_AbsValueSquareBin69(UInt32 FftSpectrum69)
{
    return FftSpectrum69 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum69_READ_AbsValueSquareBin69(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1314) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum70' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum70_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1318);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum70_GET_AbsValueSquareBin70(UInt32 FftSpectrum70)
{
    return FftSpectrum70 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum70_READ_AbsValueSquareBin70(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1318) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum71' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum71_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x131C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum71_GET_AbsValueSquareBin71(UInt32 FftSpectrum71)
{
    return FftSpectrum71 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum71_READ_AbsValueSquareBin71(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x131C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum72' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum72_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1320);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum72_GET_AbsValueSquareBin72(UInt32 FftSpectrum72)
{
    return FftSpectrum72 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum72_READ_AbsValueSquareBin72(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1320) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum73' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum73_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1324);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum73_GET_AbsValueSquareBin73(UInt32 FftSpectrum73)
{
    return FftSpectrum73 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum73_READ_AbsValueSquareBin73(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1324) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum74' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum74_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1328);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum74_GET_AbsValueSquareBin74(UInt32 FftSpectrum74)
{
    return FftSpectrum74 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum74_READ_AbsValueSquareBin74(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1328) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum75' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum75_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x132C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum75_GET_AbsValueSquareBin75(UInt32 FftSpectrum75)
{
    return FftSpectrum75 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum75_READ_AbsValueSquareBin75(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x132C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum76' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum76_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1330);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum76_GET_AbsValueSquareBin76(UInt32 FftSpectrum76)
{
    return FftSpectrum76 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum76_READ_AbsValueSquareBin76(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1330) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum77' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum77_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1334);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum77_GET_AbsValueSquareBin77(UInt32 FftSpectrum77)
{
    return FftSpectrum77 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum77_READ_AbsValueSquareBin77(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1334) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum78' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum78_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1338);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum78_GET_AbsValueSquareBin78(UInt32 FftSpectrum78)
{
    return FftSpectrum78 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum78_READ_AbsValueSquareBin78(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1338) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum79' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum79_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x133C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum79_GET_AbsValueSquareBin79(UInt32 FftSpectrum79)
{
    return FftSpectrum79 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum79_READ_AbsValueSquareBin79(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x133C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum80' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum80_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1340);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum80_GET_AbsValueSquareBin80(UInt32 FftSpectrum80)
{
    return FftSpectrum80 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum80_READ_AbsValueSquareBin80(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1340) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum81' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum81_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1344);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum81_GET_AbsValueSquareBin81(UInt32 FftSpectrum81)
{
    return FftSpectrum81 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum81_READ_AbsValueSquareBin81(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1344) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum82' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum82_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1348);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum82_GET_AbsValueSquareBin82(UInt32 FftSpectrum82)
{
    return FftSpectrum82 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum82_READ_AbsValueSquareBin82(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1348) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum83' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum83_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x134C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum83_GET_AbsValueSquareBin83(UInt32 FftSpectrum83)
{
    return FftSpectrum83 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum83_READ_AbsValueSquareBin83(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x134C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum84' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum84_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1350);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum84_GET_AbsValueSquareBin84(UInt32 FftSpectrum84)
{
    return FftSpectrum84 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum84_READ_AbsValueSquareBin84(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1350) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum85' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum85_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1354);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum85_GET_AbsValueSquareBin85(UInt32 FftSpectrum85)
{
    return FftSpectrum85 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum85_READ_AbsValueSquareBin85(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1354) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum86' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum86_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1358);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum86_GET_AbsValueSquareBin86(UInt32 FftSpectrum86)
{
    return FftSpectrum86 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum86_READ_AbsValueSquareBin86(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1358) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum87' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum87_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x135C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum87_GET_AbsValueSquareBin87(UInt32 FftSpectrum87)
{
    return FftSpectrum87 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum87_READ_AbsValueSquareBin87(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x135C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum88' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum88_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1360);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum88_GET_AbsValueSquareBin88(UInt32 FftSpectrum88)
{
    return FftSpectrum88 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum88_READ_AbsValueSquareBin88(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1360) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum89' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum89_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1364);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum89_GET_AbsValueSquareBin89(UInt32 FftSpectrum89)
{
    return FftSpectrum89 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum89_READ_AbsValueSquareBin89(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1364) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum90' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum90_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1368);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum90_GET_AbsValueSquareBin90(UInt32 FftSpectrum90)
{
    return FftSpectrum90 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum90_READ_AbsValueSquareBin90(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1368) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum91' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum91_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x136C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum91_GET_AbsValueSquareBin91(UInt32 FftSpectrum91)
{
    return FftSpectrum91 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum91_READ_AbsValueSquareBin91(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x136C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum92' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum92_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1370);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum92_GET_AbsValueSquareBin92(UInt32 FftSpectrum92)
{
    return FftSpectrum92 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum92_READ_AbsValueSquareBin92(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1370) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum93' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum93_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1374);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum93_GET_AbsValueSquareBin93(UInt32 FftSpectrum93)
{
    return FftSpectrum93 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum93_READ_AbsValueSquareBin93(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1374) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum94' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum94_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1378);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum94_GET_AbsValueSquareBin94(UInt32 FftSpectrum94)
{
    return FftSpectrum94 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum94_READ_AbsValueSquareBin94(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1378) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum95' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum95_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x137C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum95_GET_AbsValueSquareBin95(UInt32 FftSpectrum95)
{
    return FftSpectrum95 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum95_READ_AbsValueSquareBin95(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x137C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum96' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum96_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1380);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum96_GET_AbsValueSquareBin96(UInt32 FftSpectrum96)
{
    return FftSpectrum96 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum96_READ_AbsValueSquareBin96(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1380) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum97' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum97_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1384);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum97_GET_AbsValueSquareBin97(UInt32 FftSpectrum97)
{
    return FftSpectrum97 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum97_READ_AbsValueSquareBin97(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1384) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum98' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum98_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1388);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum98_GET_AbsValueSquareBin98(UInt32 FftSpectrum98)
{
    return FftSpectrum98 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum98_READ_AbsValueSquareBin98(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1388) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum99' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum99_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x138C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum99_GET_AbsValueSquareBin99(UInt32 FftSpectrum99)
{
    return FftSpectrum99 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum99_READ_AbsValueSquareBin99(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x138C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum100' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum100_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1390);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum100_GET_AbsValueSquareBin100(UInt32 FftSpectrum100)
{
    return FftSpectrum100 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum100_READ_AbsValueSquareBin100(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1390) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum101' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum101_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1394);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum101_GET_AbsValueSquareBin101(UInt32 FftSpectrum101)
{
    return FftSpectrum101 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum101_READ_AbsValueSquareBin101(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1394) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum102' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum102_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1398);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum102_GET_AbsValueSquareBin102(UInt32 FftSpectrum102)
{
    return FftSpectrum102 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum102_READ_AbsValueSquareBin102(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1398) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum103' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum103_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x139C);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum103_GET_AbsValueSquareBin103(UInt32 FftSpectrum103)
{
    return FftSpectrum103 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum103_READ_AbsValueSquareBin103(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x139C) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum104' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum104_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13A0);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum104_GET_AbsValueSquareBin104(UInt32 FftSpectrum104)
{
    return FftSpectrum104 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum104_READ_AbsValueSquareBin104(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13A0) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum105' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum105_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13A4);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum105_GET_AbsValueSquareBin105(UInt32 FftSpectrum105)
{
    return FftSpectrum105 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum105_READ_AbsValueSquareBin105(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13A4) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum106' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum106_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13A8);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum106_GET_AbsValueSquareBin106(UInt32 FftSpectrum106)
{
    return FftSpectrum106 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum106_READ_AbsValueSquareBin106(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13A8) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum107' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum107_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13AC);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum107_GET_AbsValueSquareBin107(UInt32 FftSpectrum107)
{
    return FftSpectrum107 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum107_READ_AbsValueSquareBin107(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13AC) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum108' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum108_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13B0);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum108_GET_AbsValueSquareBin108(UInt32 FftSpectrum108)
{
    return FftSpectrum108 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum108_READ_AbsValueSquareBin108(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13B0) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum109' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum109_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13B4);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum109_GET_AbsValueSquareBin109(UInt32 FftSpectrum109)
{
    return FftSpectrum109 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum109_READ_AbsValueSquareBin109(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13B4) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum110' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum110_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13B8);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum110_GET_AbsValueSquareBin110(UInt32 FftSpectrum110)
{
    return FftSpectrum110 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum110_READ_AbsValueSquareBin110(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13B8) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum111' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum111_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13BC);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum111_GET_AbsValueSquareBin111(UInt32 FftSpectrum111)
{
    return FftSpectrum111 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum111_READ_AbsValueSquareBin111(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13BC) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum112' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum112_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13C0);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum112_GET_AbsValueSquareBin112(UInt32 FftSpectrum112)
{
    return FftSpectrum112 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum112_READ_AbsValueSquareBin112(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13C0) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum113' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum113_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13C4);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum113_GET_AbsValueSquareBin113(UInt32 FftSpectrum113)
{
    return FftSpectrum113 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum113_READ_AbsValueSquareBin113(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13C4) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum114' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum114_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13C8);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum114_GET_AbsValueSquareBin114(UInt32 FftSpectrum114)
{
    return FftSpectrum114 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum114_READ_AbsValueSquareBin114(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13C8) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum115' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum115_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13CC);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum115_GET_AbsValueSquareBin115(UInt32 FftSpectrum115)
{
    return FftSpectrum115 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum115_READ_AbsValueSquareBin115(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13CC) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum116' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum116_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13D0);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum116_GET_AbsValueSquareBin116(UInt32 FftSpectrum116)
{
    return FftSpectrum116 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum116_READ_AbsValueSquareBin116(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13D0) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum117' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum117_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13D4);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum117_GET_AbsValueSquareBin117(UInt32 FftSpectrum117)
{
    return FftSpectrum117 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum117_READ_AbsValueSquareBin117(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13D4) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum118' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum118_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13D8);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum118_GET_AbsValueSquareBin118(UInt32 FftSpectrum118)
{
    return FftSpectrum118 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum118_READ_AbsValueSquareBin118(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13D8) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum119' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum119_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13DC);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum119_GET_AbsValueSquareBin119(UInt32 FftSpectrum119)
{
    return FftSpectrum119 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum119_READ_AbsValueSquareBin119(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13DC) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum120' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum120_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13E0);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum120_GET_AbsValueSquareBin120(UInt32 FftSpectrum120)
{
    return FftSpectrum120 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum120_READ_AbsValueSquareBin120(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13E0) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum121' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum121_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13E4);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum121_GET_AbsValueSquareBin121(UInt32 FftSpectrum121)
{
    return FftSpectrum121 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum121_READ_AbsValueSquareBin121(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13E4) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum122' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum122_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13E8);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum122_GET_AbsValueSquareBin122(UInt32 FftSpectrum122)
{
    return FftSpectrum122 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum122_READ_AbsValueSquareBin122(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13E8) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum123' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum123_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13EC);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum123_GET_AbsValueSquareBin123(UInt32 FftSpectrum123)
{
    return FftSpectrum123 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum123_READ_AbsValueSquareBin123(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13EC) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum124' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum124_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13F0);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum124_GET_AbsValueSquareBin124(UInt32 FftSpectrum124)
{
    return FftSpectrum124 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum124_READ_AbsValueSquareBin124(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13F0) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum125' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum125_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13F4);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum125_GET_AbsValueSquareBin125(UInt32 FftSpectrum125)
{
    return FftSpectrum125 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum125_READ_AbsValueSquareBin125(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13F4) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum126' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum126_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13F8);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum126_GET_AbsValueSquareBin126(UInt32 FftSpectrum126)
{
    return FftSpectrum126 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum126_READ_AbsValueSquareBin126(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13F8) & 0x1FFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FftSpectrum127' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEMOD_FftSpectrum127_READ(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13FC);
}

// Field GET function
static __inline UInt32  S2DEMOD_FftSpectrum127_GET_AbsValueSquareBin127(UInt32 FftSpectrum127)
{
    return FftSpectrum127 & 0x1FFFF;
}

// Field READ function
static __inline UInt32  S2DEMOD_FftSpectrum127_READ_AbsValueSquareBin127(DtBcS2DEMOD_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13FC) & 0x1FFFF;
}

