//*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcS2DEC_RegAccess.h *#*#*#*#*#*#*#*# (C) 2019 DekTec
//
// Device driver - S2Decod v-1 (S2DEC) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block S2Decod.
// These functions should solely be used by the block controller for S2Decod.
//
// 2019.03.26 8:50 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'MinorVersion' and 'MajorVersion' from register 'CoreVersionInfo':
//      UInt32  Reg_CoreVersionInfo, MinorVersion, MajorVersion;
//      Reg_CoreVersionInfo = S2DEC_CoreVersionInfo_READ(pBc);
//      MinorVersion        = S2DEC_CoreVersionInfo_GET_MinorVersion(Reg_CoreVersionInfo);
//      MajorVersion        = S2DEC_CoreVersionInfo_GET_MajorVersion(Reg_CoreVersionInfo);
//
// 2. Single-function shorthand for reading field 'BchDecSuccess' from register
//    'LastFrame':
//      UInt32  BchDecSuccess = S2DEC_LastFrame_READ_BchDecSuccess(pBc);
//
// Updating multiple fields in the same register:
//   UInt32  Reg_InterruptStatus = S2DEC_InterruptStatus_READ(pBc);
//   S2DEC_InterruptStatus_SET_FrameDecoded(Reg_InterruptStatus, 1);
//   S2DEC_InterruptStatus_SET_FrameSkip(Reg_InterruptStatus, 1);
//   S2DEC_InterruptStatus_WRITE(pBc, Reg_InterruptStatus);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// S2DEC_BBRollOffDetector_GET_RollOff0
// S2DEC_BBRollOffDetector_GET_RollOff0Valid
// S2DEC_BBRollOffDetector_GET_RollOff1
// S2DEC_BBRollOffDetector_GET_RollOff1Valid
// S2DEC_BBRollOffDetector_READ
// S2DEC_BBRollOffDetector_SET_RollOff0
// S2DEC_BBRollOffDetector_SET_RollOff0Valid
// S2DEC_BBRollOffDetector_SET_RollOff1
// S2DEC_BBRollOffDetector_SET_RollOff1Valid
// S2DEC_BBRollOffDetector_WRITE
// S2DEC_BchSuccessCounter_READ
// S2DEC_BchSuccessCounter_WRITE
// S2DEC_CoreVersionInfo_GET_MajorVersion
// S2DEC_CoreVersionInfo_GET_MinorVersion
// S2DEC_CoreVersionInfo_GET_NumLdpcDec
// S2DEC_CoreVersionInfo_READ
// S2DEC_CoreVersionInfo_READ_MajorVersion
// S2DEC_CoreVersionInfo_READ_MinorVersion
// S2DEC_CoreVersionInfo_READ_NumLdpcDec
// S2DEC_CounterLock_READ
// S2DEC_CounterLock_WRITE
// S2DEC_FrameCounter_READ
// S2DEC_FrameCounter_WRITE
// S2DEC_FrameSkipCounter_READ
// S2DEC_FrameSkipCounter_WRITE
// S2DEC_InterruptEnable_GET_FrameDecoded
// S2DEC_InterruptEnable_GET_FrameSkip
// S2DEC_InterruptEnable_READ
// S2DEC_InterruptEnable_SET_FrameDecoded
// S2DEC_InterruptEnable_SET_FrameSkip
// S2DEC_InterruptEnable_WRITE
// S2DEC_InterruptStatus_GET_FrameDecoded
// S2DEC_InterruptStatus_GET_FrameSkip
// S2DEC_InterruptStatus_READ
// S2DEC_InterruptStatus_SET_FrameDecoded
// S2DEC_InterruptStatus_SET_FrameSkip
// S2DEC_InterruptStatus_WRITE
// S2DEC_LastFrame_GET_BchDecSuccess
// S2DEC_LastFrame_GET_LdpcDecSuccess
// S2DEC_LastFrame_GET_LdpcIterations
// S2DEC_LastFrame_GET_PlsValue
// S2DEC_LastFrame_GET_VlsnrModcod
// S2DEC_LastFrame_READ
// S2DEC_LastFrame_READ_BchDecSuccess
// S2DEC_LastFrame_READ_LdpcDecSuccess
// S2DEC_LastFrame_READ_LdpcIterations
// S2DEC_LastFrame_READ_PlsValue
// S2DEC_LastFrame_READ_VlsnrModcod
// S2DEC_LdpcItCnt_READ
// S2DEC_LdpcItCnt_WRITE
// S2DEC_LdpcItLutEn_READ
// S2DEC_LdpcItLutEn_WRITE
// S2DEC_LdpcItPls100a101_GET_IterationsPls100a101
// S2DEC_LdpcItPls100a101_READ
// S2DEC_LdpcItPls100a101_SET_IterationsPls100a101
// S2DEC_LdpcItPls100a101_WRITE
// S2DEC_LdpcItPls102a103_GET_IterationsPls102a103
// S2DEC_LdpcItPls102a103_READ
// S2DEC_LdpcItPls102a103_SET_IterationsPls102a103
// S2DEC_LdpcItPls102a103_WRITE
// S2DEC_LdpcItPls104a105_GET_IterationsPls104a105
// S2DEC_LdpcItPls104a105_READ
// S2DEC_LdpcItPls104a105_SET_IterationsPls104a105
// S2DEC_LdpcItPls104a105_WRITE
// S2DEC_LdpcItPls106a107_GET_IterationsPls106a107
// S2DEC_LdpcItPls106a107_READ
// S2DEC_LdpcItPls106a107_SET_IterationsPls106a107
// S2DEC_LdpcItPls106a107_WRITE
// S2DEC_LdpcItPls108a109_GET_IterationsPls108a109
// S2DEC_LdpcItPls108a109_READ
// S2DEC_LdpcItPls108a109_SET_IterationsPls108a109
// S2DEC_LdpcItPls108a109_WRITE
// S2DEC_LdpcItPls10a11_GET_IterationsPls10a11
// S2DEC_LdpcItPls10a11_READ
// S2DEC_LdpcItPls10a11_SET_IterationsPls10a11
// S2DEC_LdpcItPls10a11_WRITE
// S2DEC_LdpcItPls110a111_GET_IterationsPls110a111
// S2DEC_LdpcItPls110a111_READ
// S2DEC_LdpcItPls110a111_SET_IterationsPls110a111
// S2DEC_LdpcItPls110a111_WRITE
// S2DEC_LdpcItPls112a113_GET_IterationsPls112a113
// S2DEC_LdpcItPls112a113_READ
// S2DEC_LdpcItPls112a113_SET_IterationsPls112a113
// S2DEC_LdpcItPls112a113_WRITE
// S2DEC_LdpcItPls114a115_GET_IterationsPls114a115
// S2DEC_LdpcItPls114a115_READ
// S2DEC_LdpcItPls114a115_SET_IterationsPls114a115
// S2DEC_LdpcItPls114a115_WRITE
// S2DEC_LdpcItPls116a117_GET_IterationsPls116a117
// S2DEC_LdpcItPls116a117_READ
// S2DEC_LdpcItPls116a117_SET_IterationsPls116a117
// S2DEC_LdpcItPls116a117_WRITE
// S2DEC_LdpcItPls118a119_GET_IterationsPls118a119
// S2DEC_LdpcItPls118a119_READ
// S2DEC_LdpcItPls118a119_SET_IterationsPls118a119
// S2DEC_LdpcItPls118a119_WRITE
// S2DEC_LdpcItPls120a121_GET_IterationsPls120a121
// S2DEC_LdpcItPls120a121_READ
// S2DEC_LdpcItPls120a121_SET_IterationsPls120a121
// S2DEC_LdpcItPls120a121_WRITE
// S2DEC_LdpcItPls122a123_GET_IterationsPls122a123
// S2DEC_LdpcItPls122a123_READ
// S2DEC_LdpcItPls122a123_SET_IterationsPls122a123
// S2DEC_LdpcItPls122a123_WRITE
// S2DEC_LdpcItPls124a125_GET_IterationsPls124a125
// S2DEC_LdpcItPls124a125_READ
// S2DEC_LdpcItPls124a125_SET_IterationsPls124a125
// S2DEC_LdpcItPls124a125_WRITE
// S2DEC_LdpcItPls126a127_GET_IterationsPls126a127
// S2DEC_LdpcItPls126a127_READ
// S2DEC_LdpcItPls126a127_SET_IterationsPls126a127
// S2DEC_LdpcItPls126a127_WRITE
// S2DEC_LdpcItPls128a129_GET_IterationsPls128a129
// S2DEC_LdpcItPls128a129_READ
// S2DEC_LdpcItPls128a129_SET_IterationsPls128a129
// S2DEC_LdpcItPls128a129_WRITE
// S2DEC_LdpcItPls12a13_GET_IterationsPls12a13
// S2DEC_LdpcItPls12a13_READ
// S2DEC_LdpcItPls12a13_SET_IterationsPls12a13
// S2DEC_LdpcItPls12a13_WRITE
// S2DEC_LdpcItPls130a131_GET_IterationsPls130a131
// S2DEC_LdpcItPls130a131_READ
// S2DEC_LdpcItPls130a131_SET_IterationsPls130a131
// S2DEC_LdpcItPls130a131_WRITE
// S2DEC_LdpcItPls132a133_GET_IterationsPls132a133
// S2DEC_LdpcItPls132a133_READ
// S2DEC_LdpcItPls132a133_SET_IterationsPls132a133
// S2DEC_LdpcItPls132a133_WRITE
// S2DEC_LdpcItPls134a135_GET_IterationsPls134a135
// S2DEC_LdpcItPls134a135_READ
// S2DEC_LdpcItPls134a135_SET_IterationsPls134a135
// S2DEC_LdpcItPls134a135_WRITE
// S2DEC_LdpcItPls136a137_GET_IterationsPls136a137
// S2DEC_LdpcItPls136a137_READ
// S2DEC_LdpcItPls136a137_SET_IterationsPls136a137
// S2DEC_LdpcItPls136a137_WRITE
// S2DEC_LdpcItPls138a139_GET_IterationsPls138a139
// S2DEC_LdpcItPls138a139_READ
// S2DEC_LdpcItPls138a139_SET_IterationsPls138a139
// S2DEC_LdpcItPls138a139_WRITE
// S2DEC_LdpcItPls140a141_GET_IterationsPls140a141
// S2DEC_LdpcItPls140a141_READ
// S2DEC_LdpcItPls140a141_SET_IterationsPls140a141
// S2DEC_LdpcItPls140a141_WRITE
// S2DEC_LdpcItPls142a143_GET_IterationsPls142a143
// S2DEC_LdpcItPls142a143_READ
// S2DEC_LdpcItPls142a143_SET_IterationsPls142a143
// S2DEC_LdpcItPls142a143_WRITE
// S2DEC_LdpcItPls144a145_GET_IterationsPls144a145
// S2DEC_LdpcItPls144a145_READ
// S2DEC_LdpcItPls144a145_SET_IterationsPls144a145
// S2DEC_LdpcItPls144a145_WRITE
// S2DEC_LdpcItPls146a147_GET_IterationsPls146a147
// S2DEC_LdpcItPls146a147_READ
// S2DEC_LdpcItPls146a147_SET_IterationsPls146a147
// S2DEC_LdpcItPls146a147_WRITE
// S2DEC_LdpcItPls148a149_GET_IterationsPls148a149
// S2DEC_LdpcItPls148a149_READ
// S2DEC_LdpcItPls148a149_SET_IterationsPls148a149
// S2DEC_LdpcItPls148a149_WRITE
// S2DEC_LdpcItPls14a15_GET_IterationsPls14a15
// S2DEC_LdpcItPls14a15_READ
// S2DEC_LdpcItPls14a15_SET_IterationsPls14a15
// S2DEC_LdpcItPls14a15_WRITE
// S2DEC_LdpcItPls150a151_GET_IterationsPls150a151
// S2DEC_LdpcItPls150a151_READ
// S2DEC_LdpcItPls150a151_SET_IterationsPls150a151
// S2DEC_LdpcItPls150a151_WRITE
// S2DEC_LdpcItPls152a153_GET_IterationsPls152a153
// S2DEC_LdpcItPls152a153_READ
// S2DEC_LdpcItPls152a153_SET_IterationsPls152a153
// S2DEC_LdpcItPls152a153_WRITE
// S2DEC_LdpcItPls154a155_GET_IterationsPls154a155
// S2DEC_LdpcItPls154a155_READ
// S2DEC_LdpcItPls154a155_SET_IterationsPls154a155
// S2DEC_LdpcItPls154a155_WRITE
// S2DEC_LdpcItPls156a157_GET_IterationsPls156a157
// S2DEC_LdpcItPls156a157_READ
// S2DEC_LdpcItPls156a157_SET_IterationsPls156a157
// S2DEC_LdpcItPls156a157_WRITE
// S2DEC_LdpcItPls158a159_GET_IterationsPls158a159
// S2DEC_LdpcItPls158a159_READ
// S2DEC_LdpcItPls158a159_SET_IterationsPls158a159
// S2DEC_LdpcItPls158a159_WRITE
// S2DEC_LdpcItPls160a161_GET_IterationsPls160a161
// S2DEC_LdpcItPls160a161_READ
// S2DEC_LdpcItPls160a161_SET_IterationsPls160a161
// S2DEC_LdpcItPls160a161_WRITE
// S2DEC_LdpcItPls162a163_GET_IterationsPls162a163
// S2DEC_LdpcItPls162a163_READ
// S2DEC_LdpcItPls162a163_SET_IterationsPls162a163
// S2DEC_LdpcItPls162a163_WRITE
// S2DEC_LdpcItPls164a165_GET_IterationsPls164a165
// S2DEC_LdpcItPls164a165_READ
// S2DEC_LdpcItPls164a165_SET_IterationsPls164a165
// S2DEC_LdpcItPls164a165_WRITE
// S2DEC_LdpcItPls166a167_GET_IterationsPls166a167
// S2DEC_LdpcItPls166a167_READ
// S2DEC_LdpcItPls166a167_SET_IterationsPls166a167
// S2DEC_LdpcItPls166a167_WRITE
// S2DEC_LdpcItPls168a169_GET_IterationsPls168a169
// S2DEC_LdpcItPls168a169_READ
// S2DEC_LdpcItPls168a169_SET_IterationsPls168a169
// S2DEC_LdpcItPls168a169_WRITE
// S2DEC_LdpcItPls16a17_GET_IterationsPls16a17
// S2DEC_LdpcItPls16a17_READ
// S2DEC_LdpcItPls16a17_SET_IterationsPls16a17
// S2DEC_LdpcItPls16a17_WRITE
// S2DEC_LdpcItPls170a171_GET_IterationsPls170a171
// S2DEC_LdpcItPls170a171_READ
// S2DEC_LdpcItPls170a171_SET_IterationsPls170a171
// S2DEC_LdpcItPls170a171_WRITE
// S2DEC_LdpcItPls172a173_GET_IterationsPls172a173
// S2DEC_LdpcItPls172a173_READ
// S2DEC_LdpcItPls172a173_SET_IterationsPls172a173
// S2DEC_LdpcItPls172a173_WRITE
// S2DEC_LdpcItPls174a175_GET_IterationsPls174a175
// S2DEC_LdpcItPls174a175_READ
// S2DEC_LdpcItPls174a175_SET_IterationsPls174a175
// S2DEC_LdpcItPls174a175_WRITE
// S2DEC_LdpcItPls176a177_GET_IterationsPls176a177
// S2DEC_LdpcItPls176a177_READ
// S2DEC_LdpcItPls176a177_SET_IterationsPls176a177
// S2DEC_LdpcItPls176a177_WRITE
// S2DEC_LdpcItPls178a179_GET_IterationsPls178a179
// S2DEC_LdpcItPls178a179_READ
// S2DEC_LdpcItPls178a179_SET_IterationsPls178a179
// S2DEC_LdpcItPls178a179_WRITE
// S2DEC_LdpcItPls180a181_GET_IterationsPls180a181
// S2DEC_LdpcItPls180a181_READ
// S2DEC_LdpcItPls180a181_SET_IterationsPls180a181
// S2DEC_LdpcItPls180a181_WRITE
// S2DEC_LdpcItPls182a183_GET_IterationsPls182a183
// S2DEC_LdpcItPls182a183_READ
// S2DEC_LdpcItPls182a183_SET_IterationsPls182a183
// S2DEC_LdpcItPls182a183_WRITE
// S2DEC_LdpcItPls184a185_GET_IterationsPls184a185
// S2DEC_LdpcItPls184a185_READ
// S2DEC_LdpcItPls184a185_SET_IterationsPls184a185
// S2DEC_LdpcItPls184a185_WRITE
// S2DEC_LdpcItPls186a187_GET_IterationsPls186a187
// S2DEC_LdpcItPls186a187_READ
// S2DEC_LdpcItPls186a187_SET_IterationsPls186a187
// S2DEC_LdpcItPls186a187_WRITE
// S2DEC_LdpcItPls188a189_GET_IterationsPls188a189
// S2DEC_LdpcItPls188a189_READ
// S2DEC_LdpcItPls188a189_SET_IterationsPls188a189
// S2DEC_LdpcItPls188a189_WRITE
// S2DEC_LdpcItPls18a19_GET_IterationsPls18a19
// S2DEC_LdpcItPls18a19_READ
// S2DEC_LdpcItPls18a19_SET_IterationsPls18a19
// S2DEC_LdpcItPls18a19_WRITE
// S2DEC_LdpcItPls190a191_GET_IterationsPls190a191
// S2DEC_LdpcItPls190a191_READ
// S2DEC_LdpcItPls190a191_SET_IterationsPls190a191
// S2DEC_LdpcItPls190a191_WRITE
// S2DEC_LdpcItPls192a193_GET_IterationsPls192a193
// S2DEC_LdpcItPls192a193_READ
// S2DEC_LdpcItPls192a193_SET_IterationsPls192a193
// S2DEC_LdpcItPls192a193_WRITE
// S2DEC_LdpcItPls194a195_GET_IterationsPls194a195
// S2DEC_LdpcItPls194a195_READ
// S2DEC_LdpcItPls194a195_SET_IterationsPls194a195
// S2DEC_LdpcItPls194a195_WRITE
// S2DEC_LdpcItPls196a197_GET_IterationsPls196a197
// S2DEC_LdpcItPls196a197_READ
// S2DEC_LdpcItPls196a197_SET_IterationsPls196a197
// S2DEC_LdpcItPls196a197_WRITE
// S2DEC_LdpcItPls198a199_GET_IterationsPls198a199
// S2DEC_LdpcItPls198a199_READ
// S2DEC_LdpcItPls198a199_SET_IterationsPls198a199
// S2DEC_LdpcItPls198a199_WRITE
// S2DEC_LdpcItPls200a201_GET_IterationsPls200a201
// S2DEC_LdpcItPls200a201_READ
// S2DEC_LdpcItPls200a201_SET_IterationsPls200a201
// S2DEC_LdpcItPls200a201_WRITE
// S2DEC_LdpcItPls202a203_GET_IterationsPls202a203
// S2DEC_LdpcItPls202a203_READ
// S2DEC_LdpcItPls202a203_SET_IterationsPls202a203
// S2DEC_LdpcItPls202a203_WRITE
// S2DEC_LdpcItPls204a205_GET_IterationsPls204a205
// S2DEC_LdpcItPls204a205_READ
// S2DEC_LdpcItPls204a205_SET_IterationsPls204a205
// S2DEC_LdpcItPls204a205_WRITE
// S2DEC_LdpcItPls206a207_GET_IterationsPls206a207
// S2DEC_LdpcItPls206a207_READ
// S2DEC_LdpcItPls206a207_SET_IterationsPls206a207
// S2DEC_LdpcItPls206a207_WRITE
// S2DEC_LdpcItPls208a209_GET_IterationsPls208a209
// S2DEC_LdpcItPls208a209_READ
// S2DEC_LdpcItPls208a209_SET_IterationsPls208a209
// S2DEC_LdpcItPls208a209_WRITE
// S2DEC_LdpcItPls20a21_GET_IterationsPls20a21
// S2DEC_LdpcItPls20a21_READ
// S2DEC_LdpcItPls20a21_SET_IterationsPls20a21
// S2DEC_LdpcItPls20a21_WRITE
// S2DEC_LdpcItPls210a211_GET_IterationsPls210a211
// S2DEC_LdpcItPls210a211_READ
// S2DEC_LdpcItPls210a211_SET_IterationsPls210a211
// S2DEC_LdpcItPls210a211_WRITE
// S2DEC_LdpcItPls212a213_GET_IterationsPls212a213
// S2DEC_LdpcItPls212a213_READ
// S2DEC_LdpcItPls212a213_SET_IterationsPls212a213
// S2DEC_LdpcItPls212a213_WRITE
// S2DEC_LdpcItPls214a215_GET_IterationsPls214a215
// S2DEC_LdpcItPls214a215_READ
// S2DEC_LdpcItPls214a215_SET_IterationsPls214a215
// S2DEC_LdpcItPls214a215_WRITE
// S2DEC_LdpcItPls216a217_GET_IterationsPls216a217
// S2DEC_LdpcItPls216a217_READ
// S2DEC_LdpcItPls216a217_SET_IterationsPls216a217
// S2DEC_LdpcItPls216a217_WRITE
// S2DEC_LdpcItPls218a219_GET_IterationsPls218a219
// S2DEC_LdpcItPls218a219_READ
// S2DEC_LdpcItPls218a219_SET_IterationsPls218a219
// S2DEC_LdpcItPls218a219_WRITE
// S2DEC_LdpcItPls220a221_GET_IterationsPls220a221
// S2DEC_LdpcItPls220a221_READ
// S2DEC_LdpcItPls220a221_SET_IterationsPls220a221
// S2DEC_LdpcItPls220a221_WRITE
// S2DEC_LdpcItPls222a223_GET_IterationsPls222a223
// S2DEC_LdpcItPls222a223_READ
// S2DEC_LdpcItPls222a223_SET_IterationsPls222a223
// S2DEC_LdpcItPls222a223_WRITE
// S2DEC_LdpcItPls224a225_GET_IterationsPls224a225
// S2DEC_LdpcItPls224a225_READ
// S2DEC_LdpcItPls224a225_SET_IterationsPls224a225
// S2DEC_LdpcItPls224a225_WRITE
// S2DEC_LdpcItPls226a227_GET_IterationsPls226a227
// S2DEC_LdpcItPls226a227_READ
// S2DEC_LdpcItPls226a227_SET_IterationsPls226a227
// S2DEC_LdpcItPls226a227_WRITE
// S2DEC_LdpcItPls228a229_GET_IterationsPls228a229
// S2DEC_LdpcItPls228a229_READ
// S2DEC_LdpcItPls228a229_SET_IterationsPls228a229
// S2DEC_LdpcItPls228a229_WRITE
// S2DEC_LdpcItPls22a23_GET_IterationsPls22a23
// S2DEC_LdpcItPls22a23_READ
// S2DEC_LdpcItPls22a23_SET_IterationsPls22a23
// S2DEC_LdpcItPls22a23_WRITE
// S2DEC_LdpcItPls230a231_GET_IterationsPls230a231
// S2DEC_LdpcItPls230a231_READ
// S2DEC_LdpcItPls230a231_SET_IterationsPls230a231
// S2DEC_LdpcItPls230a231_WRITE
// S2DEC_LdpcItPls232a233_GET_IterationsPls232a233
// S2DEC_LdpcItPls232a233_READ
// S2DEC_LdpcItPls232a233_SET_IterationsPls232a233
// S2DEC_LdpcItPls232a233_WRITE
// S2DEC_LdpcItPls234a235_GET_IterationsPls234a235
// S2DEC_LdpcItPls234a235_READ
// S2DEC_LdpcItPls234a235_SET_IterationsPls234a235
// S2DEC_LdpcItPls234a235_WRITE
// S2DEC_LdpcItPls236a237_GET_IterationsPls236a237
// S2DEC_LdpcItPls236a237_READ
// S2DEC_LdpcItPls236a237_SET_IterationsPls236a237
// S2DEC_LdpcItPls236a237_WRITE
// S2DEC_LdpcItPls238a239_GET_IterationsPls238a239
// S2DEC_LdpcItPls238a239_READ
// S2DEC_LdpcItPls238a239_SET_IterationsPls238a239
// S2DEC_LdpcItPls238a239_WRITE
// S2DEC_LdpcItPls240a241_GET_IterationsPls240a241
// S2DEC_LdpcItPls240a241_READ
// S2DEC_LdpcItPls240a241_SET_IterationsPls240a241
// S2DEC_LdpcItPls240a241_WRITE
// S2DEC_LdpcItPls242a243_GET_IterationsPls242a243
// S2DEC_LdpcItPls242a243_READ
// S2DEC_LdpcItPls242a243_SET_IterationsPls242a243
// S2DEC_LdpcItPls242a243_WRITE
// S2DEC_LdpcItPls244a245_GET_IterationsPls244a245
// S2DEC_LdpcItPls244a245_READ
// S2DEC_LdpcItPls244a245_SET_IterationsPls244a245
// S2DEC_LdpcItPls244a245_WRITE
// S2DEC_LdpcItPls246a247_GET_IterationsPls246a247
// S2DEC_LdpcItPls246a247_READ
// S2DEC_LdpcItPls246a247_SET_IterationsPls246a247
// S2DEC_LdpcItPls246a247_WRITE
// S2DEC_LdpcItPls248a249_GET_IterationsPls248a249
// S2DEC_LdpcItPls248a249_READ
// S2DEC_LdpcItPls248a249_SET_IterationsPls248a249
// S2DEC_LdpcItPls248a249_WRITE
// S2DEC_LdpcItPls24a25_GET_IterationsPls24a25
// S2DEC_LdpcItPls24a25_READ
// S2DEC_LdpcItPls24a25_SET_IterationsPls24a25
// S2DEC_LdpcItPls24a25_WRITE
// S2DEC_LdpcItPls26a27_GET_IterationsPls26a27
// S2DEC_LdpcItPls26a27_READ
// S2DEC_LdpcItPls26a27_SET_IterationsPls26a27
// S2DEC_LdpcItPls26a27_WRITE
// S2DEC_LdpcItPls28a29_GET_IterationsPls28a29
// S2DEC_LdpcItPls28a29_READ
// S2DEC_LdpcItPls28a29_SET_IterationsPls28a29
// S2DEC_LdpcItPls28a29_WRITE
// S2DEC_LdpcItPls30a31_GET_IterationsPls30a31
// S2DEC_LdpcItPls30a31_READ
// S2DEC_LdpcItPls30a31_SET_IterationsPls30a31
// S2DEC_LdpcItPls30a31_WRITE
// S2DEC_LdpcItPls32a33_GET_IterationsPls32a33
// S2DEC_LdpcItPls32a33_READ
// S2DEC_LdpcItPls32a33_SET_IterationsPls32a33
// S2DEC_LdpcItPls32a33_WRITE
// S2DEC_LdpcItPls34a35_GET_IterationsPls34a35
// S2DEC_LdpcItPls34a35_READ
// S2DEC_LdpcItPls34a35_SET_IterationsPls34a35
// S2DEC_LdpcItPls34a35_WRITE
// S2DEC_LdpcItPls36a37_GET_IterationsPls36a37
// S2DEC_LdpcItPls36a37_READ
// S2DEC_LdpcItPls36a37_SET_IterationsPls36a37
// S2DEC_LdpcItPls36a37_WRITE
// S2DEC_LdpcItPls38a39_GET_IterationsPls38a39
// S2DEC_LdpcItPls38a39_READ
// S2DEC_LdpcItPls38a39_SET_IterationsPls38a39
// S2DEC_LdpcItPls38a39_WRITE
// S2DEC_LdpcItPls40a41_GET_IterationsPls40a41
// S2DEC_LdpcItPls40a41_READ
// S2DEC_LdpcItPls40a41_SET_IterationsPls40a41
// S2DEC_LdpcItPls40a41_WRITE
// S2DEC_LdpcItPls42a43_GET_IterationsPls42a43
// S2DEC_LdpcItPls42a43_READ
// S2DEC_LdpcItPls42a43_SET_IterationsPls42a43
// S2DEC_LdpcItPls42a43_WRITE
// S2DEC_LdpcItPls44a45_GET_IterationsPls44a45
// S2DEC_LdpcItPls44a45_READ
// S2DEC_LdpcItPls44a45_SET_IterationsPls44a45
// S2DEC_LdpcItPls44a45_WRITE
// S2DEC_LdpcItPls46a47_GET_IterationsPls46a47
// S2DEC_LdpcItPls46a47_READ
// S2DEC_LdpcItPls46a47_SET_IterationsPls46a47
// S2DEC_LdpcItPls46a47_WRITE
// S2DEC_LdpcItPls48a49_GET_IterationsPls48a49
// S2DEC_LdpcItPls48a49_READ
// S2DEC_LdpcItPls48a49_SET_IterationsPls48a49
// S2DEC_LdpcItPls48a49_WRITE
// S2DEC_LdpcItPls4a5_GET_IterationsPls4a5
// S2DEC_LdpcItPls4a5_READ
// S2DEC_LdpcItPls4a5_SET_IterationsPls4a5
// S2DEC_LdpcItPls4a5_WRITE
// S2DEC_LdpcItPls50a51_GET_IterationsPls50a51
// S2DEC_LdpcItPls50a51_READ
// S2DEC_LdpcItPls50a51_SET_IterationsPls50a51
// S2DEC_LdpcItPls50a51_WRITE
// S2DEC_LdpcItPls52a53_GET_IterationsPls52a53
// S2DEC_LdpcItPls52a53_READ
// S2DEC_LdpcItPls52a53_SET_IterationsPls52a53
// S2DEC_LdpcItPls52a53_WRITE
// S2DEC_LdpcItPls54a55_GET_IterationsPls54a55
// S2DEC_LdpcItPls54a55_READ
// S2DEC_LdpcItPls54a55_SET_IterationsPls54a55
// S2DEC_LdpcItPls54a55_WRITE
// S2DEC_LdpcItPls56a57_GET_IterationsPls56a57
// S2DEC_LdpcItPls56a57_READ
// S2DEC_LdpcItPls56a57_SET_IterationsPls56a57
// S2DEC_LdpcItPls56a57_WRITE
// S2DEC_LdpcItPls58a59_GET_IterationsPls58a59
// S2DEC_LdpcItPls58a59_READ
// S2DEC_LdpcItPls58a59_SET_IterationsPls58a59
// S2DEC_LdpcItPls58a59_WRITE
// S2DEC_LdpcItPls60a61_GET_IterationsPls60a61
// S2DEC_LdpcItPls60a61_READ
// S2DEC_LdpcItPls60a61_SET_IterationsPls60a61
// S2DEC_LdpcItPls60a61_WRITE
// S2DEC_LdpcItPls62a63_GET_IterationsPls62a63
// S2DEC_LdpcItPls62a63_READ
// S2DEC_LdpcItPls62a63_SET_IterationsPls62a63
// S2DEC_LdpcItPls62a63_WRITE
// S2DEC_LdpcItPls64a65_GET_IterationsPls64a65
// S2DEC_LdpcItPls64a65_READ
// S2DEC_LdpcItPls64a65_SET_IterationsPls64a65
// S2DEC_LdpcItPls64a65_WRITE
// S2DEC_LdpcItPls66a67_GET_IterationsPls66a67
// S2DEC_LdpcItPls66a67_READ
// S2DEC_LdpcItPls66a67_SET_IterationsPls66a67
// S2DEC_LdpcItPls66a67_WRITE
// S2DEC_LdpcItPls68a69_GET_IterationsPls68a69
// S2DEC_LdpcItPls68a69_READ
// S2DEC_LdpcItPls68a69_SET_IterationsPls68a69
// S2DEC_LdpcItPls68a69_WRITE
// S2DEC_LdpcItPls6a7_GET_IterationsPls6a7
// S2DEC_LdpcItPls6a7_READ
// S2DEC_LdpcItPls6a7_SET_IterationsPls6a7
// S2DEC_LdpcItPls6a7_WRITE
// S2DEC_LdpcItPls70a71_GET_IterationsPls70a71
// S2DEC_LdpcItPls70a71_READ
// S2DEC_LdpcItPls70a71_SET_IterationsPls70a71
// S2DEC_LdpcItPls70a71_WRITE
// S2DEC_LdpcItPls72a73_GET_IterationsPls72a73
// S2DEC_LdpcItPls72a73_READ
// S2DEC_LdpcItPls72a73_SET_IterationsPls72a73
// S2DEC_LdpcItPls72a73_WRITE
// S2DEC_LdpcItPls74a75_GET_IterationsPls74a75
// S2DEC_LdpcItPls74a75_READ
// S2DEC_LdpcItPls74a75_SET_IterationsPls74a75
// S2DEC_LdpcItPls74a75_WRITE
// S2DEC_LdpcItPls76a77_GET_IterationsPls76a77
// S2DEC_LdpcItPls76a77_READ
// S2DEC_LdpcItPls76a77_SET_IterationsPls76a77
// S2DEC_LdpcItPls76a77_WRITE
// S2DEC_LdpcItPls78a79_GET_IterationsPls78a79
// S2DEC_LdpcItPls78a79_READ
// S2DEC_LdpcItPls78a79_SET_IterationsPls78a79
// S2DEC_LdpcItPls78a79_WRITE
// S2DEC_LdpcItPls80a81_GET_IterationsPls80a81
// S2DEC_LdpcItPls80a81_READ
// S2DEC_LdpcItPls80a81_SET_IterationsPls80a81
// S2DEC_LdpcItPls80a81_WRITE
// S2DEC_LdpcItPls82a83_GET_IterationsPls82a83
// S2DEC_LdpcItPls82a83_READ
// S2DEC_LdpcItPls82a83_SET_IterationsPls82a83
// S2DEC_LdpcItPls82a83_WRITE
// S2DEC_LdpcItPls84a85_GET_IterationsPls84a85
// S2DEC_LdpcItPls84a85_READ
// S2DEC_LdpcItPls84a85_SET_IterationsPls84a85
// S2DEC_LdpcItPls84a85_WRITE
// S2DEC_LdpcItPls86a87_GET_IterationsPls86a87
// S2DEC_LdpcItPls86a87_READ
// S2DEC_LdpcItPls86a87_SET_IterationsPls86a87
// S2DEC_LdpcItPls86a87_WRITE
// S2DEC_LdpcItPls88a89_GET_IterationsPls88a89
// S2DEC_LdpcItPls88a89_READ
// S2DEC_LdpcItPls88a89_SET_IterationsPls88a89
// S2DEC_LdpcItPls88a89_WRITE
// S2DEC_LdpcItPls8a9_GET_IterationsPls8a9
// S2DEC_LdpcItPls8a9_READ
// S2DEC_LdpcItPls8a9_SET_IterationsPls8a9
// S2DEC_LdpcItPls8a9_WRITE
// S2DEC_LdpcItPls90a91_GET_IterationsPls90a91
// S2DEC_LdpcItPls90a91_READ
// S2DEC_LdpcItPls90a91_SET_IterationsPls90a91
// S2DEC_LdpcItPls90a91_WRITE
// S2DEC_LdpcItPls92a93_GET_IterationsPls92a93
// S2DEC_LdpcItPls92a93_READ
// S2DEC_LdpcItPls92a93_SET_IterationsPls92a93
// S2DEC_LdpcItPls92a93_WRITE
// S2DEC_LdpcItPls94a95_GET_IterationsPls94a95
// S2DEC_LdpcItPls94a95_READ
// S2DEC_LdpcItPls94a95_SET_IterationsPls94a95
// S2DEC_LdpcItPls94a95_WRITE
// S2DEC_LdpcItPls96a97_GET_IterationsPls96a97
// S2DEC_LdpcItPls96a97_READ
// S2DEC_LdpcItPls96a97_SET_IterationsPls96a97
// S2DEC_LdpcItPls96a97_WRITE
// S2DEC_LdpcItPls98a99_GET_IterationsPls98a99
// S2DEC_LdpcItPls98a99_READ
// S2DEC_LdpcItPls98a99_SET_IterationsPls98a99
// S2DEC_LdpcItPls98a99_WRITE
// S2DEC_LdpcSuccessCounter_READ
// S2DEC_LdpcSuccessCounter_WRITE
// S2DEC_SnrEstErrorPower_READ
// S2DEC_SnrEstSignalPower_READ
// S2DEC_SnrEstimatorFrames_GET_SnrFrames
// S2DEC_SnrEstimatorFrames_READ
// S2DEC_SnrEstimatorFrames_SET_SnrFrames
// S2DEC_SnrEstimatorFrames_WRITE

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'CoreVersionInfo' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_CoreVersionInfo_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1000);
}

// Field GET functions
static __inline UInt32  S2DEC_CoreVersionInfo_GET_MinorVersion(UInt32 CoreVersionInfo)
{
    return CoreVersionInfo & 0xF;
}
static __inline UInt32  S2DEC_CoreVersionInfo_GET_MajorVersion(UInt32 CoreVersionInfo)
{
    return (CoreVersionInfo & 0xF0) >> 4;
}
static __inline UInt32  S2DEC_CoreVersionInfo_GET_NumLdpcDec(UInt32 CoreVersionInfo)
{
    return (CoreVersionInfo & 0xF00) >> 8;
}

// Field READ functions
static __inline UInt32  S2DEC_CoreVersionInfo_READ_MinorVersion(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1000) & 0xF;
}
static __inline UInt32  S2DEC_CoreVersionInfo_READ_MajorVersion(DtBcS2DEC_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x1000) & 0xF0) >> 4;
}
static __inline UInt32  S2DEC_CoreVersionInfo_READ_NumLdpcDec(DtBcS2DEC_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x1000) & 0xF00) >> 8;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'InterruptStatus' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_InterruptStatus_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1004);
}

// Field GET functions
static __inline UInt32  S2DEC_InterruptStatus_GET_FrameDecoded(UInt32 InterruptStatus)
{
    return InterruptStatus & 0x1;
}
static __inline UInt32  S2DEC_InterruptStatus_GET_FrameSkip(UInt32 InterruptStatus)
{
    return (InterruptStatus & 0x2) >> 1;
}

// Field SET functions
static __inline UInt32  S2DEC_InterruptStatus_SET_FrameDecoded(UInt32 InterruptStatus, UInt32 FrameDecoded)
{
    DT_ASSERT((FrameDecoded & ~0x1) == 0);
    return (InterruptStatus & ~0x1) | FrameDecoded;
}
static __inline UInt32  S2DEC_InterruptStatus_SET_FrameSkip(UInt32 InterruptStatus, UInt32 FrameSkip)
{
    DT_ASSERT((FrameSkip & ~0x1) == 0);
    return (InterruptStatus & ~0x2) | (FrameSkip << 1);
}

// Register WRITE function
static __inline void  S2DEC_InterruptStatus_WRITE(DtBcS2DEC_2132* pBc, UInt32 InterruptStatus)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1004, InterruptStatus);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'InterruptEnable' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_InterruptEnable_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1008);
}

// Field GET functions
static __inline UInt32  S2DEC_InterruptEnable_GET_FrameDecoded(UInt32 InterruptEnable)
{
    return InterruptEnable & 0x1;
}
static __inline UInt32  S2DEC_InterruptEnable_GET_FrameSkip(UInt32 InterruptEnable)
{
    return (InterruptEnable & 0x2) >> 1;
}

// Field SET functions
static __inline UInt32  S2DEC_InterruptEnable_SET_FrameDecoded(UInt32 InterruptEnable, UInt32 FrameDecoded)
{
    DT_ASSERT((FrameDecoded & ~0x1) == 0);
    return (InterruptEnable & ~0x1) | FrameDecoded;
}
static __inline UInt32  S2DEC_InterruptEnable_SET_FrameSkip(UInt32 InterruptEnable, UInt32 FrameSkip)
{
    DT_ASSERT((FrameSkip & ~0x1) == 0);
    return (InterruptEnable & ~0x2) | (FrameSkip << 1);
}

// Register WRITE function
static __inline void  S2DEC_InterruptEnable_WRITE(DtBcS2DEC_2132* pBc, UInt32 InterruptEnable)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1008, InterruptEnable);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LastFrame' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LastFrame_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x100C);
}

// Field GET functions
static __inline UInt32  S2DEC_LastFrame_GET_PlsValue(UInt32 LastFrame)
{
    return LastFrame & 0xFF;
}
static __inline UInt32  S2DEC_LastFrame_GET_VlsnrModcod(UInt32 LastFrame)
{
    return (LastFrame & 0x700) >> 8;
}
static __inline UInt32  S2DEC_LastFrame_GET_LdpcIterations(UInt32 LastFrame)
{
    return (LastFrame & 0x7F0000) >> 16;
}
static __inline UInt32  S2DEC_LastFrame_GET_LdpcDecSuccess(UInt32 LastFrame)
{
    return (LastFrame & 0x1000000) >> 24;
}
static __inline UInt32  S2DEC_LastFrame_GET_BchDecSuccess(UInt32 LastFrame)
{
    return (LastFrame & 0x2000000) >> 25;
}

// Field READ functions
static __inline UInt32  S2DEC_LastFrame_READ_PlsValue(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x100C) & 0xFF;
}
static __inline UInt32  S2DEC_LastFrame_READ_VlsnrModcod(DtBcS2DEC_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x100C) & 0x700) >> 8;
}
static __inline UInt32  S2DEC_LastFrame_READ_LdpcIterations(DtBcS2DEC_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x100C) & 0x7F0000) >> 16;
}
static __inline UInt32  S2DEC_LastFrame_READ_LdpcDecSuccess(DtBcS2DEC_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x100C) & 0x1000000) >> 24;
}
static __inline UInt32  S2DEC_LastFrame_READ_BchDecSuccess(DtBcS2DEC_2132* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0x100C) & 0x2000000) >> 25;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FrameCounter' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  S2DEC_FrameCounter_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1010);
}

// Field WRITE function
static __inline void  S2DEC_FrameCounter_WRITE(DtBcS2DEC_2132* pBc, UInt32 FrameCounter)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1010, FrameCounter);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FrameSkipCounter' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  S2DEC_FrameSkipCounter_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1014);
}

// Field WRITE function
static __inline void  S2DEC_FrameSkipCounter_WRITE(DtBcS2DEC_2132* pBc, UInt32 FrameSkipCounter)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1014, FrameSkipCounter);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcSuccessCounter' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEC_LdpcSuccessCounter_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1018);
}

// Field WRITE function
static __inline void  S2DEC_LdpcSuccessCounter_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcSuccessCounter)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1018, LdpcSuccessCounter);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItCnt' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  S2DEC_LdpcItCnt_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x101C);
}

// Field WRITE function
static __inline void  S2DEC_LdpcItCnt_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItCnt)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x101C, LdpcItCnt);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItLutEn' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEC_LdpcItLutEn_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1020) & 0x1;
}

// Field WRITE function
static __inline void  S2DEC_LdpcItLutEn_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItLutEn)
{
    DT_ASSERT((LdpcItLutEn & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x1020, LdpcItLutEn);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'BchSuccessCounter' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  S2DEC_BchSuccessCounter_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1024);
}

// Field WRITE function
static __inline void  S2DEC_BchSuccessCounter_WRITE(DtBcS2DEC_2132* pBc, UInt32 BchSuccessCounter)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1024, BchSuccessCounter);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SnrEstSignalPower' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  S2DEC_SnrEstSignalPower_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1028);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SnrEstErrorPower' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  S2DEC_SnrEstErrorPower_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x102C);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'BBRollOffDetector' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_BBRollOffDetector_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1030);
}

// Field GET functions
static __inline UInt32  S2DEC_BBRollOffDetector_GET_RollOff0Valid(UInt32 BBRollOffDetector)
{
    return BBRollOffDetector & 0x1;
}
static __inline UInt32  S2DEC_BBRollOffDetector_GET_RollOff0(UInt32 BBRollOffDetector)
{
    return (BBRollOffDetector & 0x6) >> 1;
}
static __inline UInt32  S2DEC_BBRollOffDetector_GET_RollOff1Valid(UInt32 BBRollOffDetector)
{
    return (BBRollOffDetector & 0x8) >> 3;
}
static __inline UInt32  S2DEC_BBRollOffDetector_GET_RollOff1(UInt32 BBRollOffDetector)
{
    return (BBRollOffDetector & 0x30) >> 4;
}

// Field SET functions
static __inline UInt32  S2DEC_BBRollOffDetector_SET_RollOff0Valid(UInt32 BBRollOffDetector, UInt32 RollOff0Valid)
{
    DT_ASSERT((RollOff0Valid & ~0x1) == 0);
    return (BBRollOffDetector & ~0x1) | RollOff0Valid;
}
static __inline UInt32  S2DEC_BBRollOffDetector_SET_RollOff0(UInt32 BBRollOffDetector, UInt32 RollOff0)
{
    DT_ASSERT((RollOff0 & ~0x3) == 0);
    return (BBRollOffDetector & ~0x6) | (RollOff0 << 1);
}
static __inline UInt32  S2DEC_BBRollOffDetector_SET_RollOff1Valid(UInt32 BBRollOffDetector, UInt32 RollOff1Valid)
{
    DT_ASSERT((RollOff1Valid & ~0x1) == 0);
    return (BBRollOffDetector & ~0x8) | (RollOff1Valid << 3);
}
static __inline UInt32  S2DEC_BBRollOffDetector_SET_RollOff1(UInt32 BBRollOffDetector, UInt32 RollOff1)
{
    DT_ASSERT((RollOff1 & ~0x3) == 0);
    return (BBRollOffDetector & ~0x30) | (RollOff1 << 4);
}

// Register WRITE function
static __inline void  S2DEC_BBRollOffDetector_WRITE(DtBcS2DEC_2132* pBc, UInt32 BBRollOffDetector)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1030, BBRollOffDetector);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SnrEstimatorFrames' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_SnrEstimatorFrames_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1034);
}

// Field GET function
static __inline UInt32  S2DEC_SnrEstimatorFrames_GET_SnrFrames(UInt32 SnrEstimatorFrames)
{
    return SnrEstimatorFrames & 0x3;
}

// Field SET function
static __inline UInt32  S2DEC_SnrEstimatorFrames_SET_SnrFrames(UInt32 SnrEstimatorFrames, UInt32 SnrFrames)
{
    DT_ASSERT((SnrFrames & ~0x3) == 0);
    return (SnrEstimatorFrames & ~0x3) | SnrFrames;
}

// Register WRITE function
static __inline void  S2DEC_SnrEstimatorFrames_WRITE(DtBcS2DEC_2132* pBc, UInt32 SnrEstimatorFrames)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1034, SnrEstimatorFrames);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'CounterLock' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  S2DEC_CounterLock_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1038) & 0x1;
}

// Field WRITE function
static __inline void  S2DEC_CounterLock_WRITE(DtBcS2DEC_2132* pBc, UInt32 CounterLock)
{
    DT_ASSERT((CounterLock & ~0x1) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x1038, CounterLock);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls4a5' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls4a5_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1208);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls4a5_GET_IterationsPls4a5(UInt32 LdpcItPls4a5)
{
    return LdpcItPls4a5 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls4a5_SET_IterationsPls4a5(UInt32 LdpcItPls4a5, UInt32 IterationsPls4a5)
{
    DT_ASSERT((IterationsPls4a5 & ~0x7F) == 0);
    return (LdpcItPls4a5 & ~0x7F) | IterationsPls4a5;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls4a5_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls4a5)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1208, LdpcItPls4a5);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls6a7' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls6a7_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x120C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls6a7_GET_IterationsPls6a7(UInt32 LdpcItPls6a7)
{
    return LdpcItPls6a7 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls6a7_SET_IterationsPls6a7(UInt32 LdpcItPls6a7, UInt32 IterationsPls6a7)
{
    DT_ASSERT((IterationsPls6a7 & ~0x7F) == 0);
    return (LdpcItPls6a7 & ~0x7F) | IterationsPls6a7;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls6a7_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls6a7)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x120C, LdpcItPls6a7);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls8a9' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls8a9_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1210);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls8a9_GET_IterationsPls8a9(UInt32 LdpcItPls8a9)
{
    return LdpcItPls8a9 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls8a9_SET_IterationsPls8a9(UInt32 LdpcItPls8a9, UInt32 IterationsPls8a9)
{
    DT_ASSERT((IterationsPls8a9 & ~0x7F) == 0);
    return (LdpcItPls8a9 & ~0x7F) | IterationsPls8a9;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls8a9_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls8a9)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1210, LdpcItPls8a9);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls10a11' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls10a11_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1214);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls10a11_GET_IterationsPls10a11(UInt32 LdpcItPls10a11)
{
    return LdpcItPls10a11 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls10a11_SET_IterationsPls10a11(UInt32 LdpcItPls10a11, UInt32 IterationsPls10a11)
{
    DT_ASSERT((IterationsPls10a11 & ~0x7F) == 0);
    return (LdpcItPls10a11 & ~0x7F) | IterationsPls10a11;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls10a11_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls10a11)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1214, LdpcItPls10a11);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls12a13' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls12a13_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1218);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls12a13_GET_IterationsPls12a13(UInt32 LdpcItPls12a13)
{
    return LdpcItPls12a13 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls12a13_SET_IterationsPls12a13(UInt32 LdpcItPls12a13, UInt32 IterationsPls12a13)
{
    DT_ASSERT((IterationsPls12a13 & ~0x7F) == 0);
    return (LdpcItPls12a13 & ~0x7F) | IterationsPls12a13;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls12a13_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls12a13)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1218, LdpcItPls12a13);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls14a15' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls14a15_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x121C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls14a15_GET_IterationsPls14a15(UInt32 LdpcItPls14a15)
{
    return LdpcItPls14a15 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls14a15_SET_IterationsPls14a15(UInt32 LdpcItPls14a15, UInt32 IterationsPls14a15)
{
    DT_ASSERT((IterationsPls14a15 & ~0x7F) == 0);
    return (LdpcItPls14a15 & ~0x7F) | IterationsPls14a15;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls14a15_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls14a15)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x121C, LdpcItPls14a15);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls16a17' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls16a17_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1220);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls16a17_GET_IterationsPls16a17(UInt32 LdpcItPls16a17)
{
    return LdpcItPls16a17 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls16a17_SET_IterationsPls16a17(UInt32 LdpcItPls16a17, UInt32 IterationsPls16a17)
{
    DT_ASSERT((IterationsPls16a17 & ~0x7F) == 0);
    return (LdpcItPls16a17 & ~0x7F) | IterationsPls16a17;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls16a17_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls16a17)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1220, LdpcItPls16a17);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls18a19' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls18a19_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1224);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls18a19_GET_IterationsPls18a19(UInt32 LdpcItPls18a19)
{
    return LdpcItPls18a19 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls18a19_SET_IterationsPls18a19(UInt32 LdpcItPls18a19, UInt32 IterationsPls18a19)
{
    DT_ASSERT((IterationsPls18a19 & ~0x7F) == 0);
    return (LdpcItPls18a19 & ~0x7F) | IterationsPls18a19;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls18a19_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls18a19)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1224, LdpcItPls18a19);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls20a21' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls20a21_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1228);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls20a21_GET_IterationsPls20a21(UInt32 LdpcItPls20a21)
{
    return LdpcItPls20a21 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls20a21_SET_IterationsPls20a21(UInt32 LdpcItPls20a21, UInt32 IterationsPls20a21)
{
    DT_ASSERT((IterationsPls20a21 & ~0x7F) == 0);
    return (LdpcItPls20a21 & ~0x7F) | IterationsPls20a21;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls20a21_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls20a21)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1228, LdpcItPls20a21);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls22a23' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls22a23_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x122C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls22a23_GET_IterationsPls22a23(UInt32 LdpcItPls22a23)
{
    return LdpcItPls22a23 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls22a23_SET_IterationsPls22a23(UInt32 LdpcItPls22a23, UInt32 IterationsPls22a23)
{
    DT_ASSERT((IterationsPls22a23 & ~0x7F) == 0);
    return (LdpcItPls22a23 & ~0x7F) | IterationsPls22a23;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls22a23_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls22a23)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x122C, LdpcItPls22a23);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls24a25' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls24a25_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1230);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls24a25_GET_IterationsPls24a25(UInt32 LdpcItPls24a25)
{
    return LdpcItPls24a25 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls24a25_SET_IterationsPls24a25(UInt32 LdpcItPls24a25, UInt32 IterationsPls24a25)
{
    DT_ASSERT((IterationsPls24a25 & ~0x7F) == 0);
    return (LdpcItPls24a25 & ~0x7F) | IterationsPls24a25;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls24a25_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls24a25)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1230, LdpcItPls24a25);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls26a27' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls26a27_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1234);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls26a27_GET_IterationsPls26a27(UInt32 LdpcItPls26a27)
{
    return LdpcItPls26a27 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls26a27_SET_IterationsPls26a27(UInt32 LdpcItPls26a27, UInt32 IterationsPls26a27)
{
    DT_ASSERT((IterationsPls26a27 & ~0x7F) == 0);
    return (LdpcItPls26a27 & ~0x7F) | IterationsPls26a27;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls26a27_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls26a27)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1234, LdpcItPls26a27);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls28a29' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls28a29_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1238);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls28a29_GET_IterationsPls28a29(UInt32 LdpcItPls28a29)
{
    return LdpcItPls28a29 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls28a29_SET_IterationsPls28a29(UInt32 LdpcItPls28a29, UInt32 IterationsPls28a29)
{
    DT_ASSERT((IterationsPls28a29 & ~0x7F) == 0);
    return (LdpcItPls28a29 & ~0x7F) | IterationsPls28a29;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls28a29_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls28a29)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1238, LdpcItPls28a29);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls30a31' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls30a31_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x123C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls30a31_GET_IterationsPls30a31(UInt32 LdpcItPls30a31)
{
    return LdpcItPls30a31 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls30a31_SET_IterationsPls30a31(UInt32 LdpcItPls30a31, UInt32 IterationsPls30a31)
{
    DT_ASSERT((IterationsPls30a31 & ~0x7F) == 0);
    return (LdpcItPls30a31 & ~0x7F) | IterationsPls30a31;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls30a31_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls30a31)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x123C, LdpcItPls30a31);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls32a33' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls32a33_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1240);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls32a33_GET_IterationsPls32a33(UInt32 LdpcItPls32a33)
{
    return LdpcItPls32a33 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls32a33_SET_IterationsPls32a33(UInt32 LdpcItPls32a33, UInt32 IterationsPls32a33)
{
    DT_ASSERT((IterationsPls32a33 & ~0x7F) == 0);
    return (LdpcItPls32a33 & ~0x7F) | IterationsPls32a33;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls32a33_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls32a33)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1240, LdpcItPls32a33);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls34a35' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls34a35_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1244);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls34a35_GET_IterationsPls34a35(UInt32 LdpcItPls34a35)
{
    return LdpcItPls34a35 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls34a35_SET_IterationsPls34a35(UInt32 LdpcItPls34a35, UInt32 IterationsPls34a35)
{
    DT_ASSERT((IterationsPls34a35 & ~0x7F) == 0);
    return (LdpcItPls34a35 & ~0x7F) | IterationsPls34a35;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls34a35_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls34a35)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1244, LdpcItPls34a35);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls36a37' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls36a37_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1248);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls36a37_GET_IterationsPls36a37(UInt32 LdpcItPls36a37)
{
    return LdpcItPls36a37 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls36a37_SET_IterationsPls36a37(UInt32 LdpcItPls36a37, UInt32 IterationsPls36a37)
{
    DT_ASSERT((IterationsPls36a37 & ~0x7F) == 0);
    return (LdpcItPls36a37 & ~0x7F) | IterationsPls36a37;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls36a37_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls36a37)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1248, LdpcItPls36a37);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls38a39' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls38a39_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x124C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls38a39_GET_IterationsPls38a39(UInt32 LdpcItPls38a39)
{
    return LdpcItPls38a39 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls38a39_SET_IterationsPls38a39(UInt32 LdpcItPls38a39, UInt32 IterationsPls38a39)
{
    DT_ASSERT((IterationsPls38a39 & ~0x7F) == 0);
    return (LdpcItPls38a39 & ~0x7F) | IterationsPls38a39;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls38a39_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls38a39)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x124C, LdpcItPls38a39);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls40a41' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls40a41_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1250);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls40a41_GET_IterationsPls40a41(UInt32 LdpcItPls40a41)
{
    return LdpcItPls40a41 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls40a41_SET_IterationsPls40a41(UInt32 LdpcItPls40a41, UInt32 IterationsPls40a41)
{
    DT_ASSERT((IterationsPls40a41 & ~0x7F) == 0);
    return (LdpcItPls40a41 & ~0x7F) | IterationsPls40a41;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls40a41_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls40a41)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1250, LdpcItPls40a41);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls42a43' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls42a43_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1254);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls42a43_GET_IterationsPls42a43(UInt32 LdpcItPls42a43)
{
    return LdpcItPls42a43 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls42a43_SET_IterationsPls42a43(UInt32 LdpcItPls42a43, UInt32 IterationsPls42a43)
{
    DT_ASSERT((IterationsPls42a43 & ~0x7F) == 0);
    return (LdpcItPls42a43 & ~0x7F) | IterationsPls42a43;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls42a43_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls42a43)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1254, LdpcItPls42a43);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls44a45' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls44a45_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1258);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls44a45_GET_IterationsPls44a45(UInt32 LdpcItPls44a45)
{
    return LdpcItPls44a45 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls44a45_SET_IterationsPls44a45(UInt32 LdpcItPls44a45, UInt32 IterationsPls44a45)
{
    DT_ASSERT((IterationsPls44a45 & ~0x7F) == 0);
    return (LdpcItPls44a45 & ~0x7F) | IterationsPls44a45;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls44a45_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls44a45)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1258, LdpcItPls44a45);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls46a47' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls46a47_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x125C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls46a47_GET_IterationsPls46a47(UInt32 LdpcItPls46a47)
{
    return LdpcItPls46a47 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls46a47_SET_IterationsPls46a47(UInt32 LdpcItPls46a47, UInt32 IterationsPls46a47)
{
    DT_ASSERT((IterationsPls46a47 & ~0x7F) == 0);
    return (LdpcItPls46a47 & ~0x7F) | IterationsPls46a47;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls46a47_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls46a47)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x125C, LdpcItPls46a47);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls48a49' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls48a49_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1260);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls48a49_GET_IterationsPls48a49(UInt32 LdpcItPls48a49)
{
    return LdpcItPls48a49 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls48a49_SET_IterationsPls48a49(UInt32 LdpcItPls48a49, UInt32 IterationsPls48a49)
{
    DT_ASSERT((IterationsPls48a49 & ~0x7F) == 0);
    return (LdpcItPls48a49 & ~0x7F) | IterationsPls48a49;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls48a49_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls48a49)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1260, LdpcItPls48a49);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls50a51' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls50a51_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1264);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls50a51_GET_IterationsPls50a51(UInt32 LdpcItPls50a51)
{
    return LdpcItPls50a51 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls50a51_SET_IterationsPls50a51(UInt32 LdpcItPls50a51, UInt32 IterationsPls50a51)
{
    DT_ASSERT((IterationsPls50a51 & ~0x7F) == 0);
    return (LdpcItPls50a51 & ~0x7F) | IterationsPls50a51;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls50a51_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls50a51)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1264, LdpcItPls50a51);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls52a53' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls52a53_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1268);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls52a53_GET_IterationsPls52a53(UInt32 LdpcItPls52a53)
{
    return LdpcItPls52a53 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls52a53_SET_IterationsPls52a53(UInt32 LdpcItPls52a53, UInt32 IterationsPls52a53)
{
    DT_ASSERT((IterationsPls52a53 & ~0x7F) == 0);
    return (LdpcItPls52a53 & ~0x7F) | IterationsPls52a53;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls52a53_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls52a53)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1268, LdpcItPls52a53);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls54a55' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls54a55_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x126C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls54a55_GET_IterationsPls54a55(UInt32 LdpcItPls54a55)
{
    return LdpcItPls54a55 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls54a55_SET_IterationsPls54a55(UInt32 LdpcItPls54a55, UInt32 IterationsPls54a55)
{
    DT_ASSERT((IterationsPls54a55 & ~0x7F) == 0);
    return (LdpcItPls54a55 & ~0x7F) | IterationsPls54a55;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls54a55_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls54a55)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x126C, LdpcItPls54a55);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls56a57' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls56a57_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1270);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls56a57_GET_IterationsPls56a57(UInt32 LdpcItPls56a57)
{
    return LdpcItPls56a57 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls56a57_SET_IterationsPls56a57(UInt32 LdpcItPls56a57, UInt32 IterationsPls56a57)
{
    DT_ASSERT((IterationsPls56a57 & ~0x7F) == 0);
    return (LdpcItPls56a57 & ~0x7F) | IterationsPls56a57;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls56a57_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls56a57)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1270, LdpcItPls56a57);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls58a59' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls58a59_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1274);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls58a59_GET_IterationsPls58a59(UInt32 LdpcItPls58a59)
{
    return LdpcItPls58a59 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls58a59_SET_IterationsPls58a59(UInt32 LdpcItPls58a59, UInt32 IterationsPls58a59)
{
    DT_ASSERT((IterationsPls58a59 & ~0x7F) == 0);
    return (LdpcItPls58a59 & ~0x7F) | IterationsPls58a59;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls58a59_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls58a59)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1274, LdpcItPls58a59);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls60a61' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls60a61_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1278);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls60a61_GET_IterationsPls60a61(UInt32 LdpcItPls60a61)
{
    return LdpcItPls60a61 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls60a61_SET_IterationsPls60a61(UInt32 LdpcItPls60a61, UInt32 IterationsPls60a61)
{
    DT_ASSERT((IterationsPls60a61 & ~0x7F) == 0);
    return (LdpcItPls60a61 & ~0x7F) | IterationsPls60a61;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls60a61_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls60a61)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1278, LdpcItPls60a61);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls62a63' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls62a63_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x127C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls62a63_GET_IterationsPls62a63(UInt32 LdpcItPls62a63)
{
    return LdpcItPls62a63 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls62a63_SET_IterationsPls62a63(UInt32 LdpcItPls62a63, UInt32 IterationsPls62a63)
{
    DT_ASSERT((IterationsPls62a63 & ~0x7F) == 0);
    return (LdpcItPls62a63 & ~0x7F) | IterationsPls62a63;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls62a63_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls62a63)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x127C, LdpcItPls62a63);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls64a65' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls64a65_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1280);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls64a65_GET_IterationsPls64a65(UInt32 LdpcItPls64a65)
{
    return LdpcItPls64a65 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls64a65_SET_IterationsPls64a65(UInt32 LdpcItPls64a65, UInt32 IterationsPls64a65)
{
    DT_ASSERT((IterationsPls64a65 & ~0x7F) == 0);
    return (LdpcItPls64a65 & ~0x7F) | IterationsPls64a65;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls64a65_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls64a65)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1280, LdpcItPls64a65);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls66a67' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls66a67_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1284);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls66a67_GET_IterationsPls66a67(UInt32 LdpcItPls66a67)
{
    return LdpcItPls66a67 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls66a67_SET_IterationsPls66a67(UInt32 LdpcItPls66a67, UInt32 IterationsPls66a67)
{
    DT_ASSERT((IterationsPls66a67 & ~0x7F) == 0);
    return (LdpcItPls66a67 & ~0x7F) | IterationsPls66a67;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls66a67_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls66a67)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1284, LdpcItPls66a67);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls68a69' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls68a69_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1288);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls68a69_GET_IterationsPls68a69(UInt32 LdpcItPls68a69)
{
    return LdpcItPls68a69 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls68a69_SET_IterationsPls68a69(UInt32 LdpcItPls68a69, UInt32 IterationsPls68a69)
{
    DT_ASSERT((IterationsPls68a69 & ~0x7F) == 0);
    return (LdpcItPls68a69 & ~0x7F) | IterationsPls68a69;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls68a69_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls68a69)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1288, LdpcItPls68a69);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls70a71' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls70a71_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x128C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls70a71_GET_IterationsPls70a71(UInt32 LdpcItPls70a71)
{
    return LdpcItPls70a71 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls70a71_SET_IterationsPls70a71(UInt32 LdpcItPls70a71, UInt32 IterationsPls70a71)
{
    DT_ASSERT((IterationsPls70a71 & ~0x7F) == 0);
    return (LdpcItPls70a71 & ~0x7F) | IterationsPls70a71;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls70a71_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls70a71)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x128C, LdpcItPls70a71);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls72a73' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls72a73_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1290);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls72a73_GET_IterationsPls72a73(UInt32 LdpcItPls72a73)
{
    return LdpcItPls72a73 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls72a73_SET_IterationsPls72a73(UInt32 LdpcItPls72a73, UInt32 IterationsPls72a73)
{
    DT_ASSERT((IterationsPls72a73 & ~0x7F) == 0);
    return (LdpcItPls72a73 & ~0x7F) | IterationsPls72a73;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls72a73_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls72a73)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1290, LdpcItPls72a73);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls74a75' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls74a75_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1294);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls74a75_GET_IterationsPls74a75(UInt32 LdpcItPls74a75)
{
    return LdpcItPls74a75 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls74a75_SET_IterationsPls74a75(UInt32 LdpcItPls74a75, UInt32 IterationsPls74a75)
{
    DT_ASSERT((IterationsPls74a75 & ~0x7F) == 0);
    return (LdpcItPls74a75 & ~0x7F) | IterationsPls74a75;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls74a75_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls74a75)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1294, LdpcItPls74a75);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls76a77' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls76a77_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1298);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls76a77_GET_IterationsPls76a77(UInt32 LdpcItPls76a77)
{
    return LdpcItPls76a77 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls76a77_SET_IterationsPls76a77(UInt32 LdpcItPls76a77, UInt32 IterationsPls76a77)
{
    DT_ASSERT((IterationsPls76a77 & ~0x7F) == 0);
    return (LdpcItPls76a77 & ~0x7F) | IterationsPls76a77;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls76a77_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls76a77)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1298, LdpcItPls76a77);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls78a79' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls78a79_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x129C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls78a79_GET_IterationsPls78a79(UInt32 LdpcItPls78a79)
{
    return LdpcItPls78a79 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls78a79_SET_IterationsPls78a79(UInt32 LdpcItPls78a79, UInt32 IterationsPls78a79)
{
    DT_ASSERT((IterationsPls78a79 & ~0x7F) == 0);
    return (LdpcItPls78a79 & ~0x7F) | IterationsPls78a79;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls78a79_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls78a79)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x129C, LdpcItPls78a79);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls80a81' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls80a81_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12A0);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls80a81_GET_IterationsPls80a81(UInt32 LdpcItPls80a81)
{
    return LdpcItPls80a81 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls80a81_SET_IterationsPls80a81(UInt32 LdpcItPls80a81, UInt32 IterationsPls80a81)
{
    DT_ASSERT((IterationsPls80a81 & ~0x7F) == 0);
    return (LdpcItPls80a81 & ~0x7F) | IterationsPls80a81;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls80a81_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls80a81)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12A0, LdpcItPls80a81);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls82a83' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls82a83_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12A4);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls82a83_GET_IterationsPls82a83(UInt32 LdpcItPls82a83)
{
    return LdpcItPls82a83 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls82a83_SET_IterationsPls82a83(UInt32 LdpcItPls82a83, UInt32 IterationsPls82a83)
{
    DT_ASSERT((IterationsPls82a83 & ~0x7F) == 0);
    return (LdpcItPls82a83 & ~0x7F) | IterationsPls82a83;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls82a83_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls82a83)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12A4, LdpcItPls82a83);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls84a85' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls84a85_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12A8);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls84a85_GET_IterationsPls84a85(UInt32 LdpcItPls84a85)
{
    return LdpcItPls84a85 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls84a85_SET_IterationsPls84a85(UInt32 LdpcItPls84a85, UInt32 IterationsPls84a85)
{
    DT_ASSERT((IterationsPls84a85 & ~0x7F) == 0);
    return (LdpcItPls84a85 & ~0x7F) | IterationsPls84a85;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls84a85_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls84a85)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12A8, LdpcItPls84a85);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls86a87' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls86a87_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12AC);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls86a87_GET_IterationsPls86a87(UInt32 LdpcItPls86a87)
{
    return LdpcItPls86a87 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls86a87_SET_IterationsPls86a87(UInt32 LdpcItPls86a87, UInt32 IterationsPls86a87)
{
    DT_ASSERT((IterationsPls86a87 & ~0x7F) == 0);
    return (LdpcItPls86a87 & ~0x7F) | IterationsPls86a87;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls86a87_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls86a87)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12AC, LdpcItPls86a87);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls88a89' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls88a89_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12B0);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls88a89_GET_IterationsPls88a89(UInt32 LdpcItPls88a89)
{
    return LdpcItPls88a89 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls88a89_SET_IterationsPls88a89(UInt32 LdpcItPls88a89, UInt32 IterationsPls88a89)
{
    DT_ASSERT((IterationsPls88a89 & ~0x7F) == 0);
    return (LdpcItPls88a89 & ~0x7F) | IterationsPls88a89;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls88a89_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls88a89)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12B0, LdpcItPls88a89);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls90a91' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls90a91_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12B4);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls90a91_GET_IterationsPls90a91(UInt32 LdpcItPls90a91)
{
    return LdpcItPls90a91 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls90a91_SET_IterationsPls90a91(UInt32 LdpcItPls90a91, UInt32 IterationsPls90a91)
{
    DT_ASSERT((IterationsPls90a91 & ~0x7F) == 0);
    return (LdpcItPls90a91 & ~0x7F) | IterationsPls90a91;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls90a91_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls90a91)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12B4, LdpcItPls90a91);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls92a93' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls92a93_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12B8);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls92a93_GET_IterationsPls92a93(UInt32 LdpcItPls92a93)
{
    return LdpcItPls92a93 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls92a93_SET_IterationsPls92a93(UInt32 LdpcItPls92a93, UInt32 IterationsPls92a93)
{
    DT_ASSERT((IterationsPls92a93 & ~0x7F) == 0);
    return (LdpcItPls92a93 & ~0x7F) | IterationsPls92a93;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls92a93_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls92a93)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12B8, LdpcItPls92a93);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls94a95' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls94a95_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12BC);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls94a95_GET_IterationsPls94a95(UInt32 LdpcItPls94a95)
{
    return LdpcItPls94a95 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls94a95_SET_IterationsPls94a95(UInt32 LdpcItPls94a95, UInt32 IterationsPls94a95)
{
    DT_ASSERT((IterationsPls94a95 & ~0x7F) == 0);
    return (LdpcItPls94a95 & ~0x7F) | IterationsPls94a95;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls94a95_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls94a95)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12BC, LdpcItPls94a95);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls96a97' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls96a97_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12C0);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls96a97_GET_IterationsPls96a97(UInt32 LdpcItPls96a97)
{
    return LdpcItPls96a97 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls96a97_SET_IterationsPls96a97(UInt32 LdpcItPls96a97, UInt32 IterationsPls96a97)
{
    DT_ASSERT((IterationsPls96a97 & ~0x7F) == 0);
    return (LdpcItPls96a97 & ~0x7F) | IterationsPls96a97;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls96a97_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls96a97)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12C0, LdpcItPls96a97);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls98a99' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls98a99_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12C4);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls98a99_GET_IterationsPls98a99(UInt32 LdpcItPls98a99)
{
    return LdpcItPls98a99 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls98a99_SET_IterationsPls98a99(UInt32 LdpcItPls98a99, UInt32 IterationsPls98a99)
{
    DT_ASSERT((IterationsPls98a99 & ~0x7F) == 0);
    return (LdpcItPls98a99 & ~0x7F) | IterationsPls98a99;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls98a99_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls98a99)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12C4, LdpcItPls98a99);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls100a101' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls100a101_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12C8);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls100a101_GET_IterationsPls100a101(UInt32 LdpcItPls100a101)
{
    return LdpcItPls100a101 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls100a101_SET_IterationsPls100a101(UInt32 LdpcItPls100a101, UInt32 IterationsPls100a101)
{
    DT_ASSERT((IterationsPls100a101 & ~0x7F) == 0);
    return (LdpcItPls100a101 & ~0x7F) | IterationsPls100a101;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls100a101_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls100a101)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12C8, LdpcItPls100a101);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls102a103' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls102a103_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12CC);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls102a103_GET_IterationsPls102a103(UInt32 LdpcItPls102a103)
{
    return LdpcItPls102a103 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls102a103_SET_IterationsPls102a103(UInt32 LdpcItPls102a103, UInt32 IterationsPls102a103)
{
    DT_ASSERT((IterationsPls102a103 & ~0x7F) == 0);
    return (LdpcItPls102a103 & ~0x7F) | IterationsPls102a103;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls102a103_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls102a103)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12CC, LdpcItPls102a103);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls104a105' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls104a105_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12D0);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls104a105_GET_IterationsPls104a105(UInt32 LdpcItPls104a105)
{
    return LdpcItPls104a105 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls104a105_SET_IterationsPls104a105(UInt32 LdpcItPls104a105, UInt32 IterationsPls104a105)
{
    DT_ASSERT((IterationsPls104a105 & ~0x7F) == 0);
    return (LdpcItPls104a105 & ~0x7F) | IterationsPls104a105;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls104a105_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls104a105)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12D0, LdpcItPls104a105);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls106a107' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls106a107_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12D4);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls106a107_GET_IterationsPls106a107(UInt32 LdpcItPls106a107)
{
    return LdpcItPls106a107 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls106a107_SET_IterationsPls106a107(UInt32 LdpcItPls106a107, UInt32 IterationsPls106a107)
{
    DT_ASSERT((IterationsPls106a107 & ~0x7F) == 0);
    return (LdpcItPls106a107 & ~0x7F) | IterationsPls106a107;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls106a107_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls106a107)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12D4, LdpcItPls106a107);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls108a109' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls108a109_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12D8);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls108a109_GET_IterationsPls108a109(UInt32 LdpcItPls108a109)
{
    return LdpcItPls108a109 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls108a109_SET_IterationsPls108a109(UInt32 LdpcItPls108a109, UInt32 IterationsPls108a109)
{
    DT_ASSERT((IterationsPls108a109 & ~0x7F) == 0);
    return (LdpcItPls108a109 & ~0x7F) | IterationsPls108a109;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls108a109_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls108a109)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12D8, LdpcItPls108a109);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls110a111' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls110a111_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12DC);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls110a111_GET_IterationsPls110a111(UInt32 LdpcItPls110a111)
{
    return LdpcItPls110a111 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls110a111_SET_IterationsPls110a111(UInt32 LdpcItPls110a111, UInt32 IterationsPls110a111)
{
    DT_ASSERT((IterationsPls110a111 & ~0x7F) == 0);
    return (LdpcItPls110a111 & ~0x7F) | IterationsPls110a111;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls110a111_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls110a111)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12DC, LdpcItPls110a111);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls112a113' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls112a113_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12E0);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls112a113_GET_IterationsPls112a113(UInt32 LdpcItPls112a113)
{
    return LdpcItPls112a113 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls112a113_SET_IterationsPls112a113(UInt32 LdpcItPls112a113, UInt32 IterationsPls112a113)
{
    DT_ASSERT((IterationsPls112a113 & ~0x7F) == 0);
    return (LdpcItPls112a113 & ~0x7F) | IterationsPls112a113;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls112a113_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls112a113)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12E0, LdpcItPls112a113);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls114a115' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls114a115_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12E4);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls114a115_GET_IterationsPls114a115(UInt32 LdpcItPls114a115)
{
    return LdpcItPls114a115 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls114a115_SET_IterationsPls114a115(UInt32 LdpcItPls114a115, UInt32 IterationsPls114a115)
{
    DT_ASSERT((IterationsPls114a115 & ~0x7F) == 0);
    return (LdpcItPls114a115 & ~0x7F) | IterationsPls114a115;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls114a115_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls114a115)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12E4, LdpcItPls114a115);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls116a117' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls116a117_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12E8);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls116a117_GET_IterationsPls116a117(UInt32 LdpcItPls116a117)
{
    return LdpcItPls116a117 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls116a117_SET_IterationsPls116a117(UInt32 LdpcItPls116a117, UInt32 IterationsPls116a117)
{
    DT_ASSERT((IterationsPls116a117 & ~0x7F) == 0);
    return (LdpcItPls116a117 & ~0x7F) | IterationsPls116a117;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls116a117_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls116a117)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12E8, LdpcItPls116a117);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls118a119' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls118a119_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12EC);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls118a119_GET_IterationsPls118a119(UInt32 LdpcItPls118a119)
{
    return LdpcItPls118a119 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls118a119_SET_IterationsPls118a119(UInt32 LdpcItPls118a119, UInt32 IterationsPls118a119)
{
    DT_ASSERT((IterationsPls118a119 & ~0x7F) == 0);
    return (LdpcItPls118a119 & ~0x7F) | IterationsPls118a119;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls118a119_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls118a119)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12EC, LdpcItPls118a119);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls120a121' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls120a121_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12F0);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls120a121_GET_IterationsPls120a121(UInt32 LdpcItPls120a121)
{
    return LdpcItPls120a121 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls120a121_SET_IterationsPls120a121(UInt32 LdpcItPls120a121, UInt32 IterationsPls120a121)
{
    DT_ASSERT((IterationsPls120a121 & ~0x7F) == 0);
    return (LdpcItPls120a121 & ~0x7F) | IterationsPls120a121;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls120a121_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls120a121)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12F0, LdpcItPls120a121);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls122a123' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls122a123_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12F4);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls122a123_GET_IterationsPls122a123(UInt32 LdpcItPls122a123)
{
    return LdpcItPls122a123 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls122a123_SET_IterationsPls122a123(UInt32 LdpcItPls122a123, UInt32 IterationsPls122a123)
{
    DT_ASSERT((IterationsPls122a123 & ~0x7F) == 0);
    return (LdpcItPls122a123 & ~0x7F) | IterationsPls122a123;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls122a123_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls122a123)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12F4, LdpcItPls122a123);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls124a125' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls124a125_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12F8);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls124a125_GET_IterationsPls124a125(UInt32 LdpcItPls124a125)
{
    return LdpcItPls124a125 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls124a125_SET_IterationsPls124a125(UInt32 LdpcItPls124a125, UInt32 IterationsPls124a125)
{
    DT_ASSERT((IterationsPls124a125 & ~0x7F) == 0);
    return (LdpcItPls124a125 & ~0x7F) | IterationsPls124a125;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls124a125_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls124a125)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12F8, LdpcItPls124a125);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls126a127' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls126a127_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x12FC);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls126a127_GET_IterationsPls126a127(UInt32 LdpcItPls126a127)
{
    return LdpcItPls126a127 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls126a127_SET_IterationsPls126a127(UInt32 LdpcItPls126a127, UInt32 IterationsPls126a127)
{
    DT_ASSERT((IterationsPls126a127 & ~0x7F) == 0);
    return (LdpcItPls126a127 & ~0x7F) | IterationsPls126a127;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls126a127_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls126a127)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x12FC, LdpcItPls126a127);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls128a129' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls128a129_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1300);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls128a129_GET_IterationsPls128a129(UInt32 LdpcItPls128a129)
{
    return LdpcItPls128a129 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls128a129_SET_IterationsPls128a129(UInt32 LdpcItPls128a129, UInt32 IterationsPls128a129)
{
    DT_ASSERT((IterationsPls128a129 & ~0x7F) == 0);
    return (LdpcItPls128a129 & ~0x7F) | IterationsPls128a129;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls128a129_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls128a129)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1300, LdpcItPls128a129);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls130a131' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls130a131_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1304);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls130a131_GET_IterationsPls130a131(UInt32 LdpcItPls130a131)
{
    return LdpcItPls130a131 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls130a131_SET_IterationsPls130a131(UInt32 LdpcItPls130a131, UInt32 IterationsPls130a131)
{
    DT_ASSERT((IterationsPls130a131 & ~0x7F) == 0);
    return (LdpcItPls130a131 & ~0x7F) | IterationsPls130a131;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls130a131_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls130a131)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1304, LdpcItPls130a131);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls132a133' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls132a133_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1308);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls132a133_GET_IterationsPls132a133(UInt32 LdpcItPls132a133)
{
    return LdpcItPls132a133 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls132a133_SET_IterationsPls132a133(UInt32 LdpcItPls132a133, UInt32 IterationsPls132a133)
{
    DT_ASSERT((IterationsPls132a133 & ~0x7F) == 0);
    return (LdpcItPls132a133 & ~0x7F) | IterationsPls132a133;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls132a133_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls132a133)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1308, LdpcItPls132a133);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls134a135' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls134a135_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x130C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls134a135_GET_IterationsPls134a135(UInt32 LdpcItPls134a135)
{
    return LdpcItPls134a135 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls134a135_SET_IterationsPls134a135(UInt32 LdpcItPls134a135, UInt32 IterationsPls134a135)
{
    DT_ASSERT((IterationsPls134a135 & ~0x7F) == 0);
    return (LdpcItPls134a135 & ~0x7F) | IterationsPls134a135;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls134a135_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls134a135)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x130C, LdpcItPls134a135);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls136a137' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls136a137_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1310);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls136a137_GET_IterationsPls136a137(UInt32 LdpcItPls136a137)
{
    return LdpcItPls136a137 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls136a137_SET_IterationsPls136a137(UInt32 LdpcItPls136a137, UInt32 IterationsPls136a137)
{
    DT_ASSERT((IterationsPls136a137 & ~0x7F) == 0);
    return (LdpcItPls136a137 & ~0x7F) | IterationsPls136a137;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls136a137_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls136a137)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1310, LdpcItPls136a137);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls138a139' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls138a139_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1314);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls138a139_GET_IterationsPls138a139(UInt32 LdpcItPls138a139)
{
    return LdpcItPls138a139 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls138a139_SET_IterationsPls138a139(UInt32 LdpcItPls138a139, UInt32 IterationsPls138a139)
{
    DT_ASSERT((IterationsPls138a139 & ~0x7F) == 0);
    return (LdpcItPls138a139 & ~0x7F) | IterationsPls138a139;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls138a139_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls138a139)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1314, LdpcItPls138a139);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls140a141' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls140a141_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1318);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls140a141_GET_IterationsPls140a141(UInt32 LdpcItPls140a141)
{
    return LdpcItPls140a141 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls140a141_SET_IterationsPls140a141(UInt32 LdpcItPls140a141, UInt32 IterationsPls140a141)
{
    DT_ASSERT((IterationsPls140a141 & ~0x7F) == 0);
    return (LdpcItPls140a141 & ~0x7F) | IterationsPls140a141;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls140a141_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls140a141)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1318, LdpcItPls140a141);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls142a143' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls142a143_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x131C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls142a143_GET_IterationsPls142a143(UInt32 LdpcItPls142a143)
{
    return LdpcItPls142a143 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls142a143_SET_IterationsPls142a143(UInt32 LdpcItPls142a143, UInt32 IterationsPls142a143)
{
    DT_ASSERT((IterationsPls142a143 & ~0x7F) == 0);
    return (LdpcItPls142a143 & ~0x7F) | IterationsPls142a143;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls142a143_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls142a143)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x131C, LdpcItPls142a143);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls144a145' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls144a145_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1320);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls144a145_GET_IterationsPls144a145(UInt32 LdpcItPls144a145)
{
    return LdpcItPls144a145 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls144a145_SET_IterationsPls144a145(UInt32 LdpcItPls144a145, UInt32 IterationsPls144a145)
{
    DT_ASSERT((IterationsPls144a145 & ~0x7F) == 0);
    return (LdpcItPls144a145 & ~0x7F) | IterationsPls144a145;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls144a145_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls144a145)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1320, LdpcItPls144a145);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls146a147' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls146a147_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1324);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls146a147_GET_IterationsPls146a147(UInt32 LdpcItPls146a147)
{
    return LdpcItPls146a147 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls146a147_SET_IterationsPls146a147(UInt32 LdpcItPls146a147, UInt32 IterationsPls146a147)
{
    DT_ASSERT((IterationsPls146a147 & ~0x7F) == 0);
    return (LdpcItPls146a147 & ~0x7F) | IterationsPls146a147;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls146a147_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls146a147)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1324, LdpcItPls146a147);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls148a149' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls148a149_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1328);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls148a149_GET_IterationsPls148a149(UInt32 LdpcItPls148a149)
{
    return LdpcItPls148a149 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls148a149_SET_IterationsPls148a149(UInt32 LdpcItPls148a149, UInt32 IterationsPls148a149)
{
    DT_ASSERT((IterationsPls148a149 & ~0x7F) == 0);
    return (LdpcItPls148a149 & ~0x7F) | IterationsPls148a149;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls148a149_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls148a149)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1328, LdpcItPls148a149);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls150a151' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls150a151_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x132C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls150a151_GET_IterationsPls150a151(UInt32 LdpcItPls150a151)
{
    return LdpcItPls150a151 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls150a151_SET_IterationsPls150a151(UInt32 LdpcItPls150a151, UInt32 IterationsPls150a151)
{
    DT_ASSERT((IterationsPls150a151 & ~0x7F) == 0);
    return (LdpcItPls150a151 & ~0x7F) | IterationsPls150a151;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls150a151_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls150a151)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x132C, LdpcItPls150a151);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls152a153' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls152a153_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1330);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls152a153_GET_IterationsPls152a153(UInt32 LdpcItPls152a153)
{
    return LdpcItPls152a153 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls152a153_SET_IterationsPls152a153(UInt32 LdpcItPls152a153, UInt32 IterationsPls152a153)
{
    DT_ASSERT((IterationsPls152a153 & ~0x7F) == 0);
    return (LdpcItPls152a153 & ~0x7F) | IterationsPls152a153;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls152a153_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls152a153)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1330, LdpcItPls152a153);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls154a155' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls154a155_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1334);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls154a155_GET_IterationsPls154a155(UInt32 LdpcItPls154a155)
{
    return LdpcItPls154a155 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls154a155_SET_IterationsPls154a155(UInt32 LdpcItPls154a155, UInt32 IterationsPls154a155)
{
    DT_ASSERT((IterationsPls154a155 & ~0x7F) == 0);
    return (LdpcItPls154a155 & ~0x7F) | IterationsPls154a155;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls154a155_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls154a155)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1334, LdpcItPls154a155);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls156a157' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls156a157_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1338);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls156a157_GET_IterationsPls156a157(UInt32 LdpcItPls156a157)
{
    return LdpcItPls156a157 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls156a157_SET_IterationsPls156a157(UInt32 LdpcItPls156a157, UInt32 IterationsPls156a157)
{
    DT_ASSERT((IterationsPls156a157 & ~0x7F) == 0);
    return (LdpcItPls156a157 & ~0x7F) | IterationsPls156a157;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls156a157_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls156a157)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1338, LdpcItPls156a157);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls158a159' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls158a159_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x133C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls158a159_GET_IterationsPls158a159(UInt32 LdpcItPls158a159)
{
    return LdpcItPls158a159 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls158a159_SET_IterationsPls158a159(UInt32 LdpcItPls158a159, UInt32 IterationsPls158a159)
{
    DT_ASSERT((IterationsPls158a159 & ~0x7F) == 0);
    return (LdpcItPls158a159 & ~0x7F) | IterationsPls158a159;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls158a159_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls158a159)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x133C, LdpcItPls158a159);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls160a161' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls160a161_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1340);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls160a161_GET_IterationsPls160a161(UInt32 LdpcItPls160a161)
{
    return LdpcItPls160a161 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls160a161_SET_IterationsPls160a161(UInt32 LdpcItPls160a161, UInt32 IterationsPls160a161)
{
    DT_ASSERT((IterationsPls160a161 & ~0x7F) == 0);
    return (LdpcItPls160a161 & ~0x7F) | IterationsPls160a161;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls160a161_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls160a161)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1340, LdpcItPls160a161);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls162a163' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls162a163_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1344);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls162a163_GET_IterationsPls162a163(UInt32 LdpcItPls162a163)
{
    return LdpcItPls162a163 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls162a163_SET_IterationsPls162a163(UInt32 LdpcItPls162a163, UInt32 IterationsPls162a163)
{
    DT_ASSERT((IterationsPls162a163 & ~0x7F) == 0);
    return (LdpcItPls162a163 & ~0x7F) | IterationsPls162a163;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls162a163_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls162a163)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1344, LdpcItPls162a163);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls164a165' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls164a165_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1348);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls164a165_GET_IterationsPls164a165(UInt32 LdpcItPls164a165)
{
    return LdpcItPls164a165 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls164a165_SET_IterationsPls164a165(UInt32 LdpcItPls164a165, UInt32 IterationsPls164a165)
{
    DT_ASSERT((IterationsPls164a165 & ~0x7F) == 0);
    return (LdpcItPls164a165 & ~0x7F) | IterationsPls164a165;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls164a165_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls164a165)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1348, LdpcItPls164a165);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls166a167' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls166a167_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x134C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls166a167_GET_IterationsPls166a167(UInt32 LdpcItPls166a167)
{
    return LdpcItPls166a167 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls166a167_SET_IterationsPls166a167(UInt32 LdpcItPls166a167, UInt32 IterationsPls166a167)
{
    DT_ASSERT((IterationsPls166a167 & ~0x7F) == 0);
    return (LdpcItPls166a167 & ~0x7F) | IterationsPls166a167;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls166a167_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls166a167)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x134C, LdpcItPls166a167);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls168a169' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls168a169_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1350);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls168a169_GET_IterationsPls168a169(UInt32 LdpcItPls168a169)
{
    return LdpcItPls168a169 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls168a169_SET_IterationsPls168a169(UInt32 LdpcItPls168a169, UInt32 IterationsPls168a169)
{
    DT_ASSERT((IterationsPls168a169 & ~0x7F) == 0);
    return (LdpcItPls168a169 & ~0x7F) | IterationsPls168a169;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls168a169_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls168a169)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1350, LdpcItPls168a169);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls170a171' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls170a171_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1354);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls170a171_GET_IterationsPls170a171(UInt32 LdpcItPls170a171)
{
    return LdpcItPls170a171 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls170a171_SET_IterationsPls170a171(UInt32 LdpcItPls170a171, UInt32 IterationsPls170a171)
{
    DT_ASSERT((IterationsPls170a171 & ~0x7F) == 0);
    return (LdpcItPls170a171 & ~0x7F) | IterationsPls170a171;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls170a171_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls170a171)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1354, LdpcItPls170a171);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls172a173' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls172a173_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1358);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls172a173_GET_IterationsPls172a173(UInt32 LdpcItPls172a173)
{
    return LdpcItPls172a173 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls172a173_SET_IterationsPls172a173(UInt32 LdpcItPls172a173, UInt32 IterationsPls172a173)
{
    DT_ASSERT((IterationsPls172a173 & ~0x7F) == 0);
    return (LdpcItPls172a173 & ~0x7F) | IterationsPls172a173;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls172a173_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls172a173)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1358, LdpcItPls172a173);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls174a175' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls174a175_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x135C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls174a175_GET_IterationsPls174a175(UInt32 LdpcItPls174a175)
{
    return LdpcItPls174a175 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls174a175_SET_IterationsPls174a175(UInt32 LdpcItPls174a175, UInt32 IterationsPls174a175)
{
    DT_ASSERT((IterationsPls174a175 & ~0x7F) == 0);
    return (LdpcItPls174a175 & ~0x7F) | IterationsPls174a175;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls174a175_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls174a175)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x135C, LdpcItPls174a175);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls176a177' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls176a177_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1360);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls176a177_GET_IterationsPls176a177(UInt32 LdpcItPls176a177)
{
    return LdpcItPls176a177 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls176a177_SET_IterationsPls176a177(UInt32 LdpcItPls176a177, UInt32 IterationsPls176a177)
{
    DT_ASSERT((IterationsPls176a177 & ~0x7F) == 0);
    return (LdpcItPls176a177 & ~0x7F) | IterationsPls176a177;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls176a177_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls176a177)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1360, LdpcItPls176a177);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls178a179' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls178a179_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1364);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls178a179_GET_IterationsPls178a179(UInt32 LdpcItPls178a179)
{
    return LdpcItPls178a179 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls178a179_SET_IterationsPls178a179(UInt32 LdpcItPls178a179, UInt32 IterationsPls178a179)
{
    DT_ASSERT((IterationsPls178a179 & ~0x7F) == 0);
    return (LdpcItPls178a179 & ~0x7F) | IterationsPls178a179;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls178a179_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls178a179)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1364, LdpcItPls178a179);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls180a181' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls180a181_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1368);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls180a181_GET_IterationsPls180a181(UInt32 LdpcItPls180a181)
{
    return LdpcItPls180a181 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls180a181_SET_IterationsPls180a181(UInt32 LdpcItPls180a181, UInt32 IterationsPls180a181)
{
    DT_ASSERT((IterationsPls180a181 & ~0x7F) == 0);
    return (LdpcItPls180a181 & ~0x7F) | IterationsPls180a181;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls180a181_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls180a181)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1368, LdpcItPls180a181);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls182a183' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls182a183_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x136C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls182a183_GET_IterationsPls182a183(UInt32 LdpcItPls182a183)
{
    return LdpcItPls182a183 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls182a183_SET_IterationsPls182a183(UInt32 LdpcItPls182a183, UInt32 IterationsPls182a183)
{
    DT_ASSERT((IterationsPls182a183 & ~0x7F) == 0);
    return (LdpcItPls182a183 & ~0x7F) | IterationsPls182a183;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls182a183_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls182a183)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x136C, LdpcItPls182a183);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls184a185' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls184a185_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1370);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls184a185_GET_IterationsPls184a185(UInt32 LdpcItPls184a185)
{
    return LdpcItPls184a185 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls184a185_SET_IterationsPls184a185(UInt32 LdpcItPls184a185, UInt32 IterationsPls184a185)
{
    DT_ASSERT((IterationsPls184a185 & ~0x7F) == 0);
    return (LdpcItPls184a185 & ~0x7F) | IterationsPls184a185;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls184a185_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls184a185)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1370, LdpcItPls184a185);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls186a187' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls186a187_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1374);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls186a187_GET_IterationsPls186a187(UInt32 LdpcItPls186a187)
{
    return LdpcItPls186a187 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls186a187_SET_IterationsPls186a187(UInt32 LdpcItPls186a187, UInt32 IterationsPls186a187)
{
    DT_ASSERT((IterationsPls186a187 & ~0x7F) == 0);
    return (LdpcItPls186a187 & ~0x7F) | IterationsPls186a187;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls186a187_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls186a187)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1374, LdpcItPls186a187);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls188a189' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls188a189_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1378);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls188a189_GET_IterationsPls188a189(UInt32 LdpcItPls188a189)
{
    return LdpcItPls188a189 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls188a189_SET_IterationsPls188a189(UInt32 LdpcItPls188a189, UInt32 IterationsPls188a189)
{
    DT_ASSERT((IterationsPls188a189 & ~0x7F) == 0);
    return (LdpcItPls188a189 & ~0x7F) | IterationsPls188a189;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls188a189_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls188a189)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1378, LdpcItPls188a189);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls190a191' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls190a191_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x137C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls190a191_GET_IterationsPls190a191(UInt32 LdpcItPls190a191)
{
    return LdpcItPls190a191 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls190a191_SET_IterationsPls190a191(UInt32 LdpcItPls190a191, UInt32 IterationsPls190a191)
{
    DT_ASSERT((IterationsPls190a191 & ~0x7F) == 0);
    return (LdpcItPls190a191 & ~0x7F) | IterationsPls190a191;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls190a191_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls190a191)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x137C, LdpcItPls190a191);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls192a193' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls192a193_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1380);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls192a193_GET_IterationsPls192a193(UInt32 LdpcItPls192a193)
{
    return LdpcItPls192a193 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls192a193_SET_IterationsPls192a193(UInt32 LdpcItPls192a193, UInt32 IterationsPls192a193)
{
    DT_ASSERT((IterationsPls192a193 & ~0x7F) == 0);
    return (LdpcItPls192a193 & ~0x7F) | IterationsPls192a193;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls192a193_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls192a193)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1380, LdpcItPls192a193);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls194a195' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls194a195_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1384);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls194a195_GET_IterationsPls194a195(UInt32 LdpcItPls194a195)
{
    return LdpcItPls194a195 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls194a195_SET_IterationsPls194a195(UInt32 LdpcItPls194a195, UInt32 IterationsPls194a195)
{
    DT_ASSERT((IterationsPls194a195 & ~0x7F) == 0);
    return (LdpcItPls194a195 & ~0x7F) | IterationsPls194a195;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls194a195_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls194a195)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1384, LdpcItPls194a195);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls196a197' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls196a197_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1388);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls196a197_GET_IterationsPls196a197(UInt32 LdpcItPls196a197)
{
    return LdpcItPls196a197 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls196a197_SET_IterationsPls196a197(UInt32 LdpcItPls196a197, UInt32 IterationsPls196a197)
{
    DT_ASSERT((IterationsPls196a197 & ~0x7F) == 0);
    return (LdpcItPls196a197 & ~0x7F) | IterationsPls196a197;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls196a197_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls196a197)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1388, LdpcItPls196a197);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls198a199' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls198a199_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x138C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls198a199_GET_IterationsPls198a199(UInt32 LdpcItPls198a199)
{
    return LdpcItPls198a199 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls198a199_SET_IterationsPls198a199(UInt32 LdpcItPls198a199, UInt32 IterationsPls198a199)
{
    DT_ASSERT((IterationsPls198a199 & ~0x7F) == 0);
    return (LdpcItPls198a199 & ~0x7F) | IterationsPls198a199;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls198a199_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls198a199)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x138C, LdpcItPls198a199);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls200a201' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls200a201_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1390);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls200a201_GET_IterationsPls200a201(UInt32 LdpcItPls200a201)
{
    return LdpcItPls200a201 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls200a201_SET_IterationsPls200a201(UInt32 LdpcItPls200a201, UInt32 IterationsPls200a201)
{
    DT_ASSERT((IterationsPls200a201 & ~0x7F) == 0);
    return (LdpcItPls200a201 & ~0x7F) | IterationsPls200a201;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls200a201_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls200a201)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1390, LdpcItPls200a201);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls202a203' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls202a203_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1394);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls202a203_GET_IterationsPls202a203(UInt32 LdpcItPls202a203)
{
    return LdpcItPls202a203 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls202a203_SET_IterationsPls202a203(UInt32 LdpcItPls202a203, UInt32 IterationsPls202a203)
{
    DT_ASSERT((IterationsPls202a203 & ~0x7F) == 0);
    return (LdpcItPls202a203 & ~0x7F) | IterationsPls202a203;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls202a203_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls202a203)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1394, LdpcItPls202a203);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls204a205' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls204a205_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1398);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls204a205_GET_IterationsPls204a205(UInt32 LdpcItPls204a205)
{
    return LdpcItPls204a205 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls204a205_SET_IterationsPls204a205(UInt32 LdpcItPls204a205, UInt32 IterationsPls204a205)
{
    DT_ASSERT((IterationsPls204a205 & ~0x7F) == 0);
    return (LdpcItPls204a205 & ~0x7F) | IterationsPls204a205;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls204a205_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls204a205)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1398, LdpcItPls204a205);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls206a207' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls206a207_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x139C);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls206a207_GET_IterationsPls206a207(UInt32 LdpcItPls206a207)
{
    return LdpcItPls206a207 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls206a207_SET_IterationsPls206a207(UInt32 LdpcItPls206a207, UInt32 IterationsPls206a207)
{
    DT_ASSERT((IterationsPls206a207 & ~0x7F) == 0);
    return (LdpcItPls206a207 & ~0x7F) | IterationsPls206a207;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls206a207_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls206a207)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x139C, LdpcItPls206a207);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls208a209' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls208a209_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13A0);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls208a209_GET_IterationsPls208a209(UInt32 LdpcItPls208a209)
{
    return LdpcItPls208a209 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls208a209_SET_IterationsPls208a209(UInt32 LdpcItPls208a209, UInt32 IterationsPls208a209)
{
    DT_ASSERT((IterationsPls208a209 & ~0x7F) == 0);
    return (LdpcItPls208a209 & ~0x7F) | IterationsPls208a209;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls208a209_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls208a209)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13A0, LdpcItPls208a209);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls210a211' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls210a211_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13A4);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls210a211_GET_IterationsPls210a211(UInt32 LdpcItPls210a211)
{
    return LdpcItPls210a211 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls210a211_SET_IterationsPls210a211(UInt32 LdpcItPls210a211, UInt32 IterationsPls210a211)
{
    DT_ASSERT((IterationsPls210a211 & ~0x7F) == 0);
    return (LdpcItPls210a211 & ~0x7F) | IterationsPls210a211;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls210a211_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls210a211)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13A4, LdpcItPls210a211);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls212a213' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls212a213_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13A8);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls212a213_GET_IterationsPls212a213(UInt32 LdpcItPls212a213)
{
    return LdpcItPls212a213 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls212a213_SET_IterationsPls212a213(UInt32 LdpcItPls212a213, UInt32 IterationsPls212a213)
{
    DT_ASSERT((IterationsPls212a213 & ~0x7F) == 0);
    return (LdpcItPls212a213 & ~0x7F) | IterationsPls212a213;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls212a213_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls212a213)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13A8, LdpcItPls212a213);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls214a215' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls214a215_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13AC);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls214a215_GET_IterationsPls214a215(UInt32 LdpcItPls214a215)
{
    return LdpcItPls214a215 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls214a215_SET_IterationsPls214a215(UInt32 LdpcItPls214a215, UInt32 IterationsPls214a215)
{
    DT_ASSERT((IterationsPls214a215 & ~0x7F) == 0);
    return (LdpcItPls214a215 & ~0x7F) | IterationsPls214a215;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls214a215_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls214a215)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13AC, LdpcItPls214a215);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls216a217' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls216a217_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13B0);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls216a217_GET_IterationsPls216a217(UInt32 LdpcItPls216a217)
{
    return LdpcItPls216a217 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls216a217_SET_IterationsPls216a217(UInt32 LdpcItPls216a217, UInt32 IterationsPls216a217)
{
    DT_ASSERT((IterationsPls216a217 & ~0x7F) == 0);
    return (LdpcItPls216a217 & ~0x7F) | IterationsPls216a217;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls216a217_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls216a217)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13B0, LdpcItPls216a217);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls218a219' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls218a219_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13B4);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls218a219_GET_IterationsPls218a219(UInt32 LdpcItPls218a219)
{
    return LdpcItPls218a219 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls218a219_SET_IterationsPls218a219(UInt32 LdpcItPls218a219, UInt32 IterationsPls218a219)
{
    DT_ASSERT((IterationsPls218a219 & ~0x7F) == 0);
    return (LdpcItPls218a219 & ~0x7F) | IterationsPls218a219;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls218a219_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls218a219)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13B4, LdpcItPls218a219);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls220a221' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls220a221_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13B8);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls220a221_GET_IterationsPls220a221(UInt32 LdpcItPls220a221)
{
    return LdpcItPls220a221 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls220a221_SET_IterationsPls220a221(UInt32 LdpcItPls220a221, UInt32 IterationsPls220a221)
{
    DT_ASSERT((IterationsPls220a221 & ~0x7F) == 0);
    return (LdpcItPls220a221 & ~0x7F) | IterationsPls220a221;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls220a221_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls220a221)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13B8, LdpcItPls220a221);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls222a223' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls222a223_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13BC);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls222a223_GET_IterationsPls222a223(UInt32 LdpcItPls222a223)
{
    return LdpcItPls222a223 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls222a223_SET_IterationsPls222a223(UInt32 LdpcItPls222a223, UInt32 IterationsPls222a223)
{
    DT_ASSERT((IterationsPls222a223 & ~0x7F) == 0);
    return (LdpcItPls222a223 & ~0x7F) | IterationsPls222a223;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls222a223_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls222a223)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13BC, LdpcItPls222a223);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls224a225' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls224a225_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13C0);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls224a225_GET_IterationsPls224a225(UInt32 LdpcItPls224a225)
{
    return LdpcItPls224a225 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls224a225_SET_IterationsPls224a225(UInt32 LdpcItPls224a225, UInt32 IterationsPls224a225)
{
    DT_ASSERT((IterationsPls224a225 & ~0x7F) == 0);
    return (LdpcItPls224a225 & ~0x7F) | IterationsPls224a225;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls224a225_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls224a225)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13C0, LdpcItPls224a225);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls226a227' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls226a227_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13C4);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls226a227_GET_IterationsPls226a227(UInt32 LdpcItPls226a227)
{
    return LdpcItPls226a227 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls226a227_SET_IterationsPls226a227(UInt32 LdpcItPls226a227, UInt32 IterationsPls226a227)
{
    DT_ASSERT((IterationsPls226a227 & ~0x7F) == 0);
    return (LdpcItPls226a227 & ~0x7F) | IterationsPls226a227;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls226a227_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls226a227)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13C4, LdpcItPls226a227);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls228a229' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls228a229_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13C8);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls228a229_GET_IterationsPls228a229(UInt32 LdpcItPls228a229)
{
    return LdpcItPls228a229 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls228a229_SET_IterationsPls228a229(UInt32 LdpcItPls228a229, UInt32 IterationsPls228a229)
{
    DT_ASSERT((IterationsPls228a229 & ~0x7F) == 0);
    return (LdpcItPls228a229 & ~0x7F) | IterationsPls228a229;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls228a229_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls228a229)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13C8, LdpcItPls228a229);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls230a231' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls230a231_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13CC);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls230a231_GET_IterationsPls230a231(UInt32 LdpcItPls230a231)
{
    return LdpcItPls230a231 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls230a231_SET_IterationsPls230a231(UInt32 LdpcItPls230a231, UInt32 IterationsPls230a231)
{
    DT_ASSERT((IterationsPls230a231 & ~0x7F) == 0);
    return (LdpcItPls230a231 & ~0x7F) | IterationsPls230a231;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls230a231_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls230a231)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13CC, LdpcItPls230a231);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls232a233' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls232a233_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13D0);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls232a233_GET_IterationsPls232a233(UInt32 LdpcItPls232a233)
{
    return LdpcItPls232a233 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls232a233_SET_IterationsPls232a233(UInt32 LdpcItPls232a233, UInt32 IterationsPls232a233)
{
    DT_ASSERT((IterationsPls232a233 & ~0x7F) == 0);
    return (LdpcItPls232a233 & ~0x7F) | IterationsPls232a233;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls232a233_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls232a233)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13D0, LdpcItPls232a233);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls234a235' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls234a235_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13D4);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls234a235_GET_IterationsPls234a235(UInt32 LdpcItPls234a235)
{
    return LdpcItPls234a235 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls234a235_SET_IterationsPls234a235(UInt32 LdpcItPls234a235, UInt32 IterationsPls234a235)
{
    DT_ASSERT((IterationsPls234a235 & ~0x7F) == 0);
    return (LdpcItPls234a235 & ~0x7F) | IterationsPls234a235;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls234a235_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls234a235)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13D4, LdpcItPls234a235);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls236a237' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls236a237_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13D8);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls236a237_GET_IterationsPls236a237(UInt32 LdpcItPls236a237)
{
    return LdpcItPls236a237 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls236a237_SET_IterationsPls236a237(UInt32 LdpcItPls236a237, UInt32 IterationsPls236a237)
{
    DT_ASSERT((IterationsPls236a237 & ~0x7F) == 0);
    return (LdpcItPls236a237 & ~0x7F) | IterationsPls236a237;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls236a237_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls236a237)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13D8, LdpcItPls236a237);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls238a239' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls238a239_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13DC);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls238a239_GET_IterationsPls238a239(UInt32 LdpcItPls238a239)
{
    return LdpcItPls238a239 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls238a239_SET_IterationsPls238a239(UInt32 LdpcItPls238a239, UInt32 IterationsPls238a239)
{
    DT_ASSERT((IterationsPls238a239 & ~0x7F) == 0);
    return (LdpcItPls238a239 & ~0x7F) | IterationsPls238a239;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls238a239_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls238a239)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13DC, LdpcItPls238a239);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls240a241' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls240a241_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13E0);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls240a241_GET_IterationsPls240a241(UInt32 LdpcItPls240a241)
{
    return LdpcItPls240a241 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls240a241_SET_IterationsPls240a241(UInt32 LdpcItPls240a241, UInt32 IterationsPls240a241)
{
    DT_ASSERT((IterationsPls240a241 & ~0x7F) == 0);
    return (LdpcItPls240a241 & ~0x7F) | IterationsPls240a241;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls240a241_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls240a241)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13E0, LdpcItPls240a241);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls242a243' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls242a243_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13E4);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls242a243_GET_IterationsPls242a243(UInt32 LdpcItPls242a243)
{
    return LdpcItPls242a243 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls242a243_SET_IterationsPls242a243(UInt32 LdpcItPls242a243, UInt32 IterationsPls242a243)
{
    DT_ASSERT((IterationsPls242a243 & ~0x7F) == 0);
    return (LdpcItPls242a243 & ~0x7F) | IterationsPls242a243;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls242a243_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls242a243)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13E4, LdpcItPls242a243);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls244a245' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls244a245_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13E8);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls244a245_GET_IterationsPls244a245(UInt32 LdpcItPls244a245)
{
    return LdpcItPls244a245 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls244a245_SET_IterationsPls244a245(UInt32 LdpcItPls244a245, UInt32 IterationsPls244a245)
{
    DT_ASSERT((IterationsPls244a245 & ~0x7F) == 0);
    return (LdpcItPls244a245 & ~0x7F) | IterationsPls244a245;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls244a245_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls244a245)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13E8, LdpcItPls244a245);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls246a247' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls246a247_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13EC);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls246a247_GET_IterationsPls246a247(UInt32 LdpcItPls246a247)
{
    return LdpcItPls246a247 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls246a247_SET_IterationsPls246a247(UInt32 LdpcItPls246a247, UInt32 IterationsPls246a247)
{
    DT_ASSERT((IterationsPls246a247 & ~0x7F) == 0);
    return (LdpcItPls246a247 & ~0x7F) | IterationsPls246a247;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls246a247_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls246a247)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13EC, LdpcItPls246a247);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'LdpcItPls248a249' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Register READ function
static __inline UInt32  S2DEC_LdpcItPls248a249_READ(DtBcS2DEC_2132* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x13F0);
}

// Field GET function
static __inline UInt32  S2DEC_LdpcItPls248a249_GET_IterationsPls248a249(UInt32 LdpcItPls248a249)
{
    return LdpcItPls248a249 & 0x7F;
}

// Field SET function
static __inline UInt32  S2DEC_LdpcItPls248a249_SET_IterationsPls248a249(UInt32 LdpcItPls248a249, UInt32 IterationsPls248a249)
{
    DT_ASSERT((IterationsPls248a249 & ~0x7F) == 0);
    return (LdpcItPls248a249 & ~0x7F) | IterationsPls248a249;
}

// Register WRITE function
static __inline void  S2DEC_LdpcItPls248a249_WRITE(DtBcS2DEC_2132* pBc, UInt32 LdpcItPls248a249)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x13F0, LdpcItPls248a249);
}

