//#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcIQSYNC_RegAccess.h *#*#*#*#*#*#*#*# (C) 2021 DekTec
//
// Device driver - IqSyncGate v0 (IQSYNC) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block IqSyncGate.
// These functions should solely be used by the block controller for IqSyncGate.
//
// 2021.07.01 14:30 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2020 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Getting fields 'OperationalStatus' and 'UnderflowCnt' from register 'Status':
//      UInt32  Reg_Status, OperationalStatus, UnderflowCnt;
//      Reg_Status        = IQSYNC_Status_READ(pBc);
//      OperationalStatus = IQSYNC_Status_GET_OperationalStatus(Reg_Status);
//      UnderflowCnt      = IQSYNC_Status_GET_UnderflowCnt(Reg_Status);
//
// 2. Single-function shorthand for reading field 'UnderflowCnt' from register 'Status':
//      UInt32  UnderflowCnt = IQSYNC_Status_READ_UnderflowCnt(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// IQSYNC_Control_READ
// IQSYNC_Control_SET_BlockEnable
// IQSYNC_Control_SET_OperationalMode
// IQSYNC_Control_SET_SyncMode
// IQSYNC_Control_WRITE
// IQSYNC_SampleCounterN_WRITE
// IQSYNC_SampleCounterP_WRITE
// IQSYNC_SampleCounterQ_WRITE
// IQSYNC_Status_GET_OperationalStatus
// IQSYNC_Status_GET_UnderflowCnt
// IQSYNC_Status_READ
// IQSYNC_Status_READ_OperationalStatus
// IQSYNC_Status_READ_UnderflowCnt
// IQSYNC_TooEarlyCnt_READ
// IQSYNC_TooLateCnt_READ
// IQSYNC_TriggerMode_READ
// IQSYNC_TriggerMode_SET_TimeTolerance
// IQSYNC_TriggerMode_WRITE
// IQSYNC_TriggerTimeOffset_WRITE

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'BlockEnable'
#define IQSYNC_BLKENA_DISABLED   0x0  // Block is entirely disabled
#define IQSYNC_BLKENA_ENABLED    0x1  // Block is enabled and processes data

// Value map 'OperationalMode'
#define IQSYNC_OPMODE_IDLE       0x0  // Block is inactive
#define IQSYNC_OPMODE_STANDBY    0x1  // Block is partially operational
#define IQSYNC_OPMODE_RUN        0x2  // Block performs its normal function

// Value map 'OperationalStatus'
#define IQSYNC_OPSTATUS_IDLE     0x0  // Block is inactive
#define IQSYNC_OPSTATUS_STANDBY  0x1  // Block is partially operational
#define IQSYNC_OPSTATUS_RUN      0x2  // Block performs its normal function
#define IQSYNC_OPSTATUS_ERROR    0x3  // An error has occurred

// Value map 'SyncMode'
#define IQSYNC_SYNCMODE_NOSYNC   0x0  // No synchronization.
#define IQSYNC_SYNCMODE_ONEPPS   0x1  // Synchronization using 1PPS pulses.
#define IQSYNC_SYNCMODE_TRIGGER  0x3  // Synchronization using a trigger pulse and GPS
                                      // time.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IQSYNC_Control_READ(DtBcIQSYNC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x4);
}

// Field SET functions
static __inline UInt32 IQSYNC_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32 IQSYNC_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32 IQSYNC_Control_SET_SyncMode(UInt32 Control, UInt32 SyncMode)
{
    DT_ASSERT((SyncMode & ~0x3) == 0);
    return (Control & ~0x18) | (SyncMode << 3);
}

// Register WRITE function
static __inline void IQSYNC_Control_WRITE(DtBcIQSYNC* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x4, Control);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TriggerMode' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IQSYNC_TriggerMode_READ(DtBcIQSYNC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field SET function
static __inline UInt32 IQSYNC_TriggerMode_SET_TimeTolerance(UInt32 TriggerMode, UInt32 TimeTolerance)
{
    DT_ASSERT((TimeTolerance & ~0xFFFFF) == 0);
    return (TriggerMode & ~0xFFFFF) | TimeTolerance;
}

// Register WRITE function
static __inline void IQSYNC_TriggerMode_WRITE(DtBcIQSYNC* pBc, UInt32 TriggerMode)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x8, TriggerMode);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32 IQSYNC_Status_READ(DtBcIQSYNC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC);
}

// Field GET functions
static __inline UInt32 IQSYNC_Status_GET_OperationalStatus(UInt32 Status)
{
    return (Status & 0x6) >> 1;
}
static __inline UInt32 IQSYNC_Status_GET_UnderflowCnt(UInt32 Status)
{
    return (Status & 0xFFFF0000) >> 16;
}

// Field READ functions
static __inline UInt32 IQSYNC_Status_READ_OperationalStatus(DtBcIQSYNC* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x6) >> 1;
}
static __inline UInt32 IQSYNC_Status_READ_UnderflowCnt(DtBcIQSYNC* pBc)
{
    return (DtBc_RegRead32((DtBc*)pBc, 0xC) & 0xFFFF0000) >> 16;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TooEarlyCnt' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32 IQSYNC_TooEarlyCnt_READ(DtBcIQSYNC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10) & 0xFFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TooLateCnt' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32 IQSYNC_TooLateCnt_READ(DtBcIQSYNC* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x14) & 0xFFFF;
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'TriggerTimeOffset' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void IQSYNC_TriggerTimeOffset_WRITE(DtBcIQSYNC* pBc, UInt32 TriggerTimeOffset)
{
    DT_ASSERT((TriggerTimeOffset & ~0x7FFFFFFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x18, TriggerTimeOffset);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SampleCounterN' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void IQSYNC_SampleCounterN_WRITE(DtBcIQSYNC* pBc, UInt32 SampleCounterN)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x1C, SampleCounterN);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SampleCounterP' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void IQSYNC_SampleCounterP_WRITE(DtBcIQSYNC* pBc, UInt32 SampleCounterP)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x20, SampleCounterP);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SampleCounterQ' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void IQSYNC_SampleCounterQ_WRITE(DtBcIQSYNC* pBc, UInt32 SampleCounterQ)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x24, SampleCounterQ);
}

