// *#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcIPSCHED_RegAccess.h *#*#*#*#*#*#*#*#*#*#*#*#*# 2024
//
// Device driver - IpScheduler v1 (IPSCHED) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block IpScheduler.
// These functions should solely be used by the block controller for IpScheduler.
//
// 2024.12.03 09:41:42 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND.

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2024 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN No EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//
// 1. Getting fields 'NumRtInputs' and 'JumboSupport' from register 'Config':
//      UInt32 Reg_Config, NumRtInputs, JumboSupport;
//      Reg_Config   = IPSCHED_Config_READ(Bc);
//      NumRtInputs  = IPSCHED_Config_GET_NumRtInputs(Reg_Config);
//      JumboSupport = IPSCHED_Config_GET_JumboSupport(Reg_Config);
//
// 2. Single-function shorthand for reading field 'InvalidTimeError' from register
//    'RtStat3':
//      UInt32  InvalidTimeError = IPSCHED_RtStat3_READ_InvalidTimeError(Bc);
//
// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

// +=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// IPSCHED_Config_GET_JumboSupport
// IPSCHED_Config_GET_NumRtInputs
// IPSCHED_Config_READ
// IPSCHED_Config_READ_JumboSupport
// IPSCHED_Config_READ_NumRtInputs
// IPSCHED_Control_READ
// IPSCHED_Control_SET_BlockEnable
// IPSCHED_Control_WRITE
// IPSCHED_RtPars0_READ
// IPSCHED_RtPars0_WRITE
// IPSCHED_RtPars1_READ
// IPSCHED_RtPars1_WRITE
// IPSCHED_RtPars2_READ
// IPSCHED_RtPars2_WRITE
// IPSCHED_RtPars3_READ
// IPSCHED_RtPars3_WRITE
// IPSCHED_RtPars_READ
// IPSCHED_RtPars_SET_Enable
// IPSCHED_RtPars_SET_ErrorBehavior
// IPSCHED_RtPars_SET_Flush
// IPSCHED_RtPars_SET_MaxDelay
// IPSCHED_RtPars_SET_Priority
// IPSCHED_RtPars_WRITE
// IPSCHED_RtStat0Clr_READ
// IPSCHED_RtStat0Clr_WRITE
// IPSCHED_RtStat0_READ
// IPSCHED_RtStat1Clr_READ
// IPSCHED_RtStat1Clr_WRITE
// IPSCHED_RtStat1_READ
// IPSCHED_RtStat2Clr_READ
// IPSCHED_RtStat2Clr_WRITE
// IPSCHED_RtStat2_READ
// IPSCHED_RtStat3Clr_READ
// IPSCHED_RtStat3Clr_WRITE
// IPSCHED_RtStat3_READ
// IPSCHED_RtStatClr_READ
// IPSCHED_RtStatClr_SET_ClrInvalidTimeErr
// IPSCHED_RtStatClr_SET_ClrTooEarlyCnt
// IPSCHED_RtStatClr_SET_ClrTooLateCnt
// IPSCHED_RtStatClr_WRITE
// IPSCHED_RtStat_GET_InvalidTimeError
// IPSCHED_RtStat_GET_PacketReady
// IPSCHED_RtStat_GET_PacketSending
// IPSCHED_RtStat_GET_PacketWaiting
// IPSCHED_RtStat_GET_TooEarlyCnt
// IPSCHED_RtStat_GET_TooLateCnt
// IPSCHED_RtStat_READ
// IPSCHED_RtStat_READ_InvalidTimeError
// IPSCHED_RtStat_READ_PacketReady
// IPSCHED_RtStat_READ_PacketSending
// IPSCHED_RtStat_READ_PacketWaiting
// IPSCHED_RtStat_READ_TooEarlyCnt
// IPSCHED_RtStat_READ_TooLateCnt
// IPSCHED_SchedulingOffset_WRITE

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

// =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'BlockEnable'
#define IPSCHED_BLKENA_DISABLED   0x0  // Block is entirely disabled
#define IPSCHED_BLKENA_ENABLED    0x1  // Block is enabled and processes data

// Value map 'ErrorBehavior'
#define IPSCHED_ERRBEHAV_Fatal    0x0  // Stop transmitting packets and wait for a reset.
#define IPSCHED_ERRBEHAV_Discard  0x1  // Discard the offending packet and move on to the
                                       // next one.

// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
// +=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.- Repeated register 'RtPars' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_RtPars_READ(DtBcIPSCHED* Bc, int Idx)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10 + 12*Idx);
}

// Field SET functions.
static __inline UInt32 IPSCHED_RtPars_SET_Priority(UInt32 RtPars, UInt32 Priority)
{
    DT_ASSERT((Priority & ~0xFF) == 0);
    return (RtPars & ~0xFF) | Priority;
}
static __inline UInt32 IPSCHED_RtPars_SET_Enable(UInt32 RtPars, UInt32 Enable)
{
    DT_ASSERT((Enable & ~0x1) == 0);
    return (RtPars & ~0x100) | (Enable << 8);
}
static __inline UInt32 IPSCHED_RtPars_SET_Flush(UInt32 RtPars, UInt32 Flush)
{
    DT_ASSERT((Flush & ~0x1) == 0);
    return (RtPars & ~0x200) | (Flush << 9);
}
static __inline UInt32 IPSCHED_RtPars_SET_ErrorBehavior(UInt32 RtPars, UInt32 ErrorBehavior)
{
    DT_ASSERT((ErrorBehavior & ~0x1) == 0);
    return (RtPars & ~0x400) | (ErrorBehavior << 10);
}
static __inline UInt32 IPSCHED_RtPars_SET_MaxDelay(UInt32 RtPars, UInt32 MaxDelay)
{
    DT_ASSERT((MaxDelay & ~0xFFFF) == 0);
    return (RtPars & ~0xFFFF0000) | (MaxDelay << 16);
}

// Register WRITE function.
static __inline void IPSCHED_RtPars_WRITE(DtBcIPSCHED* Bc, UInt32 RtPars, int Idx)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10 + 12*Idx, RtPars);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.- Repeated register 'RtStat' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_RtStat_READ(DtBcIPSCHED* Bc, int Idx)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x14 + 12*Idx);
}

// Field GET functions.
static __inline UInt32 IPSCHED_RtStat_GET_TooEarlyCnt(UInt32 RtStat)
{
    return RtStat & 0xFF;
}
static __inline UInt32 IPSCHED_RtStat_GET_TooLateCnt(UInt32 RtStat)
{
    return (RtStat & 0xFF00) >> 8;
}
static __inline UInt32 IPSCHED_RtStat_GET_PacketWaiting(UInt32 RtStat)
{
    return (RtStat & 0x10000) >> 16;
}
static __inline UInt32 IPSCHED_RtStat_GET_PacketReady(UInt32 RtStat)
{
    return (RtStat & 0x20000) >> 17;
}
static __inline UInt32 IPSCHED_RtStat_GET_PacketSending(UInt32 RtStat)
{
    return (RtStat & 0x40000) >> 18;
}
static __inline UInt32 IPSCHED_RtStat_GET_InvalidTimeError(UInt32 RtStat)
{
    return (RtStat & 0x80000) >> 19;
}

// Field READ functions.
static __inline UInt32 IPSCHED_RtStat_READ_TooEarlyCnt(DtBcIPSCHED* Bc, int Idx)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x14 + 12*Idx) & 0xFF;
}
static __inline UInt32 IPSCHED_RtStat_READ_TooLateCnt(DtBcIPSCHED* Bc, int Idx)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x14 + 12*Idx) & 0xFF00) >> 8;
}
static __inline UInt32 IPSCHED_RtStat_READ_PacketWaiting(DtBcIPSCHED* Bc, int Idx)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x14 + 12*Idx) & 0x10000) >> 16;
}
static __inline UInt32 IPSCHED_RtStat_READ_PacketReady(DtBcIPSCHED* Bc, int Idx)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x14 + 12*Idx) & 0x20000) >> 17;
}
static __inline UInt32 IPSCHED_RtStat_READ_PacketSending(DtBcIPSCHED* Bc, int Idx)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x14 + 12*Idx) & 0x40000) >> 18;
}
static __inline UInt32 IPSCHED_RtStat_READ_InvalidTimeError(DtBcIPSCHED* Bc, int Idx)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x14 + 12*Idx) & 0x80000) >> 19;
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.- Repeated register 'RtStatClr' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_RtStatClr_READ(DtBcIPSCHED* Bc, int Idx)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x18 + 12*Idx);
}

// Field SET functions.
static __inline UInt32 IPSCHED_RtStatClr_SET_ClrTooEarlyCnt(UInt32 RtStatClr, UInt32 ClrTooEarlyCnt)
{
    DT_ASSERT((ClrTooEarlyCnt & ~0x1) == 0);
    return (RtStatClr & ~0x1) | ClrTooEarlyCnt;
}
static __inline UInt32 IPSCHED_RtStatClr_SET_ClrTooLateCnt(UInt32 RtStatClr, UInt32 ClrTooLateCnt)
{
    DT_ASSERT((ClrTooLateCnt & ~0x1) == 0);
    return (RtStatClr & ~0x100) | (ClrTooLateCnt << 8);
}
static __inline UInt32 IPSCHED_RtStatClr_SET_ClrInvalidTimeErr(UInt32 RtStatClr, UInt32 ClrInvalidTimeErr)
{
    DT_ASSERT((ClrInvalidTimeErr & ~0x1) == 0);
    return (RtStatClr & ~0x80000) | (ClrInvalidTimeErr << 19);
}

// Register WRITE function.
static __inline void IPSCHED_RtStatClr_WRITE(DtBcIPSCHED* Bc, UInt32 RtStatClr, int Idx)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x18 + 12*Idx, RtStatClr);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_Config_READ(DtBcIPSCHED* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4);
}

// Field GET functions.
static __inline UInt32 IPSCHED_Config_GET_NumRtInputs(UInt32 Config)
{
    return Config & 0x1F;
}
static __inline UInt32 IPSCHED_Config_GET_JumboSupport(UInt32 Config)
{
    return (Config & 0x100) >> 8;
}

// Field READ functions.
static __inline UInt32 IPSCHED_Config_READ_NumRtInputs(DtBcIPSCHED* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x4) & 0x1F;
}
static __inline UInt32 IPSCHED_Config_READ_JumboSupport(DtBcIPSCHED* Bc)
{
    return (DtBc_RegRead32((DtBc*)Bc, 0x4) & 0x100) >> 8;
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_Control_READ(DtBcIPSCHED* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x8);
}

// Field SET function.
static __inline UInt32 IPSCHED_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}

// Register WRITE function.
static __inline void IPSCHED_Control_WRITE(DtBcIPSCHED* Bc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x8, Control);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SchedulingOffset' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function.
static __inline void IPSCHED_SchedulingOffset_WRITE(DtBcIPSCHED* Bc, UInt32 SchedulingOffset)
{
    DT_ASSERT((SchedulingOffset & ~0xFFFF) == 0);
    DtBc_RegWrite32((DtBc*)Bc, 0xC, SchedulingOffset);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RtPars0' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_RtPars0_READ(DtBcIPSCHED* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x10);
}

// Register WRITE function.
static __inline void IPSCHED_RtPars0_WRITE(DtBcIPSCHED* Bc, UInt32 RtPars0)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x10, RtPars0);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RtStat0' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_RtStat0_READ(DtBcIPSCHED* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x14);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RtStat0Clr' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_RtStat0Clr_READ(DtBcIPSCHED* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x18);
}

// Register WRITE function.
static __inline void IPSCHED_RtStat0Clr_WRITE(DtBcIPSCHED* Bc, UInt32 RtStat0Clr)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x18, RtStat0Clr);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RtPars1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_RtPars1_READ(DtBcIPSCHED* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x1C);
}

// Register WRITE function.
static __inline void IPSCHED_RtPars1_WRITE(DtBcIPSCHED* Bc, UInt32 RtPars1)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x1C, RtPars1);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RtStat1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_RtStat1_READ(DtBcIPSCHED* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x20);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RtStat1Clr' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_RtStat1Clr_READ(DtBcIPSCHED* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x24);
}

// Register WRITE function.
static __inline void IPSCHED_RtStat1Clr_WRITE(DtBcIPSCHED* Bc, UInt32 RtStat1Clr)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x24, RtStat1Clr);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RtPars2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_RtPars2_READ(DtBcIPSCHED* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x28);
}

// Register WRITE function.
static __inline void IPSCHED_RtPars2_WRITE(DtBcIPSCHED* Bc, UInt32 RtPars2)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x28, RtPars2);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RtStat2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_RtStat2_READ(DtBcIPSCHED* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x2C);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RtStat2Clr' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_RtStat2Clr_READ(DtBcIPSCHED* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x30);
}

// Register WRITE function.
static __inline void IPSCHED_RtStat2Clr_WRITE(DtBcIPSCHED* Bc, UInt32 RtStat2Clr)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x30, RtStat2Clr);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RtPars3' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_RtPars3_READ(DtBcIPSCHED* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x34);
}

// Register WRITE function.
static __inline void IPSCHED_RtPars3_WRITE(DtBcIPSCHED* Bc, UInt32 RtPars3)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x34, RtPars3);
}

// -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RtStat3' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_RtStat3_READ(DtBcIPSCHED* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x38);
}

// .-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'RtStat3Clr' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function.
static __inline UInt32 IPSCHED_RtStat3Clr_READ(DtBcIPSCHED* Bc)
{
    return DtBc_RegRead32((DtBc*)Bc, 0x3C);
}

// Register WRITE function.
static __inline void IPSCHED_RtStat3Clr_WRITE(DtBcIPSCHED* Bc, UInt32 RtStat3Clr)
{
    DtBc_RegWrite32((DtBc*)Bc, 0x3C, RtStat3Clr);
}

