//*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcGENL_RegAccess.h *#*#*#*#*#*#*#*#* (C) 2019 DekTec
//
// Device driver - Genlock v0 (GENL) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block Genlock.
// These functions should solely be used by the block controller for Genlock.
//
// 2019.03.14 16:01 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Single-function shorthand for reading field 'CrashLockStatus' from register
//    'Status':
//      UInt32  CrashLockStatus = GENL_Status_READ_CrashLockStatus(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// GENL_AdjustLength_WRITE
// GENL_Control_READ
// GENL_Control_SET_ArmCrashLock
// GENL_Control_SET_BlockEnable
// GENL_Control_SET_OperationalMode
// GENL_Control_SET_SdiClkSelect
// GENL_Control_WRITE
// GENL_FrameLength_WRITE
// GENL_SofTimestampNanosec_READ
// GENL_SofTimestampSec_READ
// GENL_Status_GET_CrashLockStatus
// GENL_Status_READ
// GENL_Status_READ_CrashLockStatus

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'BlockEnable'
#define GENL_BLKENA_DISABLED     0x0  // Block is entirely disabled
#define GENL_BLKENA_ENABLED      0x1  // Block is enabled and processes data

// Value map 'CrashLockStatus'
#define GENL_CRASHLOCK_NORMAL    0x0  // SoFs are generated with FrameLength rythm
#define GENL_CRASHLOCK_ARMED     0x1  // Armed and awaiting next SoF
#define GENL_CRASHLOCK_ADJUST    0x2  // Adjustment period to realign SoF generation to
                                      // genlock source

// Value map 'SdiClockSelect'
#define GENL_SDICLKSEL_NON_FRAC  0x0  // Use the non-fractional SDI clock
#define GENL_SDICLKSEL_FRAC      0x1  // Use the fractional SDI clock

// Value map 'OperationalMode'
#define GENL_OPMODE_IDLE         0x0  // Block is inactive
#define GENL_OPMODE_STANDBY      0x1  // Block is partially operational
#define GENL_OPMODE_RUN          0x2  // Block performs its normal function

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  GENL_Control_READ(DtBcGENL* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

// Field SET functions
static __inline UInt32  GENL_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32  GENL_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32  GENL_Control_SET_SdiClkSelect(UInt32 Control, UInt32 SdiClkSelect)
{
    DT_ASSERT((SdiClkSelect & ~0x1) == 0);
    return (Control & ~0x10) | (SdiClkSelect << 4);
}
static __inline UInt32  GENL_Control_SET_ArmCrashLock(UInt32 Control, UInt32 ArmCrashLock)
{
    DT_ASSERT((ArmCrashLock & ~0x1) == 0);
    return (Control & ~0x20) | (ArmCrashLock << 5);
}

// Register WRITE function
static __inline void  GENL_Control_WRITE(DtBcGENL* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x8, Control);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Status' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  GENL_Status_READ(DtBcGENL* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC);
}

// Field GET function
static __inline UInt32  GENL_Status_GET_CrashLockStatus(UInt32 Status)
{
    return Status & 0x3;
}

// Field READ function
static __inline UInt32  GENL_Status_READ_CrashLockStatus(DtBcGENL* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC) & 0x3;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'FrameLength' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field WRITE function
static __inline void  GENL_FrameLength_WRITE(DtBcGENL* pBc, UInt32 FrameLength)
{
    DT_ASSERT((FrameLength & ~0x1FFFFFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x10, FrameLength);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'AdjustLength' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void  GENL_AdjustLength_WRITE(DtBcGENL* pBc, UInt32 AdjustLength)
{
    DT_ASSERT((AdjustLength & ~0x1FFFFFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x14, AdjustLength);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SofTimestampSec' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  GENL_SofTimestampSec_READ(DtBcGENL* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x18);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'SofTimestampNanosec' -.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  GENL_SofTimestampNanosec_READ(DtBcGENL* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1C) & 0x3FFFFFFF;
}

