//*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#* DtBcCONSTSINK_RegAccess.h *#*#*#*#*#*#*# (C) 2019 DekTec
//
// Device driver - ConstRateSink v0 (CONSTSINK) - Register access functions
//
// The register access functions defined here are elementary inline functions to read
// from and write to registers of BB2.0 building block ConstRateSink.
// These functions should solely be used by the block controller for ConstRateSink.
//
// 2019.03.06 11:21 - AUTOGENERATED BY DtBlock - DO NOT EDIT THIS FILE BY HAND

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- License -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Copyright (C) 2019 DekTec Digital Video B.V.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//  1. Redistributions of source code must retain the above copyright notice, this list
//     of conditions and the following disclaimer.
//  2. Redistributions in binary format must reproduce the above copyright notice, this
//     list of conditions and the following disclaimer in the documentation.
//
// THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
// INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DEKTEC DIGITAL VIDEO BV, ITS AGENTS OR ITS EMPLOYEES BE LIABLE FOR
// ANY DIRECT, INDIRECT, CONSEQUENTIAL, INCIDENTAL, OR OTHER DAMAGES (INCLUDING DAMAGES
// FOR THE LOSS OF USE, INFORMATION, GOODWILL, PROFIT, WORK STOPPAGE, DATA, BUSINESS OR
// REVENUE) UNDER ANY CIRCUMSTANCES, OR UNDER ANY LEGAL THEORY, WHETHER IN CONTRACT, IN
// TORT, IN NEGLIGENCE, OR OTHERWISE, ARISING FROM THE USE OF, OR INABILITY TO USE THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ EXAMPLES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// 1. Single-function shorthand for reading field 'DataWidth' from register 'Config2':
//      UInt32  DataWidth = CONSTSINK_Config2_READ_DataWidth(pBc);
//
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ NOTES +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//
// A) No automatic caching is provided, the user has to manage a 'cache' of 32-bit
// register values himself. The number of register reads and writes shall be minimized,
// as these are extremely slow (hundreds of CPU cycles for PCIe bus and orders of
// magnitude longer for USB).
//
// B) To read a field, the register shall first be read into an UInt32 using a READ
// function, followed by getting the field from the UInt32 value with a GET function.
// Field READ functions (a combination of the register READ- and field GET function) are
// provided for convenience, but these should only be used if the register value is just
// needed once for getting a single field.
//
// C) No register-access functions are generated for the BlockId register at address 0,
// nor for interrupt-status registers. The driver has generic (BB-independent) functions
// available for accessing these registers.

//=+=+=+=+=+=+=+=+=+=+=+ List of Generated Register-Access Functions +=+=+=+=+=+=+=+=+=+=+

// CONSTSINK_Config1_READ_SysClockFreq
// CONSTSINK_Config2_GET_DataWidth
// CONSTSINK_Config2_READ
// CONSTSINK_Config2_READ_DataWidth
// CONSTSINK_Control_READ
// CONSTSINK_Control_SET_BlockEnable
// CONSTSINK_Control_SET_CheckData
// CONSTSINK_Control_SET_DataPattern
// CONSTSINK_Control_SET_OperationalMode
// CONSTSINK_Control_SET_StartTestInterval
// CONSTSINK_Control_SET_TestInterval
// CONSTSINK_Control_WRITE
// CONSTSINK_DataErrorCnt_READ
// CONSTSINK_DataRatePhaseIncr_WRITE
// CONSTSINK_UnderflowCnt_READ

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Include Files +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

#include "DtBc.h"                     // Block controller structs and functions

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+ Constant Definitions +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+

// Value map 'DataPattern'
#define CONSTSINK_PATTERN_INCREMENTING  0x0  // Incrementing on 32-bit basis
#define CONSTSINK_PATTERN_PRBS31        0x1  // Pseudorandom binary sequence, sequence
                                             // size 31

// Value map 'BlockEnable'
#define CONSTSINK_BLKENA_DISABLED       0x0  // Block is entirely disabled
#define CONSTSINK_BLKENA_ENABLED        0x1  // Block is enabled and processes data

// Value map 'OperationalMode'
#define CONSTSINK_OPMODE_IDLE           0x0  // Block is inactive
#define CONSTSINK_OPMODE_STANDBY        0x1  // Block is partially operational
#define CONSTSINK_OPMODE_RUN            0x2  // Block performs its normal function

//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
//=+=+=+=+=+=+=+=+=+=+=+ REGISTER-ACCESS FUNCTIONS - IMPLEMENTATION +=+=+=+=+=+=+=+=+=+=+=
//+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config1' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Field READ function
static __inline UInt32  CONSTSINK_Config1_READ_SysClockFreq(DtBcCONSTSINK* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x8);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Config2' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  CONSTSINK_Config2_READ(DtBcCONSTSINK* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC);
}

// Field GET function
static __inline UInt32  CONSTSINK_Config2_GET_DataWidth(UInt32 Config2)
{
    return Config2 & 0xFFFF;
}

// Field READ function
static __inline UInt32  CONSTSINK_Config2_READ_DataWidth(DtBcCONSTSINK* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0xC) & 0xFFFF;
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'Control' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.

// Register READ function
static __inline UInt32  CONSTSINK_Control_READ(DtBcCONSTSINK* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x10);
}

// Field SET functions
static __inline UInt32  CONSTSINK_Control_SET_BlockEnable(UInt32 Control, UInt32 BlockEnable)
{
    DT_ASSERT((BlockEnable & ~0x1) == 0);
    return (Control & ~0x1) | BlockEnable;
}
static __inline UInt32  CONSTSINK_Control_SET_OperationalMode(UInt32 Control, UInt32 OperationalMode)
{
    DT_ASSERT((OperationalMode & ~0x3) == 0);
    return (Control & ~0x6) | (OperationalMode << 1);
}
static __inline UInt32  CONSTSINK_Control_SET_DataPattern(UInt32 Control, UInt32 DataPattern)
{
    DT_ASSERT((DataPattern & ~0x1) == 0);
    return (Control & ~0x8) | (DataPattern << 3);
}
static __inline UInt32  CONSTSINK_Control_SET_TestInterval(UInt32 Control, UInt32 TestInterval)
{
    DT_ASSERT((TestInterval & ~0xFFFFF) == 0);
    return (Control & ~0xFFFFF0) | (TestInterval << 4);
}
static __inline UInt32  CONSTSINK_Control_SET_StartTestInterval(UInt32 Control, UInt32 StartTestInterval)
{
    DT_ASSERT((StartTestInterval & ~0x1) == 0);
    return (Control & ~0x1000000) | (StartTestInterval << 24);
}
static __inline UInt32  CONSTSINK_Control_SET_CheckData(UInt32 Control, UInt32 CheckData)
{
    DT_ASSERT((CheckData & ~0x1) == 0);
    return (Control & ~0x2000000) | (CheckData << 25);
}

// Register WRITE function
static __inline void  CONSTSINK_Control_WRITE(DtBcCONSTSINK* pBc, UInt32 Control)
{
    DtBc_RegWrite32((DtBc*)pBc, 0x10, Control);
}

//-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'DataRatePhaseIncr' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field WRITE function
static __inline void  CONSTSINK_DataRatePhaseIncr_WRITE(DtBcCONSTSINK* pBc, UInt32 DataRatePhaseIncr)
{
    DT_ASSERT((DataRatePhaseIncr & ~0xFFFFFF) == 0);
    DtBc_RegWrite32((DtBc*)pBc, 0x14, DataRatePhaseIncr);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'UnderflowCnt' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  CONSTSINK_UnderflowCnt_READ(DtBcCONSTSINK* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x18);
}

//.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.- Register 'DataErrorCnt' -.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-

// Field READ function
static __inline UInt32  CONSTSINK_DataErrorCnt_READ(DtBcCONSTSINK* pBc)
{
    return DtBc_RegRead32((DtBc*)pBc, 0x1C);
}

